/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.util;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.nativetask.util.NativeTaskOutput;

@InterfaceAudience.Private
public class NativeTaskOutputFiles
implements NativeTaskOutput {
    static final String TASKTRACKER_OUTPUT = "output";
    static final String REDUCE_INPUT_FILE_FORMAT_STRING = "%s/map_%d.out";
    static final String SPILL_FILE_FORMAT_STRING = "%s/%s/spill%d.out";
    static final String SPILL_INDEX_FILE_FORMAT_STRING = "%s/%s/spill%d.out.index";
    static final String OUTPUT_FILE_FORMAT_STRING = "%s/%s/file.out";
    static final String OUTPUT_FILE_INDEX_FORMAT_STRING = "%s/%s/file.out.index";
    private String id;
    private JobConf conf;
    private LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");

    public NativeTaskOutputFiles(Configuration conf, String id) {
        this.conf = new JobConf(conf);
        this.id = id;
    }

    @Override
    public Path getOutputFile() throws IOException {
        String path = String.format(OUTPUT_FILE_FORMAT_STRING, TASKTRACKER_OUTPUT, this.id);
        return this.lDirAlloc.getLocalPathToRead(path, (Configuration)this.conf);
    }

    @Override
    public Path getOutputFileForWrite(long size) throws IOException {
        String path = String.format(OUTPUT_FILE_FORMAT_STRING, TASKTRACKER_OUTPUT, this.id);
        return this.lDirAlloc.getLocalPathForWrite(path, size, (Configuration)this.conf);
    }

    @Override
    public Path getOutputIndexFile() throws IOException {
        String path = String.format(OUTPUT_FILE_INDEX_FORMAT_STRING, TASKTRACKER_OUTPUT, this.id);
        return this.lDirAlloc.getLocalPathToRead(path, (Configuration)this.conf);
    }

    @Override
    public Path getOutputIndexFileForWrite(long size) throws IOException {
        String path = String.format(OUTPUT_FILE_INDEX_FORMAT_STRING, TASKTRACKER_OUTPUT, this.id);
        return this.lDirAlloc.getLocalPathForWrite(path, size, (Configuration)this.conf);
    }

    @Override
    public Path getSpillFile(int spillNumber) throws IOException {
        String path = String.format(SPILL_FILE_FORMAT_STRING, this.id, TASKTRACKER_OUTPUT, spillNumber);
        return this.lDirAlloc.getLocalPathToRead(path, (Configuration)this.conf);
    }

    @Override
    public Path getSpillFileForWrite(int spillNumber, long size) throws IOException {
        String path = String.format(SPILL_FILE_FORMAT_STRING, this.id, TASKTRACKER_OUTPUT, spillNumber);
        return this.lDirAlloc.getLocalPathForWrite(path, size, (Configuration)this.conf);
    }

    @Override
    public Path getSpillIndexFile(int spillNumber) throws IOException {
        String path = String.format(SPILL_INDEX_FILE_FORMAT_STRING, this.id, TASKTRACKER_OUTPUT, spillNumber);
        return this.lDirAlloc.getLocalPathToRead(path, (Configuration)this.conf);
    }

    @Override
    public Path getSpillIndexFileForWrite(int spillNumber, long size) throws IOException {
        String path = String.format(SPILL_INDEX_FILE_FORMAT_STRING, this.id, TASKTRACKER_OUTPUT, spillNumber);
        return this.lDirAlloc.getLocalPathForWrite(path, size, (Configuration)this.conf);
    }

    @Override
    public Path getInputFile(int mapId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(String.format(REDUCE_INPUT_FILE_FORMAT_STRING, TASKTRACKER_OUTPUT, mapId), (Configuration)this.conf);
    }

    @Override
    public Path getInputFileForWrite(TaskID mapId, long size, Configuration conf) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(String.format(REDUCE_INPUT_FILE_FORMAT_STRING, TASKTRACKER_OUTPUT, mapId.getId()), size, conf);
    }

    @Override
    public void removeAll() throws IOException {
        this.conf.deleteLocalFiles(TASKTRACKER_OUTPUT);
    }

    @Override
    public String getOutputName(int partition) {
        return String.format("part-%05d", partition);
    }
}

