/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilterInitializer;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KMSWebServer {
    private static final Logger LOG = LoggerFactory.getLogger(KMSWebServer.class);
    private static final String NAME = "kms";
    private static final String SERVLET_PATH = "/kms";
    private final HttpServer2 httpServer;
    private final String scheme;
    private final String processName;
    private final String sessionId;
    private final JvmPauseMonitor pauseMonitor;

    KMSWebServer(Configuration conf, Configuration sslConf) throws Exception {
        KMSWebServer.deprecateEnv("KMS_TEMP", conf, "hadoop.http.temp.dir", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_HTTP_PORT", conf, "hadoop.kms.http.port", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_MAX_THREADS", conf, "hadoop.http.max.threads", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_MAX_HTTP_HEADER_SIZE", conf, "hadoop.http.max.request.header.size", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_MAX_HTTP_HEADER_SIZE", conf, "hadoop.http.max.response.header.size", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_SSL_ENABLED", conf, "hadoop.kms.ssl.enabled", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_SSL_KEYSTORE_FILE", sslConf, "ssl.server.keystore.location", "ssl-server.xml");
        KMSWebServer.deprecateEnv("KMS_SSL_KEYSTORE_PASS", sslConf, "ssl.server.keystore.password", "ssl-server.xml");
        boolean sslEnabled = conf.getBoolean("hadoop.kms.ssl.enabled", false);
        this.scheme = sslEnabled ? "https" : "http";
        this.processName = conf.get("hadoop.kms.metrics.process.name", "KMS");
        this.sessionId = conf.get("hadoop.kms.metrics.session.id");
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(conf);
        String host = conf.get("hadoop.kms.http.host", "0.0.0.0");
        int port = conf.getInt("hadoop.kms.http.port", 9600);
        URI endpoint = new URI(this.scheme, null, host, port, null, null, null);
        String configuredInitializers = conf.get("hadoop.http.filter.initializers");
        if (configuredInitializers != null) {
            String[] initializers;
            LinkedHashSet<String> target = new LinkedHashSet<String>();
            for (String init : initializers = configuredInitializers.split(",")) {
                if (init.equals(AuthenticationFilterInitializer.class.getName()) || init.equals(ProxyUserAuthenticationFilterInitializer.class.getName())) continue;
                target.add(init);
            }
            String actualInitializers = StringUtils.join((CharSequence)",", target);
            conf.set("hadoop.http.filter.initializers", actualInitializers);
        }
        this.httpServer = new HttpServer2.Builder().setName(NAME).setConf(conf).setSSLConf(sslConf).setAuthFilterConfigurationPrefix("hadoop.kms.authentication.").setACL(new AccessControlList(conf.get("hadoop.kms.http.administrators", " "))).addEndpoint(endpoint).build();
    }

    private static void deprecateEnv(String varName, Configuration conf, String propName, String confFile) {
        String value = System.getenv(varName);
        if (value == null) {
            return;
        }
        LOG.warn("Environment variable {} is deprecated and overriding property {}, please set the property in {} instead.", new Object[]{varName, propName, confFile});
        conf.set(propName, value, "environment variable " + varName);
    }

    public void start() throws IOException {
        this.httpServer.start();
        DefaultMetricsSystem.initialize((String)this.processName);
        JvmMetrics jm = JvmMetrics.initSingleton((String)this.processName, (String)this.sessionId);
        jm.setPauseMonitor(this.pauseMonitor);
        this.pauseMonitor.start();
    }

    public boolean isRunning() {
        return this.httpServer.isAlive();
    }

    public void join() throws InterruptedException {
        this.httpServer.join();
    }

    public void stop() throws Exception {
        this.httpServer.stop();
        this.pauseMonitor.stop();
        JvmMetrics.shutdownSingleton();
        DefaultMetricsSystem.shutdown();
    }

    public URL getKMSUrl() {
        InetSocketAddress addr = this.httpServer.getConnectorAddress(0);
        if (null == addr) {
            return null;
        }
        try {
            return new URL(this.scheme, addr.getHostName(), addr.getPort(), SERVLET_PATH);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("It should never happen: " + ex.getMessage(), ex);
        }
    }

    public static void main(String[] args) throws Exception {
        KMSConfiguration.validateSystemProps();
        StringUtils.startupShutdownMessage(KMSWebServer.class, (String[])args, (Logger)LOG);
        Configuration conf = KMSConfiguration.getKMSConf();
        Configuration sslConf = SSLFactory.readSSLConfiguration((Configuration)conf, (SSLFactory.Mode)SSLFactory.Mode.SERVER);
        KMSWebServer kmsWebServer = new KMSWebServer(conf, sslConf);
        kmsWebServer.start();
        kmsWebServer.join();
    }
}

