/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.CorruptedFrameException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

class RntbdObjectMapper {
    private static final SimpleFilterProvider propertyFilterProvider = new SimpleFilterProvider();
    private static final ObjectMapper objectMapper = new ObjectMapper().setFilterProvider((FilterProvider)propertyFilterProvider);
    private static volatile ObjectWriter objectWriter = null;

    private RntbdObjectMapper() {
    }

    static JsonNode readTree(ByteBuf in) {
        Objects.requireNonNull(in, "in");
        ByteBufInputStream istream = new ByteBufInputStream(in);
        try {
            return objectMapper.readTree((InputStream)istream);
        }
        catch (IOException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
    }

    static void registerPropertyFilter(Class<?> type, Class<? extends PropertyFilter> filter) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(filter, "filter");
        try {
            propertyFilterProvider.addFilter(type.getSimpleName(), filter.newInstance());
        }
        catch (ReflectiveOperationException error) {
            throw new IllegalStateException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectWriter writer() {
        if (objectWriter == null) {
            ObjectMapper objectMapper = RntbdObjectMapper.objectMapper;
            synchronized (objectMapper) {
                if (objectWriter == null) {
                    objectWriter = RntbdObjectMapper.objectMapper.writer();
                }
            }
        }
        return objectWriter;
    }
}

