/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.internal.ISessionToken;
import com.microsoft.azure.cosmosdb.internal.InternalServerErrorException;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.SessionContainer;
import com.microsoft.azure.cosmosdb.internal.SessionTokenHelper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressSelector;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.IAddressResolver;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.IStoreClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ReplicatedResourceClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.cosmosdb.rx.internal.BackoffRetryUtility;
import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;
import rx.functions.Func0;
import rx.functions.Func1;

public class StoreClient
implements IStoreClient {
    private final Logger logger = LoggerFactory.getLogger(StoreClient.class);
    private final GatewayServiceConfigurationReader serviceConfigurationReader;
    private final SessionContainer sessionContainer;
    private final ReplicatedResourceClient replicatedResourceClient;
    private final TransportClient transportClient;
    private final String ZERO_PARTITION_KEY_RANGE = "0";

    public StoreClient(Configs configs, IAddressResolver addressResolver, SessionContainer sessionContainer, GatewayServiceConfigurationReader serviceConfigurationReader, IAuthorizationTokenProvider userTokenProvider, TransportClient transportClient, boolean useMultipleWriteLocations) {
        this.transportClient = transportClient;
        this.sessionContainer = sessionContainer;
        this.serviceConfigurationReader = serviceConfigurationReader;
        this.replicatedResourceClient = new ReplicatedResourceClient(configs, new AddressSelector(addressResolver, configs.getProtocol()), (ISessionContainer)sessionContainer, this.transportClient, serviceConfigurationReader, userTokenProvider, false, useMultipleWriteLocations);
    }

    @Override
    public Single<RxDocumentServiceResponse> processMessageAsync(RxDocumentServiceRequest request, IRetryPolicy retryPolicy, Func1<RxDocumentServiceRequest, Single<RxDocumentServiceRequest>> prepareRequestAsyncDelegate) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        Func0 storeResponseDelegate = () -> this.replicatedResourceClient.invokeAsync(request, prepareRequestAsyncDelegate);
        Single storeResponse = retryPolicy != null ? BackoffRetryUtility.executeRetry((Func0)storeResponseDelegate, (IRetryPolicy)retryPolicy) : (Single)storeResponseDelegate.call();
        storeResponse = storeResponse.doOnError(e -> {
            try {
                DocumentClientException exception = (DocumentClientException)((Object)((Object)Utils.as((Object)e, DocumentClientException.class)));
                if (exception == null) {
                    return;
                }
                exception.setClientSideRequestStatistics(request.requestContext.clientSideRequestStatistics);
                this.handleUnsuccessfulStoreResponse(request, exception);
            }
            catch (Throwable throwable) {
                this.logger.error("Unexpected failure in handling orig [{}]", (Object)e.getMessage(), e);
                this.logger.error("Unexpected failure in handling orig [{}] : new [{}]", new Object[]{e.getMessage(), throwable.getMessage(), throwable});
            }
        });
        return storeResponse.flatMap(sr -> {
            try {
                return Single.just((Object)this.completeResponse((StoreResponse)sr, request));
            }
            catch (Exception e) {
                return Single.error((Throwable)e);
            }
        });
    }

    private void handleUnsuccessfulStoreResponse(RxDocumentServiceRequest request, DocumentClientException exception) {
        this.updateResponseHeader(request, exception.getResponseHeaders());
        if (!ReplicatedResourceClient.isMasterResource(request.getResourceType()) && (Exceptions.isStatusCode((DocumentClientException)exception, (int)412) || Exceptions.isStatusCode((DocumentClientException)exception, (int)409) || Exceptions.isStatusCode((DocumentClientException)exception, (int)404) && !Exceptions.isSubStatusCode((DocumentClientException)exception, (int)1002))) {
            this.captureSessionToken(request, exception.getResponseHeaders());
        }
    }

    private RxDocumentServiceResponse completeResponse(StoreResponse storeResponse, RxDocumentServiceRequest request) throws InternalServerErrorException {
        if (storeResponse.getResponseHeaderNames().length != storeResponse.getResponseHeaderValues().length) {
            throw new InternalServerErrorException("The backend response was not in the correct format.");
        }
        HashMap<String, String> headers = new HashMap<String, String>(storeResponse.getResponseHeaderNames().length);
        for (int idx = 0; idx < storeResponse.getResponseHeaderNames().length; ++idx) {
            String name = storeResponse.getResponseHeaderNames()[idx];
            String value = storeResponse.getResponseHeaderValues()[idx];
            headers.put(name, value);
        }
        this.updateResponseHeader(request, headers);
        this.captureSessionToken(request, headers);
        storeResponse.setClientSideRequestStatistics(request.requestContext.clientSideRequestStatistics);
        return new RxDocumentServiceResponse(storeResponse);
    }

    private long getLSN(Map<String, String> headers) {
        long defaultValue = -1L;
        String value = headers.get("lsn");
        if (!Strings.isNullOrEmpty((String)value)) {
            return NumberUtils.toLong((String)value, (long)defaultValue);
        }
        return defaultValue;
    }

    private void updateResponseHeader(RxDocumentServiceRequest request, Map<String, String> headers) {
        String requestConsistencyLevel = (String)request.getHeaders().get("x-ms-consistency-level");
        boolean sessionConsistency = this.serviceConfigurationReader.getDefaultConsistencyLevel() == ConsistencyLevel.Session || !Strings.isNullOrEmpty((String)requestConsistencyLevel) && Strings.areEqualIgnoreCase((String)requestConsistencyLevel, (String)ConsistencyLevel.Session.name());
        long storeLSN = this.getLSN(headers);
        if (storeLSN == -1L) {
            return;
        }
        String partitionKeyRangeId = headers.get("x-ms-documentdb-partitionkeyrangeid");
        if (Strings.isNullOrEmpty((String)partitionKeyRangeId)) {
            String inputSession = (String)request.getHeaders().get("x-ms-session-token");
            partitionKeyRangeId = !Strings.isNullOrEmpty((String)inputSession) && inputSession.indexOf(":") >= 1 ? inputSession.substring(0, inputSession.indexOf(":")) : "0";
        }
        ISessionToken sessionToken = null;
        String sessionTokenResponseHeader = headers.get("x-ms-session-token");
        if (!Strings.isNullOrEmpty((String)sessionTokenResponseHeader)) {
            sessionToken = SessionTokenHelper.parse((String)sessionTokenResponseHeader);
        }
        if (sessionToken != null) {
            headers.put("x-ms-session-token", String.format("%s:%s", partitionKeyRangeId, sessionToken.convertToString()));
        }
        headers.remove("x-ms-documentdb-partitionkeyrangeid");
    }

    private void captureSessionToken(RxDocumentServiceRequest request, Map<String, String> headers) {
        if (request.getResourceType() == ResourceType.DocumentCollection && request.getOperationType() == OperationType.Delete) {
            String resourceId = request.getIsNameBased() ? headers.get("x-ms-content-path") : request.getResourceId();
            this.sessionContainer.clearTokenByResourceId(resourceId);
        } else {
            this.sessionContainer.setSessionToken(request, headers);
        }
    }
}

