/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.net.URI;
import java.util.Map;

public class RequestRateTooLargeException
extends DocumentClientException {
    public RequestRateTooLargeException() {
        this("The request rate is too large. Please retry after sometime.", null);
    }

    public RequestRateTooLargeException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(404, error, responseHeaders);
        BridgeInternal.setLSN((DocumentClientException)this, (long)lsn);
        BridgeInternal.setPartitionKeyRangeId((DocumentClientException)this, (String)partitionKeyRangeId);
    }

    public RequestRateTooLargeException(String message, URI requestUri) {
        this(message, null, (HttpResponseHeaders)null, requestUri);
    }

    public RequestRateTooLargeException(String message, Exception innerException, URI requestUri) {
        this(message, innerException, (HttpResponseHeaders)null, requestUri);
    }

    public RequestRateTooLargeException(Exception innerException) {
        this("The request rate is too large. Please retry after sometime.", innerException, (HttpResponseHeaders)null, null);
    }

    public RequestRateTooLargeException(String message, HttpResponseHeaders headers, URI requestUri) {
        super(message, null, HttpUtils.asMap((HttpResponseHeaders)headers), 429, requestUri != null ? requestUri.toString() : null);
    }

    public RequestRateTooLargeException(String message, HttpResponseHeaders headers, String requestUri) {
        super(message, null, HttpUtils.asMap((HttpResponseHeaders)headers), 429, requestUri);
    }

    public RequestRateTooLargeException(String message, Exception innerException, HttpResponseHeaders headers, URI requestUri) {
        super(message, innerException, HttpUtils.asMap((HttpResponseHeaders)headers), 429, requestUri != null ? requestUri.toString() : null);
    }
}

