/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.ConnectionPolicy;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.DatabaseAccount;
import com.microsoft.azure.cosmosdb.ReplicationPolicy;
import com.microsoft.azure.cosmosdb.internal.BaseAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpClientUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import com.microsoft.azure.cosmosdb.rx.internal.GlobalEndpointManager;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpMethod;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.protocol.http.client.CompositeHttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Single;
import rx.functions.Action1;

public class GatewayServiceConfigurationReader {
    public static final String GATEWAY_READER_NOT_INITIALIZED = "GatewayServiceConfigurationReader has not been initialized";
    public ReplicationPolicy userReplicationPolicy;
    private ReplicationPolicy systemReplicationPolicy;
    private ConsistencyLevel consistencyLevel;
    private volatile boolean initialized;
    private URI serviceEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private Map<String, Object> queryEngineConfiguration;
    private final BaseAuthorizationTokenProvider baseAuthorizationTokenProvider;
    private final boolean hasAuthKeyResourceToken;
    private final String authKeyResourceToken;
    private CompositeHttpClient<ByteBuf, ByteBuf> httpClient;

    public GatewayServiceConfigurationReader(URI serviceEndpoint, boolean hasResourceToken, String resourceToken, ConnectionPolicy connectionPolicy, BaseAuthorizationTokenProvider baseAuthorizationTokenProvider, CompositeHttpClient<ByteBuf, ByteBuf> httpClient) {
        this.serviceEndpoint = serviceEndpoint;
        this.baseAuthorizationTokenProvider = baseAuthorizationTokenProvider;
        this.hasAuthKeyResourceToken = hasResourceToken;
        this.authKeyResourceToken = resourceToken;
        this.connectionPolicy = connectionPolicy;
        this.httpClient = httpClient;
    }

    public ReplicationPolicy getUserReplicationPolicy() {
        this.throwIfNotInitialized();
        return this.userReplicationPolicy;
    }

    public ReplicationPolicy getSystemReplicationPolicy() {
        this.throwIfNotInitialized();
        return this.systemReplicationPolicy;
    }

    public boolean enableAuthorization() {
        return true;
    }

    public ConsistencyLevel getDefaultConsistencyLevel() {
        this.throwIfNotInitialized();
        return this.consistencyLevel;
    }

    public void setDefaultConsistencyLevel(ConsistencyLevel value) {
        this.throwIfNotInitialized();
        this.consistencyLevel = value;
    }

    public Map<String, Object> getQueryEngineConfiguration() {
        this.throwIfNotInitialized();
        return this.queryEngineConfiguration;
    }

    private Single<DatabaseAccount> getDatabaseAccountAsync(URI serviceEndpoint) {
        HttpClientRequest httpRequest = HttpClientRequest.create((HttpMethod)HttpMethod.GET, (String)this.serviceEndpoint.toString());
        httpRequest.withHeader("x-ms-version", "2018-09-17");
        UserAgentContainer userAgentContainer = new UserAgentContainer();
        String userAgentSuffix = this.connectionPolicy.getUserAgentSuffix();
        if (userAgentSuffix != null && userAgentSuffix.length() > 0) {
            userAgentContainer.setSuffix(userAgentSuffix);
        }
        httpRequest.withHeader("User-Agent", userAgentContainer.getUserAgent());
        httpRequest.withHeader("x-ms-cosmos-apitype", "0x10");
        String authorizationToken = "";
        if (this.hasAuthKeyResourceToken || this.baseAuthorizationTokenProvider == null) {
            authorizationToken = HttpUtils.urlEncode((String)this.authKeyResourceToken);
        } else {
            String xDate = Utils.nowAsRFC1123();
            httpRequest.withHeader("x-ms-date", xDate);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("x-ms-date", xDate);
            authorizationToken = this.baseAuthorizationTokenProvider.generateKeyAuthorizationSignature("GET", serviceEndpoint, header);
        }
        httpRequest.withHeader("authorization", authorizationToken);
        RxClient.ServerInfo serverInfo = new RxClient.ServerInfo(serviceEndpoint.getHost(), serviceEndpoint.getPort());
        Observable clientResponseObservable = this.httpClient.submit(serverInfo, httpRequest);
        return this.toDatabaseAccountObservable((Single<HttpClientResponse<ByteBuf>>)clientResponseObservable.toSingle());
    }

    public Single<DatabaseAccount> initializeReaderAsync() {
        try {
            return GlobalEndpointManager.getDatabaseAccountFromAnyLocationsAsync((URL)this.serviceEndpoint.toURL(), new ArrayList(this.connectionPolicy.getPreferredLocations()), url -> {
                try {
                    return this.getDatabaseAccountAsync(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("URI " + url);
                }
            }).doOnSuccess((Action1)new Action1<DatabaseAccount>(){

                public void call(DatabaseAccount databaseAccount) {
                    GatewayServiceConfigurationReader.this.userReplicationPolicy = BridgeInternal.getReplicationPolicy((DatabaseAccount)databaseAccount);
                    GatewayServiceConfigurationReader.this.systemReplicationPolicy = BridgeInternal.getSystemReplicationPolicy((DatabaseAccount)databaseAccount);
                    GatewayServiceConfigurationReader.this.queryEngineConfiguration = BridgeInternal.getQueryEngineConfiuration((DatabaseAccount)databaseAccount);
                    GatewayServiceConfigurationReader.this.consistencyLevel = BridgeInternal.getConsistencyPolicy((DatabaseAccount)databaseAccount).getDefaultConsistencyLevel();
                    GatewayServiceConfigurationReader.this.initialized = true;
                }
            });
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(this.serviceEndpoint.toString(), e);
        }
    }

    private Single<DatabaseAccount> toDatabaseAccountObservable(Single<HttpClientResponse<ByteBuf>> clientResponseObservable) {
        return clientResponseObservable.flatMap(clientResponse -> HttpClientUtils.parseResponseAsync((HttpClientResponse<ByteBuf>)clientResponse).map(rxDocumentServiceResponse -> (DatabaseAccount)rxDocumentServiceResponse.getResource(DatabaseAccount.class)));
    }

    private void throwIfNotInitialized() {
        if (!this.initialized) {
            throw new IllegalArgumentException(GATEWAY_READER_NOT_INITIALIZED);
        }
    }
}

