/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import java.util.Map;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;

public class TaskContainerDefinition {
    private long duration;
    private Resource resource;
    private int priority;
    private String type;
    private int count;
    private ExecutionType executionType;
    private long allocationId = -1L;
    private long requestDelay = 0L;
    private String hostname;

    public long getDuration() {
        return this.duration;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public long getAllocationId() {
        return this.allocationId;
    }

    public long getRequestDelay() {
        return this.requestDelay;
    }

    public String getHostname() {
        return this.hostname;
    }

    public static final class Builder {
        private long duration = -1L;
        private long durationLegacy = -1L;
        private long taskStart = -1L;
        private long taskFinish = -1L;
        private Resource resource;
        private int priority = 20;
        private String type = "map";
        private int count = 1;
        private ExecutionType executionType = ExecutionType.GUARANTEED;
        private long allocationId = -1L;
        private long requestDelay = 0L;
        private String hostname;

        public static Builder create() {
            return new Builder();
        }

        public Builder withDuration(Map<String, String> jsonTask, String key) {
            if (jsonTask.containsKey(key)) {
                this.duration = Integer.parseInt(jsonTask.get(key));
            }
            return this;
        }

        public Builder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder withDurationLegacy(Map<String, String> jsonTask, String key) {
            if (jsonTask.containsKey(key)) {
                this.durationLegacy = Integer.parseInt(jsonTask.get(key));
            }
            return this;
        }

        public Builder withTaskStart(Map<String, String> jsonTask, String key) {
            if (jsonTask.containsKey(key)) {
                this.taskStart = Long.parseLong(jsonTask.get(key));
            }
            return this;
        }

        public Builder withTaskFinish(Map<String, String> jsonTask, String key) {
            if (jsonTask.containsKey(key)) {
                this.taskFinish = Long.parseLong(jsonTask.get(key));
            }
            return this;
        }

        public Builder withResource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder withPriority(Map<String, String> jsonTask, String key) {
            if (jsonTask.containsKey(key)) {
                this.priority = Integer.parseInt(jsonTask.get(key));
            }
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder withType(Map<String, String> jsonTask, String key) {
            if (jsonTask.containsKey(key)) {
                this.type = jsonTask.get(key);
            }
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withCount(Map<String, String> jsonTask, String key) {
            if (jsonTask.containsKey(key)) {
                this.count = Integer.parseInt(jsonTask.get(key));
                this.count = Math.max(this.count, 1);
            }
            return this;
        }

        public Builder withCount(int count) {
            this.count = count;
            return this;
        }

        public Builder withExecutionType(Map<String, String> jsonTask, String key) {
            if (jsonTask.containsKey(key)) {
                this.executionType = ExecutionType.valueOf((String)jsonTask.get(key));
            }
            return this;
        }

        public Builder withExecutionType(ExecutionType executionType) {
            this.executionType = executionType;
            return this;
        }

        public Builder withAllocationId(Map<String, String> jsonTask, String key) {
            if (jsonTask.containsKey(key)) {
                this.allocationId = Long.parseLong(jsonTask.get(key));
            }
            return this;
        }

        public Builder withAllocationId(long allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public Builder withRequestDelay(Map<String, String> jsonTask, String key) {
            if (jsonTask.containsKey(key)) {
                this.requestDelay = Long.parseLong(jsonTask.get(key));
                this.requestDelay = Math.max(this.requestDelay, 0L);
            }
            return this;
        }

        public Builder withRequestDelay(long requestDelay) {
            this.requestDelay = requestDelay;
            return this;
        }

        public Builder withHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public TaskContainerDefinition build() throws YarnException {
            TaskContainerDefinition taskContainerDef = new TaskContainerDefinition();
            taskContainerDef.duration = this.validateAndGetDuration(this);
            taskContainerDef.resource = this.resource;
            taskContainerDef.type = this.type;
            taskContainerDef.requestDelay = this.requestDelay;
            taskContainerDef.priority = this.priority;
            taskContainerDef.count = this.count;
            taskContainerDef.allocationId = this.allocationId;
            taskContainerDef.executionType = this.executionType;
            taskContainerDef.hostname = this.hostname;
            return taskContainerDef;
        }

        private long validateAndGetDuration(Builder builder) throws YarnException {
            long duration = 0L;
            if (builder.duration != -1L) {
                duration = builder.duration;
            } else if (builder.durationLegacy != -1L) {
                duration = builder.durationLegacy;
            } else if (builder.taskStart != -1L && builder.taskFinish != -1L) {
                duration = builder.taskFinish - builder.taskStart;
            }
            if (duration <= 0L) {
                throw new YarnException("Duration of a task shouldn't be less or equal to 0!");
            }
            return duration;
        }
    }
}

