/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader.filter;

import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineKeyValuesFilter
extends TimelineFilter {
    private TimelineCompareOp compareOp;
    private String key;
    private Set<Object> values;

    public TimelineKeyValuesFilter() {
    }

    public TimelineKeyValuesFilter(TimelineCompareOp op, String key, Set<Object> values) {
        if (op != TimelineCompareOp.EQUAL && op != TimelineCompareOp.NOT_EQUAL) {
            throw new IllegalArgumentException("TimelineCompareOp for multi value equality filter should be EQUAL or NOT_EQUAL");
        }
        this.compareOp = op;
        this.key = key;
        this.values = values;
    }

    @Override
    public TimelineFilter.TimelineFilterType getFilterType() {
        return TimelineFilter.TimelineFilterType.KEY_VALUES;
    }

    public String getKey() {
        return this.key;
    }

    public Set<Object> getValues() {
        return this.values;
    }

    public void setKeyAndValues(String keyForValues, Set<Object> vals) {
        this.key = keyForValues;
        this.values = vals;
    }

    public void setCompareOp(TimelineCompareOp op) {
        this.compareOp = op;
    }

    public TimelineCompareOp getCompareOp() {
        return this.compareOp;
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s:%s)", this.getClass().getSimpleName(), this.compareOp.name(), this.key, this.values == null ? "" : this.values.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compareOp == null ? 0 : this.compareOp.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelineKeyValuesFilter other = (TimelineKeyValuesFilter)obj;
        if (this.compareOp != other.compareOp) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }
}

