/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.util.List;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderUtils;

enum TimelineUIDConverter {
    FLOW_UID{

        @Override
        String encodeUID(TimelineReaderContext context) {
            if (context == null) {
                return null;
            }
            if (context.getClusterId() == null || context.getUserId() == null || context.getFlowName() == null) {
                return null;
            }
            String[] flowNameTupleArr = new String[]{context.getClusterId(), context.getUserId(), context.getFlowName()};
            return TimelineUIDConverter.joinAndEscapeUIDParts(flowNameTupleArr);
        }

        @Override
        TimelineReaderContext decodeUID(String uId) throws Exception {
            if (uId == null) {
                return null;
            }
            List flowNameTupleList = TimelineUIDConverter.splitUID(uId);
            if (flowNameTupleList.size() != 3) {
                return null;
            }
            return new TimelineReaderContext((String)flowNameTupleList.get(0), (String)flowNameTupleList.get(1), (String)flowNameTupleList.get(2), null, null, null, null);
        }
    }
    ,
    FLOWRUN_UID{

        @Override
        String encodeUID(TimelineReaderContext context) {
            if (context == null) {
                return null;
            }
            if (context.getClusterId() == null || context.getUserId() == null || context.getFlowName() == null || context.getFlowRunId() == null) {
                return null;
            }
            String[] flowRunTupleArr = new String[]{context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId().toString()};
            return TimelineUIDConverter.joinAndEscapeUIDParts(flowRunTupleArr);
        }

        @Override
        TimelineReaderContext decodeUID(String uId) throws Exception {
            if (uId == null) {
                return null;
            }
            List flowRunTupleList = TimelineUIDConverter.splitUID(uId);
            if (flowRunTupleList.size() != 4) {
                return null;
            }
            return new TimelineReaderContext((String)flowRunTupleList.get(0), (String)flowRunTupleList.get(1), (String)flowRunTupleList.get(2), Long.parseLong((String)flowRunTupleList.get(3)), null, null, null);
        }
    }
    ,
    APPLICATION_UID{

        @Override
        String encodeUID(TimelineReaderContext context) {
            if (context == null) {
                return null;
            }
            if (context.getClusterId() == null || context.getAppId() == null) {
                return null;
            }
            if (context.getUserId() != null && context.getFlowName() != null && context.getFlowRunId() != null) {
                String[] appTupleArr = new String[]{context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId().toString(), context.getAppId()};
                return TimelineUIDConverter.joinAndEscapeUIDParts(appTupleArr);
            }
            String[] appTupleArr = new String[]{context.getClusterId(), context.getAppId()};
            return TimelineUIDConverter.joinAndEscapeUIDParts(appTupleArr);
        }

        @Override
        TimelineReaderContext decodeUID(String uId) throws Exception {
            if (uId == null) {
                return null;
            }
            List appTupleList = TimelineUIDConverter.splitUID(uId);
            if (appTupleList.size() == 5) {
                return new TimelineReaderContext((String)appTupleList.get(0), (String)appTupleList.get(1), (String)appTupleList.get(2), Long.parseLong((String)appTupleList.get(3)), (String)appTupleList.get(4), null, null);
            }
            if (appTupleList.size() == 2) {
                return new TimelineReaderContext((String)appTupleList.get(0), null, null, null, (String)appTupleList.get(1), null, null);
            }
            return null;
        }
    }
    ,
    SUB_APPLICATION_ENTITY_UID{

        @Override
        String encodeUID(TimelineReaderContext context) {
            if (context == null) {
                return null;
            }
            if (context.getClusterId() == null || context.getDoAsUser() == null || context.getEntityType() == null || context.getEntityId() == null) {
                return null;
            }
            String[] entityTupleArr = new String[]{context.getClusterId(), context.getDoAsUser(), context.getEntityType(), context.getEntityIdPrefix().toString(), context.getEntityId()};
            return TimelineUIDConverter.joinAndEscapeUIDParts(entityTupleArr);
        }

        @Override
        TimelineReaderContext decodeUID(String uId) throws Exception {
            if (uId == null) {
                return null;
            }
            List entityTupleList = TimelineUIDConverter.splitUID(uId);
            if (entityTupleList.size() == 5) {
                return new TimelineReaderContext((String)entityTupleList.get(0), null, null, null, null, (String)entityTupleList.get(2), Long.parseLong((String)entityTupleList.get(3)), (String)entityTupleList.get(4), (String)entityTupleList.get(1));
            }
            return null;
        }
    }
    ,
    GENERIC_ENTITY_UID{

        @Override
        String encodeUID(TimelineReaderContext context) {
            if (context == null) {
                return null;
            }
            if (context.getClusterId() == null || context.getAppId() == null || context.getEntityType() == null || context.getEntityId() == null) {
                return null;
            }
            if (context.getUserId() != null && context.getFlowName() != null && context.getFlowRunId() != null) {
                String[] entityTupleArr = new String[]{context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId().toString(), context.getAppId(), context.getEntityType(), context.getEntityIdPrefix().toString(), context.getEntityId()};
                return TimelineUIDConverter.joinAndEscapeUIDParts(entityTupleArr);
            }
            String[] entityTupleArr = new String[]{context.getClusterId(), context.getAppId(), context.getEntityType(), context.getEntityIdPrefix().toString(), context.getEntityId()};
            return TimelineUIDConverter.joinAndEscapeUIDParts(entityTupleArr);
        }

        @Override
        TimelineReaderContext decodeUID(String uId) throws Exception {
            if (uId == null) {
                return null;
            }
            List entityTupleList = TimelineUIDConverter.splitUID(uId);
            if (entityTupleList.size() == 8) {
                return new TimelineReaderContext((String)entityTupleList.get(0), (String)entityTupleList.get(1), (String)entityTupleList.get(2), Long.parseLong((String)entityTupleList.get(3)), (String)entityTupleList.get(4), (String)entityTupleList.get(5), Long.parseLong((String)entityTupleList.get(6)), (String)entityTupleList.get(7));
            }
            if (entityTupleList.size() == 5) {
                return new TimelineReaderContext((String)entityTupleList.get(0), null, null, null, (String)entityTupleList.get(1), (String)entityTupleList.get(2), Long.parseLong((String)entityTupleList.get(3)), (String)entityTupleList.get(4));
            }
            return null;
        }
    };


    private static List<String> splitUID(String uid) throws IllegalArgumentException {
        return TimelineReaderUtils.split(uid);
    }

    private static String joinAndEscapeUIDParts(String[] parts) {
        return TimelineReaderUtils.joinAndEscapeStrings(parts);
    }

    abstract String encodeUID(TimelineReaderContext var1);

    abstract TimelineReaderContext decodeUID(String var1) throws Exception;
}

