/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.tools.federation.RouterAdmin;
import org.apache.hadoop.ipc.RefreshHandler;
import org.apache.hadoop.ipc.RefreshRegistry;
import org.apache.hadoop.ipc.RefreshResponse;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRouterAdminGenericRefresh {
    private static Router router;
    private static RouterAdmin admin;
    private static RefreshHandler firstHandler;
    private static RefreshHandler secondHandler;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        router = new Router();
        Configuration config = new RouterConfigBuilder().admin().rpc().build();
        router.init(config);
        router.start();
        admin = new RouterAdmin(config);
    }

    @AfterClass
    public static void tearDownBeforeClass() throws IOException {
        if (router != null) {
            router.stop();
            router.close();
        }
    }

    @Before
    public void setUp() throws Exception {
        firstHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)firstHandler.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenReturn((Object)RefreshResponse.successResponse());
        RefreshRegistry.defaultRegistry().register("firstHandler", firstHandler);
        secondHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)secondHandler.handleRefresh("secondHandler", new String[]{"one", "two"})).thenReturn((Object)new RefreshResponse(3, "three"));
        Mockito.when((Object)secondHandler.handleRefresh("secondHandler", new String[]{"one"})).thenReturn((Object)new RefreshResponse(2, "two"));
        RefreshRegistry.defaultRegistry().register("secondHandler", secondHandler);
    }

    @After
    public void tearDown() throws Exception {
        RefreshRegistry.defaultRegistry().unregisterAll("firstHandler");
        RefreshRegistry.defaultRegistry().unregisterAll("secondHandler");
    }

    @Test
    public void testInvalidCommand() throws Exception {
        String[] args = new String[]{"-refreshRouterArgs", "nn"};
        int exitCode = admin.run(args);
        Assert.assertEquals((String)"RouterAdmin should fail due to bad args", (long)-1L, (long)exitCode);
    }

    @Test
    public void testInvalidIdentifier() throws Exception {
        String[] argv = new String[]{"-refreshRouterArgs", "localhost:" + router.getAdminServerAddress().getPort(), "unregisteredIdentity"};
        int exitCode = admin.run(argv);
        Assert.assertEquals((String)"RouterAdmin should fail due to no handler registered", (long)-1L, (long)exitCode);
    }

    @Test
    public void testValidIdentifier() throws Exception {
        String[] args = new String[]{"-refreshRouterArgs", "localhost:" + router.getAdminServerAddress().getPort(), "firstHandler"};
        int exitCode = admin.run(args);
        Assert.assertEquals((String)"RouterAdmin should succeed", (long)0L, (long)exitCode);
        ((RefreshHandler)Mockito.verify((Object)firstHandler)).handleRefresh("firstHandler", new String[0]);
        ((RefreshHandler)Mockito.verify((Object)secondHandler, (VerificationMode)Mockito.never())).handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class));
    }

    @Test
    public void testVariableArgs() throws Exception {
        String[] args = new String[]{"-refreshRouterArgs", "localhost:" + router.getAdminServerAddress().getPort(), "secondHandler", "one"};
        int exitCode = admin.run(args);
        Assert.assertEquals((String)"RouterAdmin should return 2", (long)2L, (long)exitCode);
        exitCode = admin.run(new String[]{"-refreshRouterArgs", "localhost:" + router.getAdminServerAddress().getPort(), "secondHandler", "one", "two"});
        Assert.assertEquals((String)"RouterAdmin should now return 3", (long)3L, (long)exitCode);
        ((RefreshHandler)Mockito.verify((Object)secondHandler)).handleRefresh("secondHandler", new String[]{"one"});
        ((RefreshHandler)Mockito.verify((Object)secondHandler)).handleRefresh("secondHandler", new String[]{"one", "two"});
    }

    @Test
    public void testUnregistration() throws Exception {
        RefreshRegistry.defaultRegistry().unregisterAll("firstHandler");
        String[] args = new String[]{"-refreshRouterArgs", "localhost:" + router.getAdminServerAddress().getPort(), "firstHandler"};
        int exitCode = admin.run(args);
        Assert.assertEquals((String)"RouterAdmin should return -1", (long)-1L, (long)exitCode);
    }

    @Test
    public void testUnregistrationReturnValue() {
        RefreshHandler mockHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        RefreshRegistry.defaultRegistry().register("test", mockHandler);
        boolean ret = RefreshRegistry.defaultRegistry().unregister("test", mockHandler);
        Assert.assertTrue((boolean)ret);
    }

    @Test
    public void testMultipleRegistration() throws Exception {
        RefreshRegistry.defaultRegistry().register("sharedId", firstHandler);
        RefreshRegistry.defaultRegistry().register("sharedId", secondHandler);
        String[] args = new String[]{"-refreshRouterArgs", "localhost:" + router.getAdminServerAddress().getPort(), "sharedId", "one"};
        int exitCode = admin.run(args);
        Assert.assertEquals((long)-1L, (long)exitCode);
        ((RefreshHandler)Mockito.verify((Object)firstHandler)).handleRefresh("sharedId", new String[]{"one"});
        ((RefreshHandler)Mockito.verify((Object)secondHandler)).handleRefresh("sharedId", new String[]{"one"});
        RefreshRegistry.defaultRegistry().unregisterAll("sharedId");
    }

    @Test
    public void testMultipleReturnCodeMerging() throws Exception {
        RefreshHandler handlerOne = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)handlerOne.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenReturn((Object)new RefreshResponse(23, "Twenty Three"));
        RefreshHandler handlerTwo = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)handlerTwo.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenReturn((Object)new RefreshResponse(10, "Ten"));
        RefreshRegistry.defaultRegistry().register("shared", handlerOne);
        RefreshRegistry.defaultRegistry().register("shared", handlerTwo);
        String[] args = new String[]{"-refreshRouterArgs", "localhost:" + router.getAdminServerAddress().getPort(), "shared"};
        int exitCode = admin.run(args);
        Assert.assertEquals((long)-1L, (long)exitCode);
        ((RefreshHandler)Mockito.verify((Object)handlerOne)).handleRefresh("shared", new String[0]);
        ((RefreshHandler)Mockito.verify((Object)handlerTwo)).handleRefresh("shared", new String[0]);
        RefreshRegistry.defaultRegistry().unregisterAll("shared");
    }

    @Test
    public void testExceptionResultsInNormalError() throws Exception {
        RefreshHandler exceptionalHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)exceptionalHandler.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenThrow(new Throwable[]{new RuntimeException("Exceptional Handler Throws Exception")});
        RefreshHandler otherExceptionalHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)otherExceptionalHandler.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenThrow(new Throwable[]{new RuntimeException("More Exceptions")});
        RefreshRegistry.defaultRegistry().register("exceptional", exceptionalHandler);
        RefreshRegistry.defaultRegistry().register("exceptional", otherExceptionalHandler);
        String[] args = new String[]{"-refreshRouterArgs", "localhost:" + router.getAdminServerAddress().getPort(), "exceptional"};
        int exitCode = admin.run(args);
        Assert.assertEquals((long)-1L, (long)exitCode);
        ((RefreshHandler)Mockito.verify((Object)exceptionalHandler)).handleRefresh("exceptional", new String[0]);
        ((RefreshHandler)Mockito.verify((Object)otherExceptionalHandler)).handleRefresh("exceptional", new String[0]);
        RefreshRegistry.defaultRegistry().unregisterAll("exceptional");
    }
}

