/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRenewLeaseWithSameINodeId {
    private static MiniRouterDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new MiniRouterDFSCluster(false, 2);
        cluster.setNumDatanodesPerNameservice(3);
        cluster.startCluster();
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().quota().build();
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
        routerContext = cluster.getRouters().get(0);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        cluster.shutdown();
    }

    @Test
    public void testRenewLeaseWithSameINodeId() throws IOException {
        Router router = cluster.getRouters().get(0).getRouter();
        MockResolver resolver = (MockResolver)router.getSubclusterResolver();
        resolver.addLocation("/ns0", cluster.getNameservices().get(0), "/ns0");
        resolver.addLocation("/ns1", cluster.getNameservices().get(1), "/ns1");
        DistributedFileSystem fs = (DistributedFileSystem)routerContext.getFileSystem();
        Path path1 = new Path("/ns0/file");
        Path path2 = new Path("/ns1/file");
        try (FSDataOutputStream ignored1 = fs.create(path1);
             FSDataOutputStream ignored2 = fs.create(path2);){
            HdfsFileStatus fileStatus1 = fs.getClient().getFileInfo(path1.toUri().getPath());
            HdfsFileStatus fileStatus2 = fs.getClient().getFileInfo(path2.toUri().getPath());
            Assert.assertEquals((long)fileStatus2.getFileId(), (long)fileStatus1.getFileId());
            Assert.assertEquals((long)2L, (long)fs.getClient().getNumOfFilesBeingWritten());
        }
        Assert.assertEquals((long)0L, (long)fs.getClient().getNumOfFilesBeingWritten());
    }
}

