/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.hdfs.server.namenode.TreePath;
import org.apache.hadoop.hdfs.server.namenode.TreeWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class FSTreeWalk
extends TreeWalk {
    public static final Logger LOG = LoggerFactory.getLogger(FSTreeWalk.class);
    private final Path root;
    private final FileSystem fs;
    private final boolean enableACLs;

    public FSTreeWalk(Path root, Configuration conf) throws IOException {
        this.root = root;
        this.fs = root.getFileSystem(conf);
        boolean mountACLsEnabled = conf.getBoolean("dfs.provided.acls.import.enabled", false);
        boolean localACLsEnabled = conf.getBoolean("dfs.namenode.acls.enabled", true);
        if (!localACLsEnabled && mountACLsEnabled) {
            LOG.warn("Mount ACLs have been enabled but HDFS ACLs are not. Disabling ACLs on the mount {}", (Object)root);
            this.enableACLs = false;
        } else {
            this.enableACLs = mountACLsEnabled;
        }
    }

    @Override
    protected Iterable<TreePath> getChildren(TreePath path, long id, TreeWalk.TreeIterator i) {
        if (!path.getFileStatus().isDirectory()) {
            return Collections.emptyList();
        }
        try {
            ArrayList<TreePath> ret = new ArrayList<TreePath>();
            for (FileStatus s : this.fs.listStatus(path.getFileStatus().getPath())) {
                AclStatus aclStatus = this.getAclStatus(this.fs, s.getPath());
                ret.add(new TreePath(s, id, i, this.fs, aclStatus));
            }
            return ret;
        }
        catch (FileNotFoundException e) {
            throw new ConcurrentModificationException("FS modified");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private AclStatus getAclStatus(FileSystem fileSystem, Path path) throws IOException {
        return this.enableACLs ? fileSystem.getAclStatus(path) : null;
    }

    @Override
    public TreeWalk.TreeIterator iterator() {
        try {
            FileStatus s = this.fs.getFileStatus(this.root);
            return new FSTreeIterator(s, -1L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class FSTreeIterator
    extends TreeWalk.TreeIterator {
        private FSTreeIterator() {
        }

        FSTreeIterator(TreePath p) {
            this(p.getFileStatus(), p.getParentId());
        }

        FSTreeIterator(FileStatus fileStatus, long parentId) {
            AclStatus acls;
            Path path = fileStatus.getPath();
            try {
                acls = FSTreeWalk.this.getAclStatus(FSTreeWalk.this.fs, path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            TreePath treePath = new TreePath(fileStatus, parentId, this, FSTreeWalk.this.fs, acls);
            this.getPendingQueue().addFirst(treePath);
        }

        @Override
        public TreeWalk.TreeIterator fork() {
            if (this.getPendingQueue().isEmpty()) {
                return new FSTreeIterator();
            }
            return new FSTreeIterator(this.getPendingQueue().removeFirst());
        }
    }
}

