/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;

class ListBlobQueue {
    private final Queue<Path> pathQueue = new ArrayDeque<Path>();
    private final int maxSize;
    private final int consumeSetSize;
    private volatile boolean isCompleted = false;
    private volatile boolean isConsumptionFailed = false;
    private volatile AzureBlobFileSystemException failureFromProducer;
    private final int maxConsumptionLag;

    ListBlobQueue(int maxSize, int consumeSetSize, int maxConsumptionLag) throws InvalidConfigurationValueException {
        this.maxSize = maxSize;
        this.maxConsumptionLag = maxConsumptionLag;
        this.consumeSetSize = consumeSetSize;
        if (maxConsumptionLag >= maxSize) {
            throw new InvalidConfigurationValueException("fs.azure.blob.dir.list.consumer.max.lag", "maxConsumptionLag should be lesser than maxSize");
        }
    }

    void markProducerFailure(AzureBlobFileSystemException failure) {
        this.failureFromProducer = failure;
    }

    void complete() {
        this.isCompleted = true;
    }

    synchronized void markConsumptionFailed() {
        this.isConsumptionFailed = true;
        this.notify();
    }

    boolean getConsumptionFailed() {
        return this.isConsumptionFailed;
    }

    boolean getIsCompleted() {
        return this.isCompleted && this.size() == 0;
    }

    private AzureBlobFileSystemException getException() {
        return this.failureFromProducer;
    }

    synchronized void enqueue(List<Path> pathList) {
        if (this.isCompleted) {
            throw new IllegalStateException("Cannot enqueue paths as the queue is already marked as completed");
        }
        this.pathQueue.addAll(pathList);
    }

    synchronized List<Path> consume() throws AzureBlobFileSystemException {
        AzureBlobFileSystemException exception = this.getException();
        if (exception != null) {
            throw exception;
        }
        return this.dequeue();
    }

    private List<Path> dequeue() {
        int counter;
        ArrayList<Path> pathListForConsumption = new ArrayList<Path>();
        for (counter = 0; counter < this.consumeSetSize && !this.pathQueue.isEmpty(); ++counter) {
            pathListForConsumption.add(this.pathQueue.poll());
        }
        if (counter > 0) {
            this.notify();
        }
        return pathListForConsumption;
    }

    synchronized int size() {
        return this.pathQueue.size();
    }

    synchronized int availableSizeForProduction() {
        while (this.size() >= this.maxConsumptionLag) {
            if (this.isConsumptionFailed) {
                return 0;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.maxSize - this.size();
    }
}

