/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.FileSystemOperationUnhandledException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.services.BlobListResultSchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultEntrySchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultSchema;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlobClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.ListBlobQueue;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListActionTaker {
    private static final Logger LOG = LoggerFactory.getLogger(ListActionTaker.class);
    private final Path path;
    private final AbfsBlobClient abfsClient;
    private final TracingContext tracingContext;
    private final ExecutorService executorService;
    private final AtomicBoolean producerThreadToBeStopped = new AtomicBoolean(false);

    public ListActionTaker(Path path, AbfsBlobClient abfsClient, TracingContext tracingContext) {
        this.path = path;
        this.abfsClient = abfsClient;
        this.tracingContext = tracingContext;
        this.executorService = Executors.newFixedThreadPool(this.getMaxConsumptionParallelism());
    }

    public AbfsBlobClient getAbfsClient() {
        return this.abfsClient;
    }

    abstract int getMaxConsumptionParallelism();

    abstract boolean takeAction(Path var1) throws AzureBlobFileSystemException;

    private boolean takeAction(List<Path> paths) throws AzureBlobFileSystemException {
        ArrayList<Future<Boolean>> futureList = new ArrayList<Future<Boolean>>();
        for (Path path : paths) {
            Future<Boolean> future = this.executorService.submit(() -> this.takeAction(path));
            futureList.add(future);
        }
        AzureBlobFileSystemException executionException = null;
        boolean actionResult = true;
        for (Future future : futureList) {
            try {
                Boolean result = (Boolean)future.get();
                if (result.booleanValue()) continue;
                actionResult = false;
            }
            catch (InterruptedException e) {
                LOG.debug("Thread interrupted while taking action on path: {}", (Object)this.path.toUri().getPath());
            }
            catch (ExecutionException e) {
                LOG.debug("Execution exception while taking action on path: {}", (Object)this.path.toUri().getPath());
                if (e.getCause() instanceof AzureBlobFileSystemException) {
                    executionException = (AzureBlobFileSystemException)e.getCause();
                    continue;
                }
                executionException = new FileSystemOperationUnhandledException(executionException);
            }
        }
        if (executionException != null) {
            throw executionException;
        }
        return actionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listRecursiveAndTakeAction() throws AzureBlobFileSystemException {
        AbfsConfiguration configuration = this.getAbfsClient().getAbfsConfiguration();
        Thread producerThread = null;
        try {
            ListBlobQueue listBlobQueue = this.createListBlobQueue(configuration);
            producerThread = new Thread(() -> {
                try {
                    this.produceConsumableList(listBlobQueue);
                }
                catch (AzureBlobFileSystemException e) {
                    listBlobQueue.markProducerFailure(e);
                }
            });
            producerThread.start();
            while (!listBlobQueue.getIsCompleted()) {
                List<Path> paths = listBlobQueue.consume();
                if (paths == null) continue;
                try {
                    boolean resultOnPartAction = this.takeAction(paths);
                    if (resultOnPartAction) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (AzureBlobFileSystemException parallelConsumptionException) {
                    listBlobQueue.markConsumptionFailed();
                    throw parallelConsumptionException;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (producerThread != null) {
                this.producerThreadToBeStopped.set(true);
            }
            this.executorService.shutdownNow();
        }
    }

    @VisibleForTesting
    protected ListBlobQueue createListBlobQueue(AbfsConfiguration configuration) throws InvalidConfigurationValueException {
        return new ListBlobQueue(configuration.getProducerQueueMaxSize(), this.getMaxConsumptionParallelism(), configuration.getListingMaxConsumptionLag());
    }

    private void produceConsumableList(ListBlobQueue listBlobQueue) throws AzureBlobFileSystemException {
        String continuationToken = null;
        do {
            continuationToken = this.listAndEnqueue(listBlobQueue, continuationToken);
        } while (!this.producerThreadToBeStopped.get() && continuationToken != null && !listBlobQueue.getConsumptionFailed());
        listBlobQueue.complete();
    }

    @VisibleForTesting
    protected String listAndEnqueue(ListBlobQueue listBlobQueue, String continuationToken) throws AzureBlobFileSystemException {
        AbfsRestOperation op;
        int queueAvailableSizeForProduction = Math.min(5000, listBlobQueue.availableSizeForProduction());
        if (queueAvailableSizeForProduction == 0) {
            return null;
        }
        try {
            op = this.getAbfsClient().listPath(this.path.toUri().getPath(), true, queueAvailableSizeForProduction, continuationToken, this.tracingContext, null).getOp();
        }
        catch (AzureBlobFileSystemException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new AbfsRestOperationException(-1, null, "Unknown exception from listing: " + ex.getMessage(), ex);
        }
        ListResultSchema retrievedSchema = op.getResult().getListResultSchema();
        if (retrievedSchema == null) {
            return continuationToken;
        }
        continuationToken = ((BlobListResultSchema)retrievedSchema).getNextMarker();
        ArrayList<Path> paths = new ArrayList<Path>();
        this.addPaths(paths, retrievedSchema);
        listBlobQueue.enqueue(paths);
        return continuationToken;
    }

    @VisibleForTesting
    protected void addPaths(List<Path> paths, ListResultSchema retrievedSchema) {
        for (ListResultEntrySchema listResultEntrySchema : retrievedSchema.paths()) {
            Path entryPath = new Path("/" + listResultEntrySchema.name());
            if (entryPath.equals((Object)this.path)) continue;
            paths.add(entryPath);
        }
    }
}

