/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;

public class ClearingSessionContainerClientRetryPolicy
implements IDocumentClientRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(ClearingSessionContainerClientRetryPolicy.class);
    private final IDocumentClientRetryPolicy retryPolicy;
    private final ISessionContainer sessionContainer;
    private RxDocumentServiceRequest request;
    private boolean hasTriggered = false;

    public ClearingSessionContainerClientRetryPolicy(ISessionContainer sessionContainer, IDocumentClientRetryPolicy retryPolicy) {
        this.sessionContainer = sessionContainer;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.retryPolicy.onBeforeSendRequest(request);
    }

    @Override
    public Single<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception e) {
        return this.retryPolicy.shouldRetry(e).flatMap(shouldRetryResult -> {
            if (!shouldRetryResult.shouldRetry && !this.hasTriggered) {
                DocumentClientException clientException = (DocumentClientException)((Object)((Object)Utils.as((Object)e, DocumentClientException.class)));
                if (this.request == null) {
                    logger.error("onBeforeSendRequest is not invoked, encountered failure due to request being null", (Throwable)e);
                    return Single.just((Object)IRetryPolicy.ShouldRetryResult.error(e));
                }
                if (clientException != null && this.request.getIsNameBased() && Exceptions.isStatusCode((DocumentClientException)clientException, (int)404) && Exceptions.isSubStatusCode((DocumentClientException)clientException, (int)1002)) {
                    logger.warn("Clear the token for named base request {}", (Object)this.request.getResourceAddress());
                    this.sessionContainer.clearTokenByCollectionFullName(this.request.getResourceAddress());
                    this.hasTriggered = true;
                }
            }
            return Single.just((Object)shouldRetryResult);
        });
    }
}

