/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.auth.AwsSignerInitializer;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.auth.signer.internal.AbstractAwsS3V4Signer;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public class CustomSdkSigner
extends AbstractAwsS3V4Signer
implements Signer {
    private static final Logger LOG = LoggerFactory.getLogger(CustomSdkSigner.class);
    private static final AtomicInteger INSTANTIATION_COUNT = new AtomicInteger(0);
    private static final AtomicInteger INVOCATION_COUNT = new AtomicInteger(0);
    private final AwsS3V4Signer s3Signer = AwsS3V4Signer.create();
    private final Aws4Signer aws4Signer = Aws4Signer.create();

    public CustomSdkSigner() {
        int c = INSTANTIATION_COUNT.incrementAndGet();
        LOG.info("Creating Signer #{}", (Object)c);
    }

    public SdkHttpFullRequest sign(SdkHttpFullRequest request, ExecutionAttributes executionAttributes) {
        int c = INVOCATION_COUNT.incrementAndGet();
        String host = request.host();
        LOG.debug("Signing request #{} against {}: class {}", new Object[]{c, host, request.getClass()});
        String bucketName = CustomSdkSigner.parseBucketFromHost(host);
        if (bucketName.equals("kms")) {
            return this.aws4Signer.sign(request, executionAttributes);
        }
        return this.s3Signer.sign(request, executionAttributes);
    }

    static String parseBucketFromHost(String host) {
        String[] hostBits = host.split("\\.");
        String bucketName = hostBits[0];
        String service = hostBits[1];
        if (bucketName.equals("kms")) {
            return bucketName;
        }
        if (service.contains("s3-accesspoint") || service.contains("s3-outposts") || service.contains("s3-object-lambda")) {
            String[] accessPointBits = bucketName.split("-");
            String accountId = accessPointBits[accessPointBits.length - 1];
            String accessPointName = bucketName.substring(0, bucketName.length() - (accountId.length() + 1));
            Arn arn = Arn.builder().accountId(accountId).partition("aws").region(hostBits[2]).resource("accesspoint/" + accessPointName).service("s3").build();
            bucketName = arn.toString();
        }
        return bucketName;
    }

    public static int getInstantiationCount() {
        return INSTANTIATION_COUNT.get();
    }

    public static int getInvocationCount() {
        return INVOCATION_COUNT.get();
    }

    public static String description() {
        return "CustomSigner{invocations=" + INVOCATION_COUNT.get() + ", instantiations=" + INSTANTIATION_COUNT.get() + "}";
    }

    public static class Initializer
    implements AwsSignerInitializer {
        @Override
        public void registerStore(String bucketName, Configuration storeConf, DelegationTokenProvider dtProvider, UserGroupInformation storeUgi) {
            LOG.debug("Registering store for bucket {}", (Object)bucketName);
        }

        @Override
        public void unregisterStore(String bucketName, Configuration storeConf, DelegationTokenProvider dtProvider, UserGroupInformation storeUgi) {
            LOG.debug("Unregistering store for bucket {}", (Object)bucketName);
        }
    }
}

