/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.impl.CSEMaterials;
import org.apache.hadoop.fs.s3a.statistics.StatisticsFromAwsSdk;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

@InterfaceAudience.LimitedPrivate(value={"HBoss"})
@InterfaceStability.Evolving
public interface S3ClientFactory {
    public S3Client createS3Client(URI var1, S3ClientCreationParameters var2) throws IOException;

    public S3AsyncClient createS3AsyncClient(URI var1, S3ClientCreationParameters var2) throws IOException;

    public S3TransferManager createS3TransferManager(S3AsyncClient var1);

    public static final class S3ClientCreationParameters {
        private AwsCredentialsProvider credentialSet;
        private String endpoint = "";
        private final Map<String, String> headers = new HashMap<String, String>();
        private StatisticsFromAwsSdk metrics;
        private Boolean isCSEEnabled = false;
        private String kmsRegion;
        private CSEMaterials cseMaterials;
        private boolean pathStyleAccess;
        private boolean requesterPays;
        private List<ExecutionInterceptor> executionInterceptors;
        private String userAgentSuffix = "";
        private URI pathUri;
        private long minimumPartSize;
        private long multiPartThreshold;
        private boolean multipartCopy = true;
        private Executor transferManagerExecutor;
        private String region;
        private boolean expressCreateSession = true;
        private boolean checksumValidationEnabled;
        private boolean fipsEnabled;
        private boolean isAnalyticsAcceleratorEnabled;

        public List<ExecutionInterceptor> getExecutionInterceptors() {
            return this.executionInterceptors;
        }

        public S3ClientCreationParameters withExecutionInterceptors(@Nullable List<ExecutionInterceptor> interceptors) {
            this.executionInterceptors = interceptors;
            return this;
        }

        public StatisticsFromAwsSdk getMetrics() {
            return this.metrics;
        }

        public S3ClientCreationParameters withMetrics(@Nullable StatisticsFromAwsSdk statistics) {
            this.metrics = statistics;
            return this;
        }

        public S3ClientCreationParameters withRequesterPays(boolean value) {
            this.requesterPays = value;
            return this;
        }

        public boolean isRequesterPays() {
            return this.requesterPays;
        }

        public AwsCredentialsProvider getCredentialSet() {
            return this.credentialSet;
        }

        public S3ClientCreationParameters withCredentialSet(AwsCredentialsProvider value) {
            this.credentialSet = value;
            return this;
        }

        public String getUserAgentSuffix() {
            return this.userAgentSuffix;
        }

        public S3ClientCreationParameters withUserAgentSuffix(String value) {
            this.userAgentSuffix = value;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public S3ClientCreationParameters withEndpoint(String value) {
            this.endpoint = value;
            return this;
        }

        public boolean isPathStyleAccess() {
            return this.pathStyleAccess;
        }

        public S3ClientCreationParameters withPathStyleAccess(boolean value) {
            this.pathStyleAccess = value;
            return this;
        }

        public S3ClientCreationParameters withHeader(String header, String value) {
            this.headers.put(header, value);
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public URI getPathUri() {
            return this.pathUri;
        }

        public S3ClientCreationParameters withPathUri(URI value) {
            this.pathUri = value;
            return this;
        }

        public long getMinimumPartSize() {
            return this.minimumPartSize;
        }

        public S3ClientCreationParameters withMinimumPartSize(long value) {
            this.minimumPartSize = value;
            return this;
        }

        public long getMultiPartThreshold() {
            return this.multiPartThreshold;
        }

        public S3ClientCreationParameters withMultipartThreshold(long value) {
            this.multiPartThreshold = value;
            return this;
        }

        public Executor getTransferManagerExecutor() {
            return this.transferManagerExecutor;
        }

        public S3ClientCreationParameters withTransferManagerExecutor(Executor value) {
            this.transferManagerExecutor = value;
            return this;
        }

        public S3ClientCreationParameters withMultipartCopyEnabled(boolean value) {
            this.multipartCopy = value;
            return this;
        }

        public boolean isMultipartCopy() {
            return this.multipartCopy;
        }

        public S3ClientCreationParameters withRegion(String value) {
            this.region = value;
            return this;
        }

        public S3ClientCreationParameters withClientSideEncryptionEnabled(boolean value) {
            this.isCSEEnabled = value;
            return this;
        }

        public S3ClientCreationParameters withAnalyticsAcceleratorEnabled(boolean value) {
            this.isAnalyticsAcceleratorEnabled = value;
            return this;
        }

        public S3ClientCreationParameters withKMSRegion(String value) {
            this.kmsRegion = value;
            return this;
        }

        public boolean isClientSideEncryptionEnabled() {
            return this.isCSEEnabled;
        }

        public boolean isAnalyticsAcceleratorEnabled() {
            return this.isAnalyticsAcceleratorEnabled;
        }

        public S3ClientCreationParameters withClientSideEncryptionMaterials(CSEMaterials value) {
            this.cseMaterials = value;
            return this;
        }

        public CSEMaterials getClientSideEncryptionMaterials() {
            return this.cseMaterials;
        }

        public String getRegion() {
            return this.region;
        }

        public String getKmsRegion() {
            return this.kmsRegion;
        }

        public boolean isExpressCreateSession() {
            return this.expressCreateSession;
        }

        public S3ClientCreationParameters withExpressCreateSession(boolean value) {
            this.expressCreateSession = value;
            return this;
        }

        public S3ClientCreationParameters withChecksumValidationEnabled(boolean value) {
            this.checksumValidationEnabled = value;
            return this;
        }

        public boolean isChecksumValidationEnabled() {
            return this.checksumValidationEnabled;
        }

        public String toString() {
            return "S3ClientCreationParameters{endpoint='" + this.endpoint + '\'' + ", pathStyleAccess=" + this.pathStyleAccess + ", requesterPays=" + this.requesterPays + ", userAgentSuffix='" + this.userAgentSuffix + '\'' + ", pathUri=" + this.pathUri + ", minimumPartSize=" + this.minimumPartSize + ", multiPartThreshold=" + this.multiPartThreshold + ", multipartCopy=" + this.multipartCopy + ", region='" + this.region + '\'' + ", expressCreateSession=" + this.expressCreateSession + ", checksumValidationEnabled=" + this.checksumValidationEnabled + '}';
        }

        public boolean isFipsEnabled() {
            return this.fipsEnabled;
        }

        public S3ClientCreationParameters withFipsEnabled(boolean value) {
            this.fipsEnabled = value;
            return this;
        }
    }
}

