/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timeline.TimelineHealth;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseStorageMonitor;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineStorageMonitor;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.EntityTypeReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTimelineReaderImpl
extends AbstractService
implements TimelineReader {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTimelineReaderImpl.class);
    private Configuration hbaseConf = null;
    private Connection conn;
    private TimelineStorageMonitor storageMonitor;

    public HBaseTimelineReaderImpl() {
        super(HBaseTimelineReaderImpl.class.getName());
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.hbaseConf = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf(conf);
        this.conn = ConnectionFactory.createConnection((Configuration)this.hbaseConf);
        this.storageMonitor = new HBaseStorageMonitor(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.storageMonitor.start();
    }

    protected void serviceStop() throws Exception {
        if (this.conn != null) {
            LOG.info("closing the hbase Connection");
            this.conn.close();
        }
        this.storageMonitor.stop();
        super.serviceStop();
    }

    public TimelineEntity getEntity(TimelineReaderContext context, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        this.storageMonitor.checkStorageIsUp();
        TimelineEntityReader reader = TimelineEntityReaderFactory.createSingleEntityReader(context, dataToRetrieve);
        return reader.readEntity(this.hbaseConf, this.conn);
    }

    public Set<TimelineEntity> getEntities(TimelineReaderContext context, TimelineEntityFilters filters, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        this.storageMonitor.checkStorageIsUp();
        TimelineEntityReader reader = TimelineEntityReaderFactory.createMultipleEntitiesReader(context, filters, dataToRetrieve);
        return reader.readEntities(this.hbaseConf, this.conn);
    }

    public Set<String> getEntityTypes(TimelineReaderContext context) throws IOException {
        this.storageMonitor.checkStorageIsUp();
        EntityTypeReader reader = new EntityTypeReader(context);
        return reader.readEntityTypes(this.hbaseConf, this.conn);
    }

    public TimelineHealth getHealthStatus() {
        try {
            this.storageMonitor.checkStorageIsUp();
            return new TimelineHealth(TimelineHealth.TimelineHealthStatus.RUNNING, "");
        }
        catch (IOException e) {
            return new TimelineHealth(TimelineHealth.TimelineHealthStatus.CONNECTION_FAILURE, "HBase connection is down");
        }
    }

    protected TimelineStorageMonitor getTimelineStorageMonitor() {
        return this.storageMonitor;
    }
}

