/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.ObserverRetryOnActiveException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Timeout;

public class TestNameNodeRpcServer {
    static final int ITERATIONS_TO_USE = 20;

    @Test
    public void testNamenodeRpcBindAny() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.rpc-bind-host", "0.0.0.0");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            cluster.waitActive();
            Assert.assertEquals((Object)"0.0.0.0", (Object)((NameNodeRpcServer)cluster.getNameNodeRpc()).getClientRpcServer().getListenerAddress().getHostName());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            conf.unset("dfs.namenode.rpc-bind-host");
        }
    }

    private static String getPreferredLocation(DistributedFileSystem fs, Path p) throws IOException {
        LocatedBlocks blocks = fs.getClient().getLocatedBlocks(p.toUri().getPath(), 0L);
        return blocks.get(0).getLocations()[0].getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30000L)
    public void testNamenodeRpcClientIpProxyWithFailBack() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.ip-proxy-users", "fake_joe");
        CallerContext original = CallerContext.getCurrent();
        MiniQJMHACluster qjmhaCluster = null;
        try {
            String baseDir = GenericTestUtils.getRandomizedTempPath();
            MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder((Configuration)conf);
            builder.getDfsBuilder().numDataNodes(3);
            qjmhaCluster = builder.baseDir(baseDir).build();
            MiniDFSCluster dfsCluster = qjmhaCluster.getDfsCluster();
            dfsCluster.waitActive();
            dfsCluster.transitionToActive(0);
            CallerContext.setCurrent((CallerContext)new CallerContext.Builder("test", (Configuration)conf).build());
            dfsCluster.getFileSystem(0).setPermission(new Path("/"), FsPermission.getDirDefault());
            UserGroupInformation joe = UserGroupInformation.createUserForTesting((String)"fake_joe", (String[])new String[]{"fake_group"});
            FileSystem joeFs = (FileSystem)joe.doAs(() -> TestNameNodeRpcServer.lambda$testNamenodeRpcClientIpProxyWithFailBack$0(dfsCluster, (Configuration)conf));
            Path testPath = new Path("/foo");
            FSDataOutputStream stream = joeFs.create(testPath);
            stream.write("Hello world!\n".getBytes(StandardCharsets.UTF_8));
            stream.close();
            qjmhaCluster.getDfsCluster().transitionToStandby(0);
            qjmhaCluster.getDfsCluster().transitionToActive(1);
            DistributedFileSystem nn1 = dfsCluster.getFileSystem(1);
            Assert.assertNotNull((Object)nn1.getFileStatus(testPath));
        }
        finally {
            CallerContext.setCurrent((CallerContext)original);
            if (qjmhaCluster != null) {
                try {
                    qjmhaCluster.shutdown();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            conf.unset("dfs.namenode.ip-proxy-users");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30000L)
    public void testObserverHandleAddBlock() throws Exception {
        String baseDir = GenericTestUtils.getRandomizedTempPath();
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder((Configuration)conf).setNumNameNodes(3);
        builder.getDfsBuilder().numDataNodes(3);
        try (MiniQJMHACluster qjmhaCluster = builder.baseDir(baseDir).build();){
            MiniDFSCluster dfsCluster = qjmhaCluster.getDfsCluster();
            dfsCluster.waitActive();
            dfsCluster.transitionToActive(0);
            dfsCluster.transitionToObserver(2);
            NameNode activeNN = dfsCluster.getNameNode(0);
            NameNode observerNN = dfsCluster.getNameNode(2);
            observerNN.getNamesystem().getEditLogTailer().stop();
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            Path testPath = new Path("/testObserverHandleAddBlock/file.txt");
            try (FSDataOutputStream ignore = dfs.create(testPath);){
                HdfsFileStatus fileStatus = activeNN.getRpcServer().getFileInfo(testPath.toUri().getPath());
                Assert.assertNotNull((Object)fileStatus);
                Assert.assertNull((Object)observerNN.getRpcServer().getFileInfo(testPath.toUri().getPath()));
                LambdaTestUtils.intercept(ObserverRetryOnActiveException.class, () -> observerNN.getRpcServer().addBlock(testPath.toUri().getPath(), dfs.getClient().getClientName(), null, null, fileStatus.getFileId(), null, EnumSet.noneOf(AddBlockFlag.class)));
            }
            finally {
                dfs.delete(testPath, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamenodeRpcClientIpProxy() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.ip-proxy-users", "fake_joe");
        String[] racks = new String[]{"/rack1", "/rack2", "/rack3"};
        String[] hosts = new String[]{"node1", "node2", "node3"};
        MiniDFSCluster cluster = null;
        CallerContext original = CallerContext.getCurrent();
        try {
            String host;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).racks(racks).hosts(hosts).numDataNodes(hosts.length).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path fooName = fs.makeQualified(new Path("/foo"));
            FSDataOutputStream stream = fs.create(fooName);
            stream.write("Hello world!\n".getBytes(StandardCharsets.UTF_8));
            stream.close();
            CallerContext.setCurrent((CallerContext)new CallerContext.Builder("test", (Configuration)conf).append("clientIp", hosts[0]).build());
            for (int trial = 0; trial < 20 && hosts[0].equals(host = TestNameNodeRpcServer.getPreferredLocation(fs, fooName)); ++trial) {
                if (trial != 19) continue;
                Assert.assertNotEquals((String)"Failed to get non-node1", (Object)hosts[0], (Object)host);
            }
            UserGroupInformation joe = UserGroupInformation.createUserForTesting((String)"fake_joe", (String[])new String[]{"fake_group"});
            DistributedFileSystem joeFs = (DistributedFileSystem)DFSTestUtil.getFileSystemAs(joe, (Configuration)conf);
            for (int trial = 0; trial < 20; ++trial) {
                String host2 = TestNameNodeRpcServer.getPreferredLocation(joeFs, fooName);
                Assert.assertEquals((String)("Trial " + trial + " failed"), (Object)hosts[0], (Object)host2);
            }
        }
        finally {
            CallerContext.setCurrent((CallerContext)original);
            if (cluster != null) {
                cluster.shutdown();
            }
            conf.unset("dfs.namenode.ip-proxy-users");
        }
    }

    private static /* synthetic */ FileSystem lambda$testNamenodeRpcClientIpProxyWithFailBack$0(MiniDFSCluster dfsCluster, Configuration conf) throws Exception {
        return FileSystem.get((URI)dfsCluster.getURI(0), (Configuration)conf);
    }
}

