/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestDataNodeFSDataSetSink {
    private static final MetricsSystemImpl ms = new MetricsSystemImpl("TestFSDataSet");

    @Test
    public void testFSDataSetMetrics() throws InterruptedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String bpid = "FSDatSetSink-Test";
        SimulatedFSDataset fsdataset = new SimulatedFSDataset(null, (Configuration)conf);
        fsdataset.addBlockPool(bpid, (Configuration)conf);
        FSDataSetSinkTest sink = new FSDataSetSinkTest();
        sink.init(null);
        ms.init("Test");
        ms.start();
        ms.register("FSDataSetSource", "FSDataSetSource", (Object)fsdataset);
        ms.register("FSDataSetSink", "FSDataSetSink", (MetricsSink)sink);
        ms.startMetricsMBeans();
        ms.publishMetricsNow();
        Thread.sleep(4000L);
        ms.stopMetricsMBeans();
        ms.shutdown();
        Assert.assertEquals((long)sink.getMapCount(), (long)sink.getFoundKeyCount());
    }

    class FSDataSetSinkTest
    implements MetricsSink {
        private Set<String> nameMap;
        private int count;

        FSDataSetSinkTest() {
        }

        public void putMetrics(MetricsRecord record) {
            if (this.count == 0) {
                for (AbstractMetric m : record.metrics()) {
                    if (!this.nameMap.contains(m.name())) continue;
                    ++this.count;
                }
                for (MetricsTag t : record.tags()) {
                    if (!this.nameMap.contains(t.name())) continue;
                    ++this.count;
                }
            }
        }

        public void flush() {
        }

        public void init(SubsetConfiguration conf) {
            this.nameMap = new TreeSet<String>();
            this.nameMap.add("DfsUsed");
            this.nameMap.add("Capacity");
            this.nameMap.add("Remaining");
            this.nameMap.add("StorageInfo");
            this.nameMap.add("NumFailedVolumes");
            this.nameMap.add("LastVolumeFailureDate");
            this.nameMap.add("EstimatedCapacityLostTotal");
            this.nameMap.add("CacheUsed");
            this.nameMap.add("CacheCapacity");
            this.nameMap.add("NumBlocksCached");
            this.nameMap.add("NumBlocksFailedToCache");
            this.nameMap.add("NumBlocksFailedToUnCache");
            this.nameMap.add("Context");
            this.nameMap.add("Hostname");
        }

        public int getMapCount() {
            return this.nameMap.size();
        }

        public int getFoundKeyCount() {
            return this.count;
        }
    }
}

