/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli;

import org.apache.hadoop.cli.CLITestCmdErasureCoding;
import org.apache.hadoop.cli.CLITestHelper;
import org.apache.hadoop.cli.util.CLICommand;
import org.apache.hadoop.cli.util.CLICommandErasureCodingCli;
import org.apache.hadoop.cli.util.CommandExecutor;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.xml.sax.SAXException;

public class TestErasureCodingCLI
extends CLITestHelper {
    private final int NUM_OF_DATANODES = 3;
    private MiniDFSCluster dfsCluster = null;
    private DistributedFileSystem fs = null;
    private String namenode = null;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dfsCluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.dfsCluster.waitClusterUp();
        this.namenode = this.conf.get("fs.defaultFS", "file:///");
        this.username = System.getProperty("user.name");
        this.fs = this.dfsCluster.getFileSystem();
        this.fs.enableErasureCodingPolicy("RS-6-3-1024k");
        this.fs.enableErasureCodingPolicy("RS-3-2-1024k");
        this.fs.enableErasureCodingPolicy("XOR-2-1-1024k");
    }

    protected String getTestFile() {
        return "testErasureCodingConf.xml";
    }

    @After
    public void tearDown() throws Exception {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
            this.dfsCluster = null;
        }
        Thread.sleep(2000L);
        super.tearDown();
    }

    protected String expandCommand(String cmd) {
        String expCmd = cmd;
        expCmd = expCmd.replaceAll("NAMENODE", this.namenode);
        expCmd = expCmd.replaceAll("#LF#", System.getProperty("line.separator"));
        expCmd = super.expandCommand(expCmd);
        return expCmd;
    }

    protected CLITestHelper.TestConfigFileParser getConfigParser() {
        return new TestErasureCodingAdmin();
    }

    protected CommandExecutor.Result execute(CLICommand cmd) throws Exception {
        return cmd.getExecutor(this.namenode, this.conf).executeCommand(cmd.getCmd());
    }

    @Test
    public void testAll() {
        super.testAll();
    }

    private class TestErasureCodingAdmin
    extends CLITestHelper.TestConfigFileParser {
        private TestErasureCodingAdmin() {
            super((CLITestHelper)TestErasureCodingCLI.this);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("ec-admin-command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestCmdErasureCoding(this.charString, new CLICommandErasureCodingCli()));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestCmdErasureCoding(this.charString, new CLICommandErasureCodingCli()));
                }
            } else {
                super.endElement(uri, localName, qName);
            }
        }
    }
}

