/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFencedException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreLimitException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStoreOpDurations;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.EpochPBImpl;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ZKRMStateStore
extends RMStateStore {
    private static final Logger LOG = LoggerFactory.getLogger(ZKRMStateStore.class);
    private static final String RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME = "RMDelegationTokensRoot";
    private static final String RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME = "RMDTSequentialNumber";
    private static final String RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME = "RMDTMasterKeysRoot";
    @VisibleForTesting
    public static final String ROOT_ZNODE_NAME = "ZKRMStateRoot";
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)5);
    @VisibleForTesting
    public static final String RM_APP_ROOT_HIERARCHIES = "HIERARCHIES";
    private String zkRootNodePath;
    private String rmAppRoot;
    private Map<Integer, String> rmAppRootHierarchies;
    private Map<Integer, String> rmDelegationTokenHierarchies;
    private String rmDTSecretManagerRoot;
    private String dtMasterKeysRootPath;
    private String delegationTokensRootPath;
    private String dtSequenceNumberPath;
    private String amrmTokenSecretManagerRoot;
    private String reservationRoot;
    private String proxyCARoot;
    @VisibleForTesting
    protected String znodeWorkingPath;
    private int appIdNodeSplitIndex = 0;
    @VisibleForTesting
    protected int delegationTokenNodeSplitIndex = 0;
    private static final String FENCING_LOCK = "RM_ZK_FENCING_LOCK";
    private String fencingNodePath;
    private Thread verifyActiveStatusThread;
    private int zkSessionTimeout;
    private int zknodeLimit;
    private List<ACL> zkAcl;
    @VisibleForTesting
    List<ACL> zkRootNodeAcl;
    private String zkRootNodeUsername;
    private static final int CREATE_DELETE_PERMS = 12;
    private final String zkRootNodeAuthScheme = new DigestAuthenticationProvider().getScheme();
    private ZKCuratorManager zkManager;
    private volatile Clock clock = SystemClock.getInstance();
    @VisibleForTesting
    protected ZKRMStateStoreOpDurations opDurations;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    protected List<ACL> constructZkRootNodeACL(Configuration conf, List<ACL> sourceACLs) throws NoSuchAlgorithmException {
        ArrayList<ACL> zkRootNodeAclList = new ArrayList<ACL>();
        for (ACL acl : sourceACLs) {
            zkRootNodeAclList.add(new ACL(ZKUtil.removeSpecificPerms((int)acl.getPerms(), (int)12), acl.getId()));
        }
        this.zkRootNodeUsername = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.address", (String)"0.0.0.0:8032", (Configuration)conf);
        Id rmId = new Id(this.zkRootNodeAuthScheme, DigestAuthenticationProvider.generateDigest((String)(this.zkRootNodeUsername + ":" + this.resourceManager.getZkRootNodePassword())));
        zkRootNodeAclList.add(new ACL(12, rmId));
        return zkRootNodeAclList;
    }

    @Override
    public synchronized void initInternal(Configuration conf) throws IOException, NoSuchAlgorithmException {
        int splitIndex;
        this.znodeWorkingPath = conf.get("yarn.resourcemanager.zk-state-store.parent-path", "/rmstore");
        this.zkRootNodePath = this.getNodePath(this.znodeWorkingPath, ROOT_ZNODE_NAME);
        this.rmAppRoot = this.getNodePath(this.zkRootNodePath, "RMAppRoot");
        String hierarchiesPath = this.getNodePath(this.rmAppRoot, RM_APP_ROOT_HIERARCHIES);
        this.rmAppRootHierarchies = new HashMap<Integer, String>(5);
        this.rmAppRootHierarchies.put(0, this.rmAppRoot);
        for (splitIndex = 1; splitIndex <= 4; ++splitIndex) {
            this.rmAppRootHierarchies.put(splitIndex, this.getNodePath(hierarchiesPath, Integer.toString(splitIndex)));
        }
        this.fencingNodePath = this.getNodePath(this.zkRootNodePath, FENCING_LOCK);
        this.zkSessionTimeout = conf.getInt("yarn.resourcemanager.zk-timeout-ms", 10000);
        this.zknodeLimit = conf.getInt("yarn.resourcemanager.zk-max-znode-size.bytes", 0x100000);
        this.appIdNodeSplitIndex = conf.getInt("yarn.resourcemanager.zk-appid-node.split-index", 0);
        if (this.appIdNodeSplitIndex < 0 || this.appIdNodeSplitIndex > 4) {
            LOG.info("Invalid value " + this.appIdNodeSplitIndex + " for config " + "yarn.resourcemanager.zk-appid-node.split-index" + " specified. Resetting it to " + 0);
            this.appIdNodeSplitIndex = 0;
        }
        this.opDurations = ZKRMStateStoreOpDurations.getInstance();
        this.zkAcl = ZKCuratorManager.getZKAcls((Configuration)conf);
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            String zkRootNodeAclConf = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.zk-state-store.root-node.acl", (Configuration)conf);
            if (zkRootNodeAclConf != null) {
                zkRootNodeAclConf = ZKUtil.resolveConfIndirection((String)zkRootNodeAclConf);
                try {
                    this.zkRootNodeAcl = ZKUtil.parseACLs((String)zkRootNodeAclConf);
                }
                catch (ZKUtil.BadAclFormatException bafe) {
                    LOG.error("Invalid format for yarn.resourcemanager.zk-state-store.root-node.acl");
                    throw bafe;
                }
            } else {
                this.zkRootNodeAcl = this.constructZkRootNodeACL(conf, this.zkAcl);
            }
        }
        this.rmDTSecretManagerRoot = this.getNodePath(this.zkRootNodePath, "RMDTSecretManagerRoot");
        this.dtMasterKeysRootPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME);
        this.delegationTokensRootPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME);
        this.rmDelegationTokenHierarchies = new HashMap<Integer, String>(5);
        this.rmDelegationTokenHierarchies.put(0, this.delegationTokensRootPath);
        for (splitIndex = 1; splitIndex <= 4; ++splitIndex) {
            this.rmDelegationTokenHierarchies.put(splitIndex, this.getNodePath(this.delegationTokensRootPath, Integer.toString(splitIndex)));
        }
        this.dtSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME);
        this.amrmTokenSecretManagerRoot = this.getNodePath(this.zkRootNodePath, "AMRMTokenSecretManagerRoot");
        this.proxyCARoot = this.getNodePath(this.zkRootNodePath, "ProxyCARoot");
        this.reservationRoot = this.getNodePath(this.zkRootNodePath, "ReservationSystemRoot");
        this.zkManager = this.resourceManager.getZKManager();
        if (this.zkManager == null) {
            this.zkManager = this.resourceManager.createAndStartZKManager(conf);
        }
        this.delegationTokenNodeSplitIndex = conf.getInt("yarn.resourcemanager.zk-delegation-token-node.split-index", 0);
        if (this.delegationTokenNodeSplitIndex < 0 || this.delegationTokenNodeSplitIndex > 4) {
            LOG.info("Invalid value " + this.delegationTokenNodeSplitIndex + " for config " + "yarn.resourcemanager.zk-delegation-token-node.split-index" + " specified.  Resetting it to " + 0);
            this.delegationTokenNodeSplitIndex = 0;
        }
    }

    @Override
    public synchronized void startInternal() throws Exception {
        int splitIndex;
        this.zkManager.createRootDirRecursively(this.znodeWorkingPath, this.zkAcl);
        this.create(this.zkRootNodePath);
        this.setRootNodeAcls();
        this.delete(this.fencingNodePath);
        if (HAUtil.isHAEnabled((Configuration)this.getConfig()) && !HAUtil.isAutomaticFailoverEnabled((Configuration)this.getConfig())) {
            this.verifyActiveStatusThread = new VerifyActiveStatusThread();
            this.verifyActiveStatusThread.start();
        }
        this.create(this.rmAppRoot);
        this.create(this.getNodePath(this.rmAppRoot, RM_APP_ROOT_HIERARCHIES));
        for (splitIndex = 1; splitIndex <= 4; ++splitIndex) {
            this.create(this.rmAppRootHierarchies.get(splitIndex));
        }
        this.create(this.rmDTSecretManagerRoot);
        this.create(this.dtMasterKeysRootPath);
        this.create(this.delegationTokensRootPath);
        for (splitIndex = 1; splitIndex <= 4; ++splitIndex) {
            this.create(this.rmDelegationTokenHierarchies.get(splitIndex));
        }
        this.create(this.dtSequenceNumberPath);
        this.create(this.amrmTokenSecretManagerRoot);
        this.create(this.reservationRoot);
        this.create(this.proxyCARoot);
    }

    private void logRootNodeAcls(String prefix) throws Exception {
        Stat getStat = new Stat();
        List<ACL> getAcls = this.getACL(this.zkRootNodePath);
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        for (ACL acl : getAcls) {
            builder.append(acl.toString());
        }
        builder.append(getStat.toString());
        LOG.debug("{}", (Object)builder);
    }

    private void setRootNodeAcls() throws Exception {
        if (LOG.isDebugEnabled()) {
            this.logRootNodeAcls("Before setting ACLs'\n");
        }
        CuratorFramework curatorFramework = this.zkManager.getCurator();
        if (HAUtil.isHAEnabled((Configuration)this.getConfig())) {
            ((BackgroundPathable)curatorFramework.setACL().withACL(this.zkRootNodeAcl)).forPath(this.zkRootNodePath);
        } else {
            ((BackgroundPathable)curatorFramework.setACL().withACL(this.zkAcl)).forPath(this.zkRootNodePath);
        }
        if (LOG.isDebugEnabled()) {
            this.logRootNodeAcls("After setting ACLs'\n");
        }
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
        if (this.verifyActiveStatusThread != null) {
            this.verifyActiveStatusThread.interrupt();
            this.verifyActiveStatusThread.join(1000L);
        }
        if (this.resourceManager.getZKManager() == null) {
            CuratorFramework curatorFramework = this.zkManager.getCurator();
            IOUtils.closeStream((Closeable)curatorFramework);
        }
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    protected synchronized void storeVersion() throws Exception {
        String versionNodePath = this.getNodePath(this.zkRootNodePath, "RMVersionNode");
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.exists(versionNodePath)) {
            this.zkManager.safeSetData(versionNodePath, data, -1, this.zkAcl, this.fencingNodePath);
        } else {
            this.zkManager.safeCreate(versionNodePath, data, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
        }
    }

    @Override
    protected synchronized Version loadVersion() throws Exception {
        String versionNodePath = this.getNodePath(this.zkRootNodePath, "RMVersionNode");
        if (this.exists(versionNodePath)) {
            byte[] data = this.getData(versionNodePath);
            return new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
        }
        return null;
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        String epochNodePath = this.getNodePath(this.zkRootNodePath, "EpochNode");
        long currentEpoch = this.baseEpoch;
        if (this.exists(epochNodePath)) {
            byte[] data = this.getData(epochNodePath);
            EpochPBImpl epoch = new EpochPBImpl(YarnServerResourceManagerRecoveryProtos.EpochProto.parseFrom(data));
            currentEpoch = ((Epoch)epoch).getEpoch();
            byte[] storeData = Epoch.newInstance(this.nextEpoch(currentEpoch)).getProto().toByteArray();
            this.zkManager.safeSetData(epochNodePath, storeData, -1, this.zkAcl, this.fencingNodePath);
        } else {
            byte[] storeData = Epoch.newInstance(this.nextEpoch(currentEpoch)).getProto().toByteArray();
            this.zkManager.safeCreate(epochNodePath, storeData, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
        }
        return currentEpoch;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        long start = this.clock.getTime();
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMAppState(rmState);
        this.loadAMRMTokenSecretManagerState(rmState);
        this.loadReservationSystemState(rmState);
        this.loadProxyCAManagerState(rmState);
        this.opDurations.addLoadStateCallDuration(this.clock.getTime() - start);
        return rmState;
    }

    private void loadReservationSystemState(RMStateStore.RMState rmState) throws Exception {
        List<String> planNodes = this.getChildren(this.reservationRoot);
        for (String planName : planNodes) {
            LOG.debug("Loading plan from znode: {}", (Object)planName);
            String planNodePath = this.getNodePath(this.reservationRoot, planName);
            List<String> reservationNodes = this.getChildren(planNodePath);
            for (String reservationNodeName : reservationNodes) {
                String reservationNodePath = this.getNodePath(planNodePath, reservationNodeName);
                LOG.debug("Loading reservation from znode: {}", (Object)reservationNodePath);
                byte[] reservationData = this.getData(reservationNodePath);
                YarnProtos.ReservationAllocationStateProto allocationState = YarnProtos.ReservationAllocationStateProto.parseFrom((byte[])reservationData);
                if (!rmState.getReservationState().containsKey(planName)) {
                    rmState.getReservationState().put(planName, new HashMap());
                }
                ReservationId reservationId = ReservationId.parseReservationId((String)reservationNodeName);
                rmState.getReservationState().get(planName).put(reservationId, allocationState);
            }
        }
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        byte[] data = this.getData(this.amrmTokenSecretManagerRoot);
        if (data == null) {
            LOG.warn("There is no data saved");
        } else {
            AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom(data));
            rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
        }
    }

    private synchronized void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        this.loadRMDelegationKeyState(rmState);
        this.loadRMSequentialNumberState(rmState);
        this.loadRMDelegationTokenState(rmState);
    }

    private void loadRMDelegationKeyState(RMStateStore.RMState rmState) throws Exception {
        List<String> childNodes = this.getChildren(this.dtMasterKeysRootPath);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.dtMasterKeysRootPath, childNodeName);
            byte[] childData = this.getData(childNodePath);
            if (childData == null) {
                LOG.warn("Content of " + childNodePath + " is broken.");
                continue;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            Throwable throwable = null;
            try {
                if (!childNodeName.startsWith("DelegationKey_")) continue;
                DelegationKey key = new DelegationKey();
                key.readFields((DataInput)fsIn);
                rmState.rmSecretManagerState.masterKeyState.add(key);
                LOG.debug("Loaded delegation key: keyId={}, expirationDate={}", (Object)key.getKeyId(), (Object)key.getExpiryDate());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fsIn == null) continue;
                if (throwable != null) {
                    try {
                        fsIn.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fsIn.close();
            }
        }
    }

    private void loadRMSequentialNumberState(RMStateStore.RMState rmState) throws Exception {
        byte[] seqData = this.getData(this.dtSequenceNumberPath);
        if (seqData != null) {
            ByteArrayInputStream seqIs = new ByteArrayInputStream(seqData);
            try (DataInputStream seqIn = new DataInputStream(seqIs);){
                rmState.rmSecretManagerState.dtSequenceNumber = seqIn.readInt();
            }
        }
    }

    private void loadRMDelegationTokenState(RMStateStore.RMState rmState) throws Exception {
        for (int splitIndex = 0; splitIndex <= 4; ++splitIndex) {
            String tokenRoot = this.rmDelegationTokenHierarchies.get(splitIndex);
            if (tokenRoot == null) continue;
            List<String> childNodes = this.getChildren(tokenRoot);
            boolean dtNodeFound = false;
            for (String childNodeName : childNodes) {
                if (childNodeName.startsWith("RMDelegationToken_")) {
                    dtNodeFound = true;
                    String parentNodePath = this.getNodePath(tokenRoot, childNodeName);
                    if (splitIndex == 0) {
                        this.loadDelegationTokenFromNode(rmState, parentNodePath);
                        continue;
                    }
                    List<String> leafNodes = this.getChildren(parentNodePath);
                    for (String leafNodeName : leafNodes) {
                        this.loadDelegationTokenFromNode(rmState, this.getNodePath(parentNodePath, leafNodeName));
                    }
                    continue;
                }
                if (splitIndex != 0 || childNodeName.equals("1") || childNodeName.equals("2") || childNodeName.equals("3") || childNodeName.equals("4")) continue;
                LOG.debug("Unknown child node with name {} under {}", (Object)childNodeName, (Object)tokenRoot);
            }
            if (splitIndex == this.delegationTokenNodeSplitIndex || dtNodeFound) continue;
            this.rmDelegationTokenHierarchies.remove(splitIndex);
        }
    }

    private void loadDelegationTokenFromNode(RMStateStore.RMState rmState, String path) throws Exception {
        byte[] data = this.getData(path);
        if (data == null) {
            LOG.warn("Content of " + path + " is broken.");
        } else {
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            try (DataInputStream fsIn = new DataInputStream(is);){
                RMDelegationTokenIdentifierData identifierData = RMStateStoreUtils.readRMDelegationTokenIdentifierData(fsIn);
                RMDelegationTokenIdentifier identifier = identifierData.getTokenIdentifier();
                long renewDate = identifierData.getRenewDate();
                rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
                LOG.debug("Loaded RMDelegationTokenIdentifier: {} renewDate={}", (Object)identifier, (Object)renewDate);
            }
        }
    }

    private void loadRMAppStateFromAppNode(RMStateStore.RMState rmState, String appNodePath, String appIdStr) throws Exception {
        byte[] appData = this.getData(appNodePath);
        LOG.debug("Loading application from znode: {}", (Object)appNodePath);
        ApplicationId appId = ApplicationId.fromString((String)appIdStr);
        ApplicationStateDataPBImpl appState = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(appData));
        if (!appId.equals((Object)appState.getApplicationSubmissionContext().getApplicationId())) {
            throw new YarnRuntimeException("The node name is different from the application id");
        }
        rmState.appState.put(appId, appState);
        this.loadApplicationAttemptState(appState, appNodePath);
    }

    private synchronized void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        for (int splitIndex = 0; splitIndex <= 4; ++splitIndex) {
            String appRoot = this.rmAppRootHierarchies.get(splitIndex);
            if (appRoot == null) continue;
            List<String> childNodes = this.getChildren(appRoot);
            boolean appNodeFound = false;
            for (String childNodeName : childNodes) {
                if (childNodeName.startsWith("application")) {
                    appNodeFound = true;
                    if (splitIndex == 0) {
                        this.loadRMAppStateFromAppNode(rmState, this.getNodePath(appRoot, childNodeName), childNodeName);
                        continue;
                    }
                    String parentNodePath = this.getNodePath(appRoot, childNodeName);
                    List<String> leafNodes = this.getChildren(parentNodePath);
                    for (String leafNodeName : leafNodes) {
                        String appIdStr = childNodeName + leafNodeName;
                        this.loadRMAppStateFromAppNode(rmState, this.getNodePath(parentNodePath, leafNodeName), appIdStr);
                    }
                    continue;
                }
                if (childNodeName.equals(RM_APP_ROOT_HIERARCHIES)) continue;
                LOG.debug("Unknown child node with name {} under {}", (Object)childNodeName, (Object)appRoot);
            }
            if (splitIndex == this.appIdNodeSplitIndex || appNodeFound) continue;
            this.rmAppRootHierarchies.remove(splitIndex);
        }
    }

    private void loadApplicationAttemptState(ApplicationStateData appState, String appPath) throws Exception {
        List<String> attempts = this.getChildren(appPath);
        for (String attemptIDStr : attempts) {
            if (!attemptIDStr.startsWith("appattempt")) continue;
            String attemptPath = this.getNodePath(appPath, attemptIDStr);
            byte[] attemptData = this.getData(attemptPath);
            ApplicationAttemptStateDataPBImpl attemptState = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(attemptData));
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        LOG.debug("Done loading applications from ZK state store");
    }

    private String getSplitZnodeParent(String path, int splitIndex) {
        return path.substring(0, path.length() - splitIndex - 1);
    }

    private void checkRemoveParentZnode(String path, int splitIndex) throws Exception {
        if (splitIndex != 0) {
            String parentZnode = this.getSplitZnodeParent(path, splitIndex);
            List<String> children = null;
            try {
                children = this.getChildren(parentZnode);
            }
            catch (KeeperException.NoNodeException ke) {
                LOG.debug("Unable to remove parent node {} as it does not exist.", (Object)parentZnode);
                return;
            }
            if (children != null && children.isEmpty()) {
                try {
                    this.zkManager.safeDelete(parentZnode, this.zkAcl, this.fencingNodePath);
                    LOG.debug("No leaf znode exists. Removing parent node {}", (Object)parentZnode);
                }
                catch (KeeperException.NotEmptyException ke) {
                    LOG.debug("Unable to remove app parent node {} as it has children.", (Object)parentZnode);
                }
            }
        }
    }

    private void loadProxyCAManagerState(RMStateStore.RMState rmState) throws Exception {
        String caCertPath = this.getNodePath(this.proxyCARoot, "caCert");
        String caPrivateKeyPath = this.getNodePath(this.proxyCARoot, "caPrivateKey");
        if (!this.exists(caCertPath) || !this.exists(caPrivateKeyPath)) {
            LOG.warn("Couldn't find Proxy CA data");
            return;
        }
        byte[] caCertData = this.getData(caCertPath);
        byte[] caPrivateKeyData = this.getData(caPrivateKeyPath);
        if (caCertData == null || caPrivateKeyData == null) {
            LOG.warn("Couldn't recover Proxy CA data");
            return;
        }
        rmState.getProxyCAState().setCaCert(caCertData);
        rmState.getProxyCAState().setCaPrivateKey(caPrivateKeyData);
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        long start = this.clock.getTime();
        String nodeCreatePath = this.getLeafAppIdNodePath(appId.toString(), true);
        LOG.debug("Storing info for app: {} at: {}", (Object)appId, (Object)nodeCreatePath);
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        if (appStateData.length > this.zknodeLimit) {
            LOG.debug("Application state data size for {} is {}", (Object)appId, (Object)appStateData.length);
            throw new StoreLimitException("Application " + appId + " exceeds the maximum allowed size for application data. See yarn.resourcemanager.zk-max-znode-size.bytes.");
        }
        this.zkManager.safeCreate(nodeCreatePath, appStateData, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
        this.opDurations.addStoreApplicationStateCallDuration(this.clock.getTime() - start);
    }

    @Override
    protected synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        long start = this.clock.getTime();
        String nodeUpdatePath = this.getLeafAppIdNodePath(appId.toString(), false);
        boolean pathExists = true;
        if (!this.exists(nodeUpdatePath)) {
            ZnodeSplitInfo alternatePathInfo = this.getAlternateAppPath(appId.toString());
            if (alternatePathInfo != null) {
                nodeUpdatePath = alternatePathInfo.path;
            } else {
                String rootNode;
                pathExists = false;
                if (this.appIdNodeSplitIndex != 0 && !this.exists(rootNode = this.getSplitZnodeParent(nodeUpdatePath, this.appIdNodeSplitIndex))) {
                    this.zkManager.safeCreate(rootNode, null, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
                }
            }
        }
        LOG.debug("Storing final state info for app: {} at: {}", (Object)appId, (Object)nodeUpdatePath);
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        if (pathExists) {
            this.zkManager.safeSetData(nodeUpdatePath, appStateData, -1, this.zkAcl, this.fencingNodePath);
        } else {
            this.zkManager.safeCreate(nodeUpdatePath, appStateData, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
            LOG.debug("Path {} for {} didn't exist. Creating a new znode to update the application state.", (Object)nodeUpdatePath, (Object)appId);
        }
        this.opDurations.addUpdateApplicationStateCallDuration(this.clock.getTime() - start);
    }

    private void handleApplicationAttemptStateOp(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB, AppAttemptOp operation) throws Exception {
        String appId = appAttemptId.getApplicationId().toString();
        String appDirPath = this.getLeafAppIdNodePath(appId, false);
        if (!this.exists(appDirPath)) {
            ZnodeSplitInfo alternatePathInfo = this.getAlternateAppPath(appId);
            if (alternatePathInfo == null) {
                if (operation == AppAttemptOp.REMOVE) {
                    return;
                }
                throw new YarnRuntimeException("Unexpected Exception. App node for app " + appId + " not found");
            }
            appDirPath = alternatePathInfo.path;
        }
        String path = this.getNodePath(appDirPath, appAttemptId.toString());
        byte[] attemptStateData = attemptStateDataPB == null ? null : attemptStateDataPB.getProto().toByteArray();
        LOG.debug("{} info for attempt: {} at: {}", new Object[]{operation, appAttemptId, path});
        switch (operation) {
            case UPDATE: {
                if (this.exists(path)) {
                    this.zkManager.safeSetData(path, attemptStateData, -1, this.zkAcl, this.fencingNodePath);
                    break;
                }
                this.zkManager.safeCreate(path, attemptStateData, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
                LOG.debug("Path {} for {} didn't exist. Created a new znode to update the application attempt state.", (Object)path, (Object)appAttemptId);
                break;
            }
            case STORE: {
                this.zkManager.safeCreate(path, attemptStateData, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
                break;
            }
            case REMOVE: {
                this.zkManager.safeDelete(path, this.zkAcl, this.fencingNodePath);
                break;
            }
        }
    }

    @Override
    protected synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        this.handleApplicationAttemptStateOp(appAttemptId, attemptStateDataPB, AppAttemptOp.STORE);
    }

    @Override
    protected synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        this.handleApplicationAttemptStateOp(appAttemptId, attemptStateDataPB, AppAttemptOp.UPDATE);
    }

    @Override
    protected synchronized void removeApplicationAttemptInternal(ApplicationAttemptId appAttemptId) throws Exception {
        this.handleApplicationAttemptStateOp(appAttemptId, null, AppAttemptOp.REMOVE);
    }

    @Override
    protected synchronized void removeApplicationStateInternal(ApplicationStateData appState) throws Exception {
        long start = this.clock.getTime();
        this.removeApp(appState.getApplicationSubmissionContext().getApplicationId().toString(), true, appState.attempts.keySet());
        this.opDurations.addRemoveApplicationStateCallDuration(this.clock.getTime() - start);
    }

    private void removeApp(String removeAppId) throws Exception {
        this.removeApp(removeAppId, false, null);
    }

    private void removeApp(String removeAppId, boolean safeRemove, Set<ApplicationAttemptId> attempts) throws Exception {
        String appIdRemovePath = this.getLeafAppIdNodePath(removeAppId, false);
        int splitIndex = this.appIdNodeSplitIndex;
        if (!this.exists(appIdRemovePath)) {
            ZnodeSplitInfo alternatePathInfo = this.getAlternateAppPath(removeAppId);
            if (alternatePathInfo != null) {
                appIdRemovePath = alternatePathInfo.path;
                splitIndex = alternatePathInfo.splitIndex;
            } else {
                return;
            }
        }
        if (safeRemove) {
            LOG.debug("Removing info for app: {} at: {} and its attempts.", (Object)removeAppId, (Object)appIdRemovePath);
            if (attempts != null) {
                for (ApplicationAttemptId attemptId : attempts) {
                    String attemptRemovePath = this.getNodePath(appIdRemovePath, attemptId.toString());
                    this.zkManager.safeDelete(attemptRemovePath, this.zkAcl, this.fencingNodePath);
                }
            }
            this.zkManager.safeDelete(appIdRemovePath, this.zkAcl, this.fencingNodePath);
        } else {
            CuratorFramework curatorFramework = this.zkManager.getCurator();
            curatorFramework.delete().deletingChildrenIfNeeded().forPath(appIdRemovePath);
        }
        this.checkRemoveParentZnode(appIdRemovePath, splitIndex);
    }

    @Override
    protected synchronized void storeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        String nodeCreatePath = this.getLeafDelegationTokenNodePath(rmDTIdentifier.getSequenceNumber(), true);
        LOG.debug("Storing {}{}", (Object)"RMDelegationToken_", (Object)rmDTIdentifier.getSequenceNumber());
        RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)rmDTIdentifier, renewDate);
        ByteArrayOutputStream seqOs = new ByteArrayOutputStream();
        try (DataOutputStream seqOut = new DataOutputStream(seqOs);){
            ZKCuratorManager.SafeTransaction trx = this.zkManager.createTransaction(this.zkAcl, this.fencingNodePath);
            trx.create(nodeCreatePath, identifierData.toByteArray(), this.zkAcl, CreateMode.PERSISTENT);
            seqOut.writeInt(rmDTIdentifier.getSequenceNumber());
            LOG.debug("Storing {}. SequenceNumber: {}", (Object)this.dtSequenceNumberPath, (Object)rmDTIdentifier.getSequenceNumber());
            trx.setData(this.dtSequenceNumberPath, seqOs.toByteArray(), -1);
            trx.commit();
        }
    }

    @Override
    protected synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier) throws Exception {
        String nodeRemovePath = this.getLeafDelegationTokenNodePath(rmDTIdentifier.getSequenceNumber(), false);
        int splitIndex = this.delegationTokenNodeSplitIndex;
        if (!this.exists(nodeRemovePath)) {
            ZnodeSplitInfo alternatePathInfo = this.getAlternateDTPath(rmDTIdentifier.getSequenceNumber());
            if (alternatePathInfo != null) {
                nodeRemovePath = alternatePathInfo.path;
                splitIndex = alternatePathInfo.splitIndex;
            } else {
                return;
            }
        }
        LOG.debug("Removing RMDelegationToken_{}", (Object)rmDTIdentifier.getSequenceNumber());
        this.zkManager.safeDelete(nodeRemovePath, this.zkAcl, this.fencingNodePath);
        this.checkRemoveParentZnode(nodeRemovePath, splitIndex);
    }

    @Override
    protected synchronized void updateRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        String nodeUpdatePath = this.getLeafDelegationTokenNodePath(rmDTIdentifier.getSequenceNumber(), false);
        boolean pathExists = true;
        if (!this.exists(nodeUpdatePath)) {
            ZnodeSplitInfo alternatePathInfo = this.getAlternateDTPath(rmDTIdentifier.getSequenceNumber());
            if (alternatePathInfo != null) {
                nodeUpdatePath = alternatePathInfo.path;
            } else {
                pathExists = false;
            }
        }
        if (pathExists) {
            LOG.debug("Updating {}{}", (Object)"RMDelegationToken_", (Object)rmDTIdentifier.getSequenceNumber());
            RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)rmDTIdentifier, renewDate);
            this.zkManager.safeSetData(nodeUpdatePath, identifierData.toByteArray(), -1, this.zkAcl, this.fencingNodePath);
        } else {
            this.storeRMDelegationTokenState(rmDTIdentifier, renewDate);
        }
    }

    @Override
    protected synchronized void storeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        String nodeCreatePath = this.getNodePath(this.dtMasterKeysRootPath, "DelegationKey_" + delegationKey.getKeyId());
        LOG.debug("Storing RMDelegationKey_{}", (Object)delegationKey.getKeyId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DataOutputStream fsOut = new DataOutputStream(os);){
            delegationKey.write((DataOutput)fsOut);
            this.zkManager.safeCreate(nodeCreatePath, os.toByteArray(), this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
        }
    }

    @Override
    protected synchronized void removeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        String nodeRemovePath = this.getNodePath(this.dtMasterKeysRootPath, "DelegationKey_" + delegationKey.getKeyId());
        LOG.debug("Removing RMDelegationKey_{}", (Object)delegationKey.getKeyId());
        this.zkManager.safeDelete(nodeRemovePath, this.zkAcl, this.fencingNodePath);
    }

    @Override
    public synchronized void deleteStore() throws Exception {
        this.delete(this.zkRootNodePath);
    }

    @Override
    public synchronized void removeApplication(ApplicationId removeAppId) throws Exception {
        this.removeApp(removeAppId.toString());
    }

    @VisibleForTesting
    String getNodePath(String root, String nodeName) {
        return root + "/" + nodeName;
    }

    @Override
    protected synchronized void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState amrmTokenSecretManagerState, boolean isUpdate) throws Exception {
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(amrmTokenSecretManagerState);
        byte[] stateData = data.getProto().toByteArray();
        this.zkManager.safeSetData(this.amrmTokenSecretManagerRoot, stateData, -1, this.zkAcl, this.fencingNodePath);
    }

    @Override
    protected synchronized void removeReservationState(String planName, String reservationIdName) throws Exception {
        String planNodePath = this.getNodePath(this.reservationRoot, planName);
        String reservationPath = this.getNodePath(planNodePath, reservationIdName);
        LOG.debug("Removing reservationallocation {} for plan {}", (Object)reservationIdName, (Object)planName);
        this.zkManager.safeDelete(reservationPath, this.zkAcl, this.fencingNodePath);
        List<String> reservationNodes = this.getChildren(planNodePath);
        if (reservationNodes.isEmpty()) {
            this.zkManager.safeDelete(planNodePath, this.zkAcl, this.fencingNodePath);
        }
    }

    @Override
    protected synchronized void storeReservationState(YarnProtos.ReservationAllocationStateProto reservationAllocation, String planName, String reservationIdName) throws Exception {
        ZKCuratorManager.SafeTransaction trx = this.zkManager.createTransaction(this.zkAcl, this.fencingNodePath);
        this.addOrUpdateReservationState(reservationAllocation, planName, reservationIdName, trx, false);
        trx.commit();
    }

    private void addOrUpdateReservationState(YarnProtos.ReservationAllocationStateProto reservationAllocation, String planName, String reservationIdName, ZKCuratorManager.SafeTransaction trx, boolean isUpdate) throws Exception {
        String planCreatePath = this.getNodePath(this.reservationRoot, planName);
        String reservationPath = this.getNodePath(planCreatePath, reservationIdName);
        byte[] reservationData = reservationAllocation.toByteArray();
        if (!this.exists(planCreatePath)) {
            LOG.debug("Creating plan node: {} at: {}", (Object)planName, (Object)planCreatePath);
            trx.create(planCreatePath, null, this.zkAcl, CreateMode.PERSISTENT);
        }
        if (isUpdate) {
            LOG.debug("Updating reservation: {} in plan:{} at: {}", new Object[]{reservationIdName, planName, reservationPath});
            trx.setData(reservationPath, reservationData, -1);
        } else {
            LOG.debug("Storing reservation: {} in plan:{} at: {}", new Object[]{reservationIdName, planName, reservationPath});
            trx.create(reservationPath, reservationData, this.zkAcl, CreateMode.PERSISTENT);
        }
    }

    @Override
    protected void storeProxyCACertState(X509Certificate caCert, PrivateKey caPrivateKey) throws Exception {
        byte[] caCertData = caCert.getEncoded();
        byte[] caPrivateKeyData = caPrivateKey.getEncoded();
        String caCertPath = this.getNodePath(this.proxyCARoot, "caCert");
        String caPrivateKeyPath = this.getNodePath(this.proxyCARoot, "caPrivateKey");
        if (this.exists(caCertPath)) {
            this.zkManager.safeSetData(caCertPath, caCertData, -1, this.zkAcl, this.fencingNodePath);
        } else {
            this.zkManager.safeCreate(caCertPath, caCertData, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
        }
        if (this.exists(caPrivateKeyPath)) {
            this.zkManager.safeSetData(caPrivateKeyPath, caPrivateKeyData, -1, this.zkAcl, this.fencingNodePath);
        } else {
            this.zkManager.safeCreate(caPrivateKeyPath, caPrivateKeyData, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
        }
    }

    private ZnodeSplitInfo getAlternateAppPath(String appId) throws Exception {
        for (Map.Entry<Integer, String> entry : this.rmAppRootHierarchies.entrySet()) {
            String alternatePath;
            int splitIndex = entry.getKey();
            if (splitIndex == this.appIdNodeSplitIndex || !this.exists(alternatePath = this.getLeafZnodePath(appId, entry.getValue(), splitIndex, false))) continue;
            return new ZnodeSplitInfo(alternatePath, splitIndex);
        }
        return null;
    }

    private String getLeafZnodePath(String nodeName, String rootNode, int splitIdx, boolean createParentIfNotExists) throws Exception {
        if (splitIdx == 0) {
            return this.getNodePath(rootNode, nodeName);
        }
        int split = nodeName.length() - splitIdx;
        String rootNodePath = this.getNodePath(rootNode, nodeName.substring(0, split));
        if (createParentIfNotExists && !this.exists(rootNodePath)) {
            try {
                this.zkManager.safeCreate(rootNodePath, null, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
            }
            catch (KeeperException.NodeExistsException e) {
                LOG.debug("Unable to create app parent node {} as it already exists.", (Object)rootNodePath);
            }
        }
        return this.getNodePath(rootNodePath, nodeName.substring(split));
    }

    private String getLeafAppIdNodePath(String appId, boolean createParentIfNotExists) throws Exception {
        return this.getLeafZnodePath(appId, this.rmAppRootHierarchies.get(this.appIdNodeSplitIndex), this.appIdNodeSplitIndex, createParentIfNotExists);
    }

    private String getLeafDelegationTokenNodePath(int rmDTSequenceNumber, boolean createParentIfNotExists) throws Exception {
        return this.getLeafDelegationTokenNodePath(rmDTSequenceNumber, createParentIfNotExists, this.delegationTokenNodeSplitIndex);
    }

    private String getLeafDelegationTokenNodePath(int rmDTSequenceNumber, boolean createParentIfNotExists, int split) throws Exception {
        String nodeName = "RMDelegationToken_";
        nodeName = split == 0 ? nodeName + rmDTSequenceNumber : nodeName + String.format("%04d", rmDTSequenceNumber);
        return this.getLeafZnodePath(nodeName, this.rmDelegationTokenHierarchies.get(split), split, createParentIfNotExists);
    }

    private ZnodeSplitInfo getAlternateDTPath(int rmDTSequenceNumber) throws Exception {
        for (int splitIndex : this.rmDelegationTokenHierarchies.keySet()) {
            String alternatePath;
            if (splitIndex == this.delegationTokenNodeSplitIndex || !this.exists(alternatePath = this.getLeafDelegationTokenNodePath(rmDTSequenceNumber, false, splitIndex))) continue;
            return new ZnodeSplitInfo(alternatePath, splitIndex);
        }
        return null;
    }

    @VisibleForTesting
    byte[] getData(String path) throws Exception {
        return this.zkManager.getData(path);
    }

    @VisibleForTesting
    List<ACL> getACL(String path) throws Exception {
        return this.zkManager.getACL(path);
    }

    @VisibleForTesting
    List<String> getChildren(String path) throws Exception {
        return this.zkManager.getChildren(path);
    }

    @VisibleForTesting
    boolean exists(String path) throws Exception {
        return this.zkManager.exists(path);
    }

    @VisibleForTesting
    void create(String path) throws Exception {
        this.zkManager.create(path, this.zkAcl);
    }

    @VisibleForTesting
    void delete(String path) throws Exception {
        this.zkManager.delete(path);
    }

    private class VerifyActiveStatusThread
    extends Thread {
        VerifyActiveStatusThread() {
            super(VerifyActiveStatusThread.class.getName());
        }

        @Override
        public void run() {
            try {
                while (!ZKRMStateStore.this.isFencedState()) {
                    ZKRMStateStore.this.zkManager.createTransaction(ZKRMStateStore.this.zkAcl, ZKRMStateStore.this.fencingNodePath).commit();
                    Thread.sleep(ZKRMStateStore.this.zkSessionTimeout);
                }
            }
            catch (InterruptedException ie) {
                LOG.info(this.getName() + " thread interrupted! Exiting!");
                this.interrupt();
            }
            catch (Exception e) {
                ZKRMStateStore.this.notifyStoreOperationFailed((Exception)((Object)new StoreFencedException()));
            }
        }
    }

    private static final class ZnodeSplitInfo {
        private final String path;
        private final int splitIndex;

        ZnodeSplitInfo(String path, int splitIndex) {
            this.path = path;
            this.splitIndex = splitIndex;
        }
    }

    private static enum AppAttemptOp {
        STORE,
        UPDATE,
        REMOVE;

    }
}

