/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelInfo;

@XmlRootElement(name="nodeLabelsInfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NodeLabelsInfo {
    @XmlElement(name="nodeLabelInfo")
    private ArrayList<NodeLabelInfo> nodeLabelsInfo = new ArrayList();

    public NodeLabelsInfo() {
    }

    public NodeLabelsInfo(ArrayList<NodeLabelInfo> nodeLabels) {
        this.nodeLabelsInfo = nodeLabels;
    }

    public NodeLabelsInfo(List<NodeLabel> nodeLabels) {
        this.nodeLabelsInfo = new ArrayList();
        for (NodeLabel label : nodeLabels) {
            this.nodeLabelsInfo.add(new NodeLabelInfo(label));
        }
    }

    public NodeLabelsInfo(Set<String> nodeLabelsName) {
        this.nodeLabelsInfo = new ArrayList();
        for (String labelName : nodeLabelsName) {
            this.nodeLabelsInfo.add(new NodeLabelInfo(labelName));
        }
    }

    public NodeLabelsInfo(Collection<NodeLabel> nodeLabels) {
        this.nodeLabelsInfo = new ArrayList();
        nodeLabels.stream().forEach(nodeLabel -> this.nodeLabelsInfo.add(new NodeLabelInfo((NodeLabel)nodeLabel)));
    }

    public ArrayList<NodeLabelInfo> getNodeLabelsInfo() {
        return this.nodeLabelsInfo;
    }

    public Set<NodeLabel> getNodeLabels() {
        HashSet<NodeLabel> nodeLabels = new HashSet<NodeLabel>();
        for (NodeLabelInfo label : this.nodeLabelsInfo) {
            nodeLabels.add(NodeLabel.newInstance((String)label.getName(), (boolean)label.getExclusivity()));
        }
        return nodeLabels;
    }

    public List<String> getNodeLabelsName() {
        ArrayList<String> nodeLabelsName = new ArrayList<String>();
        for (NodeLabelInfo label : this.nodeLabelsInfo) {
            nodeLabelsName.add(label.getName());
        }
        return nodeLabelsName;
    }

    public void setNodeLabelsInfo(ArrayList<NodeLabelInfo> nodeLabelInfo) {
        this.nodeLabelsInfo = nodeLabelInfo;
    }
}

