/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerQueueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueueStateManager<T extends SchedulerQueue, E extends ReservationSchedulerConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(QueueStateManager.class);
    private SchedulerQueueManager<T, E> queueManager;

    public synchronized void initialize(SchedulerQueueManager<T, E> newQueueManager) {
        this.queueManager = newQueueManager;
    }

    public synchronized void stopQueue(String queueName) throws YarnException {
        T queue = this.queueManager.getQueue(queueName);
        if (queue == null) {
            throw new YarnException("The specified queue:" + queueName + " does not exist!");
        }
        queue.stopQueue();
    }

    public synchronized void activateQueue(String queueName) throws YarnException {
        T queue = this.queueManager.getQueue(queueName);
        if (queue == null) {
            throw new YarnException("The specified queue:" + queueName + " does not exist!");
        }
        queue.activateQueue();
    }

    public boolean canDelete(String queueName) {
        T queue = this.queueManager.getQueue(queueName);
        if (queue == null) {
            LOG.info("The specified queue:" + queueName + " does not exist!");
            return false;
        }
        if (queue.getState() == QueueState.STOPPED) {
            return true;
        }
        LOG.info("Need to stop the specific queue:" + queueName + " first.");
        return false;
    }
}

