/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.filter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.filter.MockCandidateFilter;
import org.apache.hadoop.shaded.org.mockito.internal.configuration.injection.filter.OngoingInjector;
import org.apache.hadoop.shaded.org.mockito.internal.util.MockUtil;

public class NameBasedCandidateFilter
implements MockCandidateFilter {
    private final MockCandidateFilter next;

    public NameBasedCandidateFilter(MockCandidateFilter next) {
        this.next = next;
    }

    @Override
    public OngoingInjector filterCandidate(Collection<Object> mocks, Field candidateFieldToBeInjected, List<Field> allRemainingCandidateFields, Object injectee) {
        if (mocks.size() == 1 && this.anotherCandidateMatchesMockName(mocks, candidateFieldToBeInjected, allRemainingCandidateFields)) {
            return OngoingInjector.nop;
        }
        return this.next.filterCandidate(this.tooMany(mocks) ? this.selectMatchingName(mocks, candidateFieldToBeInjected) : mocks, candidateFieldToBeInjected, allRemainingCandidateFields, injectee);
    }

    private boolean tooMany(Collection<Object> mocks) {
        return mocks.size() > 1;
    }

    private List<Object> selectMatchingName(Collection<Object> mocks, Field candidateFieldToBeInjected) {
        ArrayList<Object> mockNameMatches = new ArrayList<Object>();
        for (Object mock : mocks) {
            if (!candidateFieldToBeInjected.getName().equals(MockUtil.getMockName(mock).toString())) continue;
            mockNameMatches.add(mock);
        }
        return mockNameMatches;
    }

    private boolean anotherCandidateMatchesMockName(Collection<Object> mocks, Field candidateFieldToBeInjected, List<Field> allRemainingCandidateFields) {
        String mockName = MockUtil.getMockName(mocks.iterator().next()).toString();
        for (Field otherCandidateField : allRemainingCandidateFields) {
            if (otherCandidateField.equals(candidateFieldToBeInjected) || !otherCandidateField.getType().equals(candidateFieldToBeInjected.getType()) || !otherCandidateField.getName().equals(mockName)) continue;
            return true;
        }
        return false;
    }
}

