/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.B2CConverter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.BufferChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.ByteChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.CharChunk;

public final class UTF8Decoder
extends B2CConverter {
    private static final Logger LOGGER = Grizzly.logger(UTF8Decoder.class);
    private static final int debug = 1;

    @Override
    public void recycle() {
    }

    @Override
    public void convert(ByteChunk mb, CharChunk cb) throws IOException {
        int bytesOff = mb.getOffset();
        int bytesLen = mb.getLength();
        byte[] bytes = mb.getBytes();
        int j = bytesOff;
        int end = j + bytesLen;
        while (j < end) {
            int b0 = 0xFF & bytes[j];
            if ((b0 & 0x80) == 0) {
                cb.append((char)b0);
                ++j;
                continue;
            }
            if (j++ >= end) {
                throw new IOException("Conversion error - EOF ");
            }
            int b1 = 0xFF & bytes[j];
            if ((0xE0 & b0) == 192) {
                int ch = ((0x1F & b0) << 6) + (0x3F & b1);
                this.log("Convert " + b0 + ' ' + b1 + ' ' + ch + (char)ch);
                cb.append((char)ch);
                ++j;
                continue;
            }
            if (j++ >= end) {
                return;
            }
            int b2 = 0xFF & bytes[j];
            if ((b0 & 0xF0) == 224) {
                if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                    this.log("Error " + b0 + ' ' + b1 + ' ' + b2);
                    throw new IOException("Conversion error 2");
                }
                int ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                cb.append((char)ch);
                this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + ch + (char)ch);
                ++j;
                continue;
            }
            if (j++ >= end) {
                return;
            }
            int b3 = 0xFF & bytes[j];
            if ((0xF8 & b0) == 240) {
                if (b0 > 244 || b0 == 244 && b1 >= 144) {
                    this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + b3);
                    throw new IOException("Conversion error ");
                }
                int ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3);
                this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + b3 + ' ' + ch + (char)ch);
                if (ch < 65536) {
                    cb.append((char)ch);
                } else {
                    cb.append((char)((ch - 65536 >> 10) + 55296));
                    cb.append((char)((ch - 65536 & 0x3FF) + 56320));
                }
                ++j;
                continue;
            }
            this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + b3);
            throw new IOException("Conversion error 4");
        }
    }

    public void convert(BufferChunk bc, CharChunk cc) throws IOException {
        int bytesOff = bc.getStart();
        int bytesLen = bc.getLength();
        Buffer bytes = bc.getBuffer();
        int j = bytesOff;
        int end = j + bytesLen;
        while (j < end) {
            int b0 = 0xFF & bytes.get(j);
            if ((b0 & 0x80) == 0) {
                cc.append((char)b0);
                ++j;
                continue;
            }
            if (j++ >= end) {
                throw new CharConversionException("Conversion error - EOF ");
            }
            int b1 = 0xFF & bytes.get(j);
            if ((0xE0 & b0) == 192) {
                int ch = ((0x1F & b0) << 6) + (0x3F & b1);
                this.log("Convert " + b0 + ' ' + b1 + ' ' + ch + (char)ch);
                cc.append((char)ch);
                ++j;
                continue;
            }
            if (j++ >= end) {
                return;
            }
            int b2 = 0xFF & bytes.get(j);
            if ((b0 & 0xF0) == 224) {
                if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                    this.log("Error " + b0 + ' ' + b1 + ' ' + b2);
                    throw new CharConversionException("Conversion error 2");
                }
                int ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                cc.append((char)ch);
                this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + ch + (char)ch);
                ++j;
                continue;
            }
            if (j++ >= end) {
                return;
            }
            int b3 = 0xFF & bytes.get(j);
            if ((0xF8 & b0) == 240) {
                if (b0 > 244 || b0 == 244 && b1 >= 144) {
                    this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + b3);
                    throw new CharConversionException("Conversion error ");
                }
                int ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3);
                this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + b3 + ' ' + ch + (char)ch);
                if (ch < 65536) {
                    cc.append((char)ch);
                } else {
                    cc.append((char)((ch - 65536 >> 10) + 55296));
                    cc.append((char)((ch - 65536 & 0x3FF) + 56320));
                }
                ++j;
                continue;
            }
            this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + b3);
            throw new CharConversionException("Conversion error 4");
        }
    }

    public int convert(BufferChunk bc, char[] c, int offset) throws IOException {
        int bytesOff = bc.getStart();
        int bytesLen = bc.getLength();
        Buffer bytes = bc.getBuffer();
        int j = bytesOff;
        int end = j + bytesLen;
        while (j < end) {
            int b0 = 0xFF & bytes.get(j);
            if ((b0 & 0x80) == 0) {
                c[offset++] = (char)b0;
                ++j;
                continue;
            }
            if (j++ >= end) {
                throw new CharConversionException("Conversion error - EOF ");
            }
            int b1 = 0xFF & bytes.get(j);
            if ((0xE0 & b0) == 192) {
                int ch = ((0x1F & b0) << 6) + (0x3F & b1);
                this.log("Convert " + b0 + ' ' + b1 + ' ' + ch + (char)ch);
                c[offset++] = (char)ch;
                ++j;
                continue;
            }
            if (j++ >= end) {
                return offset;
            }
            int b2 = 0xFF & bytes.get(j);
            if ((b0 & 0xF0) == 224) {
                if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                    this.log("Error " + b0 + ' ' + b1 + ' ' + b2);
                    throw new CharConversionException("Conversion error 2");
                }
                int ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                c[offset++] = (char)ch;
                this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + ch + (char)ch);
                ++j;
                continue;
            }
            if (j++ >= end) {
                return offset;
            }
            int b3 = 0xFF & bytes.get(j);
            if ((0xF8 & b0) == 240) {
                if (b0 > 244 || b0 == 244 && b1 >= 144) {
                    this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + b3);
                    throw new CharConversionException("Conversion error ");
                }
                int ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3);
                this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + b3 + ' ' + ch + (char)ch);
                if (ch < 65536) {
                    c[offset++] = (char)ch;
                } else {
                    c[offset++] = (char)((ch - 65536 >> 10) + 55296);
                    c[offset++] = (char)((ch - 65536 & 0x3FF) + 56320);
                }
                ++j;
                continue;
            }
            this.log("Convert " + b0 + ' ' + b1 + ' ' + b2 + ' ' + b3);
            throw new CharConversionException("Conversion error 4");
        }
        return offset;
    }

    @Override
    void log(String s) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "UTF8Decoder: {0}", s);
        }
    }
}

