/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.jsr107.internal;

import java.util.Objects;
import org.apache.hadoop.shaded.org.ehcache.core.spi.service.StatisticsService;
import org.apache.hadoop.shaded.org.ehcache.jsr107.Jsr107Service;
import org.apache.hadoop.shaded.org.ehcache.jsr107.config.ConfigurationElementState;
import org.apache.hadoop.shaded.org.ehcache.jsr107.config.Jsr107Configuration;
import org.apache.hadoop.shaded.org.ehcache.spi.service.Service;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceDependencies;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;

@ServiceDependencies(value={StatisticsService.class})
public class DefaultJsr107Service
implements Jsr107Service {
    private final Jsr107Configuration configuration;
    private volatile StatisticsService statisticsService;

    public DefaultJsr107Service(Jsr107Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        this.statisticsService = serviceProvider.getService(StatisticsService.class);
    }

    @Override
    public String getTemplateNameForCache(String cacheAlias) {
        Jsr107Configuration cfg = this.configuration;
        if (cfg == null) {
            return null;
        }
        String template = cfg.getTemplates().get(cacheAlias);
        if (template != null) {
            return template;
        }
        return cfg.getDefaultTemplate();
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean jsr107CompliantAtomics() {
        Jsr107Configuration cfg = this.configuration;
        if (cfg == null) {
            return true;
        }
        return cfg.isJsr107CompliantAtomics();
    }

    @Override
    public ConfigurationElementState isManagementEnabledOnAllCaches() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.isEnableManagementAll();
    }

    @Override
    public ConfigurationElementState isStatisticsEnabledOnAllCaches() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.isEnableStatisticsAll();
    }

    @Override
    public StatisticsService getStatistics() {
        return Objects.requireNonNull(this.statisticsService);
    }
}

