/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.core.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.shaded.org.ehcache.config.Builder;
import org.apache.hadoop.shaded.org.ehcache.core.spi.service.ServiceFactory;
import org.apache.hadoop.shaded.org.ehcache.core.util.ClassLoading;
import org.apache.hadoop.shaded.org.ehcache.spi.service.OptionalServiceDependencies;
import org.apache.hadoop.shaded.org.ehcache.spi.service.PluralService;
import org.apache.hadoop.shaded.org.ehcache.spi.service.Service;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceCreationConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceDependencies;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLocator
implements ServiceProvider<Service> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLocator.class);
    private final ServiceMap services;
    private final ReadWriteLock runningLock = new ReentrantReadWriteLock();
    private final AtomicBoolean running = new AtomicBoolean(false);

    public static DependencySet dependencySet() {
        return new DependencySet();
    }

    private ServiceLocator(ServiceMap services) {
        this.services = services;
    }

    @Override
    public <T extends Service> T getService(Class<T> serviceType) {
        if (serviceType.isAnnotationPresent(PluralService.class)) {
            throw new IllegalArgumentException(serviceType.getName() + " is marked as a PluralService");
        }
        Collection<T> registeredServices = this.getServicesOfType(serviceType);
        if (registeredServices.size() > 1) {
            throw new AssertionError((Object)("The non-PluralService type" + serviceType.getName() + " has more than one service registered"));
        }
        return (T)(registeredServices.isEmpty() ? null : (Service)registeredServices.iterator().next());
    }

    @Override
    public <T extends Service> Collection<T> getServicesOfType(Class<T> serviceType) {
        return this.services.get(serviceType);
    }

    public boolean knowsServiceFor(ServiceConfiguration<?, ?> serviceConfig) {
        return this.services.contains(serviceConfig.getServiceType());
    }

    public void startAllServices() {
        LinkedList<Service> started = new LinkedList<Service>();
        Lock lock = this.runningLock.writeLock();
        lock.lock();
        try {
            if (!this.running.compareAndSet(false, true)) {
                throw new IllegalStateException("Already started!");
            }
            LinkedList<Service> unstarted = new LinkedList<Service>(this.services.all());
            int totalServices = unstarted.size();
            long start = System.currentTimeMillis();
            LOGGER.debug("Starting {} Services...", (Object)totalServices);
            while (!unstarted.isEmpty()) {
                boolean startedSomething = false;
                Iterator it = unstarted.iterator();
                while (it.hasNext()) {
                    Service s = (Service)it.next();
                    if (this.hasUnstartedDependencies(s, unstarted)) {
                        LOGGER.trace("Delaying starting {}", (Object)s);
                        continue;
                    }
                    LOGGER.trace("Starting {}", (Object)s);
                    s.start(this);
                    started.push(s);
                    it.remove();
                    startedSomething = true;
                }
                if (startedSomething) {
                    LOGGER.trace("Cycle complete: " + unstarted.size() + " Services remaining");
                    continue;
                }
                throw new IllegalStateException("Cyclic dependency in Service set: " + unstarted);
            }
            LOGGER.debug("All Services successfully started, {} Services in {}ms", (Object)totalServices, (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            while (!started.isEmpty()) {
                Service toBeStopped = (Service)started.pop();
                try {
                    toBeStopped.stop();
                }
                catch (Exception e1) {
                    LOGGER.error("Stopping Service failed due to ", (Throwable)e1);
                }
            }
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllServices() throws Exception {
        Exception firstException = null;
        Lock lock = this.runningLock.writeLock();
        lock.lock();
        try {
            if (!this.running.compareAndSet(true, false)) {
                throw new IllegalStateException("Already stopped!");
            }
            LinkedList<Service> running = new LinkedList<Service>(this.services.all());
            int totalServices = running.size();
            long start = System.currentTimeMillis();
            LOGGER.debug("Stopping {} Services...", (Object)totalServices);
            while (!running.isEmpty()) {
                boolean stoppedSomething = false;
                Iterator it = running.iterator();
                while (it.hasNext()) {
                    Service s = (Service)it.next();
                    if (this.hasRunningDependents(s, running)) {
                        LOGGER.trace("Delaying stopping {}", (Object)s);
                        continue;
                    }
                    LOGGER.trace("Stopping {}", (Object)s);
                    try {
                        s.stop();
                    }
                    catch (Exception e) {
                        if (firstException == null) {
                            firstException = e;
                        }
                        LOGGER.error("Stopping Service failed due to ", (Throwable)e);
                    }
                    it.remove();
                    stoppedSomething = true;
                }
                if (stoppedSomething) {
                    LOGGER.trace("Cycle complete: " + running.size() + " Services remaining");
                    continue;
                }
                throw new AssertionError((Object)("Cyclic dependency in Service set: " + running));
            }
            LOGGER.debug("All Services successfully stopped, {} Services in {}ms", (Object)totalServices, (Object)(System.currentTimeMillis() - start));
        }
        finally {
            lock.unlock();
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    private boolean hasUnstartedDependencies(Service service, Iterable<Service> unstarted) {
        for (Class<? extends Service> dep : ServiceLocator.identifyTransitiveDependenciesOf(service.getClass())) {
            for (Service s : unstarted) {
                if (!dep.isInstance(s)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRunningDependents(Service service, Iterable<Service> running) {
        for (Service runningService : running) {
            Set<Class<? extends Service>> dependencyClasses = ServiceLocator.identifyTransitiveDependenciesOf(runningService.getClass());
            for (Class<? extends Service> dependencyClass : dependencyClasses) {
                if (!dependencyClass.isInstance(service)) continue;
                return true;
            }
        }
        return false;
    }

    private static Collection<Class<?>> getAllInterfaces(Class<?> clazz) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Class<?> i : c.getInterfaces()) {
                interfaces.add(i);
                interfaces.addAll(ServiceLocator.getAllInterfaces(i));
            }
        }
        return interfaces;
    }

    private static Set<Class<? extends Service>> identifyImmediateDependenciesOf(Class<?> clazz) {
        OptionalServiceDependencies optionalAnnotation;
        if (clazz == null) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends Service>> dependencies = new HashSet<Class<? extends Service>>();
        ServiceDependencies annotation = clazz.getAnnotation(ServiceDependencies.class);
        if (annotation != null) {
            for (Class<? extends Service> dependency : annotation.value()) {
                if (!Service.class.isAssignableFrom(dependency)) {
                    throw new IllegalStateException("Service dependency declared by " + clazz.getName() + " is not a Service: " + dependency.getName());
                }
                Class<? extends Service> serviceDependency = dependency;
                dependencies.add(serviceDependency);
            }
        }
        if ((optionalAnnotation = clazz.getAnnotation(OptionalServiceDependencies.class)) != null) {
            for (String className : optionalAnnotation.value()) {
                try {
                    Class<?> dependencyClass = ClassLoading.delegationChain(ClassLoading.getDefaultClassLoader(), clazz.getClassLoader()).loadClass(className);
                    if (!Service.class.isAssignableFrom(dependencyClass)) {
                        throw new IllegalStateException("Service dependency declared by " + className + " is not a Service: " + dependencyClass.getName());
                    }
                    Class<?> serviceDependency = dependencyClass;
                    dependencies.add(serviceDependency);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        for (Class<?> interfaceClazz : clazz.getInterfaces()) {
            if (!Service.class.isAssignableFrom(interfaceClazz)) continue;
            dependencies.addAll(ServiceLocator.identifyImmediateDependenciesOf((Class)Service.class.getClass().cast(interfaceClazz)));
        }
        dependencies.addAll(ServiceLocator.identifyImmediateDependenciesOf(clazz.getSuperclass()));
        return dependencies;
    }

    private static Set<Class<? extends Service>> identifyTransitiveDependenciesOf(Class<?> clazz) {
        Set<Class<? extends Service>> dependencies = ServiceLocator.identifyImmediateDependenciesOf(clazz);
        for (Class<? extends Service> dependencyClass : dependencies) {
            if (dependencyClass != clazz) continue;
            throw new IllegalStateException("Circular dependency found. Service " + clazz.getName() + " cannot depend on itself.");
        }
        HashSet<Class<? extends Service>> transitive = new HashSet<Class<? extends Service>>(dependencies.size() * 3);
        transitive.addAll(dependencies);
        for (Class<? extends Service> klazz : dependencies) {
            Set<Class<? extends Service>> identified = ServiceLocator.identifyTransitiveDependenciesOf(klazz);
            for (Class<? extends Service> dep : identified) {
                if (dep != clazz) continue;
                throw new IllegalStateException("Circular dependency found. A dependency of service " + clazz.getName() + " depends on it.");
            }
            transitive.addAll(identified);
        }
        return transitive;
    }

    private static class ServiceMap {
        private final Map<Class<? extends Service>, Set<Service>> services = new HashMap<Class<? extends Service>, Set<Service>>();

        public ServiceMap(ServiceMap resolved) {
            for (Map.Entry<Class<? extends Service>, Set<Service>> e : resolved.services.entrySet()) {
                Set copy = Collections.newSetFromMap(new IdentityHashMap());
                copy.addAll((Collection)e.getValue());
                this.services.put(e.getKey(), copy);
            }
        }

        public ServiceMap() {
        }

        public <T extends Service> Set<T> get(Class<T> serviceType) {
            Set<Service> s = this.services.get(serviceType);
            if (s == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(s);
        }

        public ServiceMap addAll(Iterable<? extends Service> services) {
            for (Service service : services) {
                this.add(service);
            }
            return this;
        }

        public ServiceMap add(Service service) {
            HashSet<Class> serviceClazzes = new HashSet<Class>();
            serviceClazzes.add(service.getClass());
            for (Class i : ServiceLocator.getAllInterfaces(service.getClass())) {
                if (Service.class == i || !Service.class.isAssignableFrom(i)) continue;
                Class serviceClass = i;
                serviceClazzes.add(serviceClass);
            }
            for (Class serviceClazz : serviceClazzes) {
                Set<Service> registeredServices;
                if (serviceClazz.isAnnotationPresent(PluralService.class)) {
                    registeredServices = this.services.get(serviceClazz);
                    if (registeredServices == null) {
                        registeredServices = new LinkedHashSet<Service>();
                        this.services.put(serviceClazz, registeredServices);
                    }
                    registeredServices.add(service);
                    continue;
                }
                registeredServices = this.services.get(serviceClazz);
                if (registeredServices == null || registeredServices.isEmpty()) {
                    this.services.put(serviceClazz, Collections.singleton(service));
                    continue;
                }
                if (registeredServices.contains(service)) continue;
                StringBuilder message = new StringBuilder("Duplicate service implementation(s) found for ").append(service.getClass());
                for (Class serviceClass : serviceClazzes) {
                    Set<Service> s;
                    Service declaredService;
                    if (serviceClass.isAnnotationPresent(PluralService.class) || (declaredService = (s = this.services.get(serviceClass)) == null ? null : s.iterator().next()) == null) continue;
                    message.append("\n\t\t- ").append(serviceClass).append(" already has ").append(declaredService.getClass());
                }
                throw new IllegalStateException(message.toString());
            }
            return this;
        }

        public Set<Service> all() {
            Set all = Collections.newSetFromMap(new IdentityHashMap());
            for (Set<Service> s : this.services.values()) {
                all.addAll(s);
            }
            return Collections.unmodifiableSet(all);
        }

        public boolean contains(Class<? extends Service> request) {
            return this.services.containsKey(request);
        }
    }

    private static class DependencyException
    extends Exception {
        private static final long serialVersionUID = -5269926129639323941L;

        public DependencyException(String s) {
            super(s);
        }
    }

    public static class DependencySet
    implements Builder<ServiceLocator> {
        private final Iterable<ServiceFactory<?>> serviceFactories = ClassLoading.servicesOfType(ServiceFactory.class);
        private final ServiceMap provided = new ServiceMap();
        private final Set<Class<? extends Service>> requested = new HashSet<Class<? extends Service>>();
        private boolean includeMandatoryServices = true;

        public DependencySet with(Service service) {
            this.provided.add(service);
            return this;
        }

        public DependencySet with(Iterable<? extends Service> services) {
            for (Service service : services) {
                this.with(service);
            }
            return this;
        }

        public <T extends Service> DependencySet with(ServiceCreationConfiguration<T, ?> config) {
            Class serviceType = config.getServiceType();
            if (this.provided.contains(serviceType) && !serviceType.isAnnotationPresent(PluralService.class)) {
                return this;
            }
            Collection typedServiceFactories = StreamSupport.stream(this.serviceFactories.spliterator(), false).filter(f -> serviceType.isAssignableFrom(f.getServiceType())).map(f -> f).collect(Collectors.toList());
            OptionalInt highestRank = typedServiceFactories.stream().mapToInt(ServiceFactory::rank).max();
            if (highestRank.isPresent()) {
                typedServiceFactories.stream().filter(f -> highestRank.getAsInt() == f.rank()).forEach(f -> this.with((Service)f.create(config)));
                return this;
            }
            throw new IllegalStateException("No factories exist for " + serviceType);
        }

        public DependencySet with(Class<? extends Service> clazz) {
            this.requested.add(clazz);
            return this;
        }

        public DependencySet withoutMandatoryServices() {
            this.includeMandatoryServices = false;
            return this;
        }

        public boolean contains(Class<? extends Service> serviceClass) {
            return this.provided.contains(serviceClass);
        }

        public <T extends Service> T providerOf(Class<T> serviceClass) {
            if (serviceClass.isAnnotationPresent(PluralService.class)) {
                throw new IllegalArgumentException("Cannot retrieve single provider for plural service");
            }
            Collection<T> providers = this.providersOf(serviceClass);
            switch (providers.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (T)((Service)providers.iterator().next());
                }
            }
            throw new AssertionError();
        }

        public <T extends Service> Collection<T> providersOf(Class<T> serviceClass) {
            return this.provided.get(serviceClass);
        }

        @Override
        public ServiceLocator build() {
            try {
                ServiceMap resolvedServices = new ServiceMap();
                for (Service service : this.provided.all()) {
                    resolvedServices = this.lookupDependenciesOf(resolvedServices, service.getClass()).add(service);
                }
                for (Class clazz : this.requested) {
                    if (clazz.isAnnotationPresent(PluralService.class)) {
                        try {
                            resolvedServices = this.lookupService(resolvedServices, clazz);
                            continue;
                        }
                        catch (DependencyException e) {
                            if (resolvedServices.contains(clazz)) continue;
                            throw e;
                        }
                    }
                    if (resolvedServices.contains(clazz)) continue;
                    resolvedServices = this.lookupService(resolvedServices, clazz);
                }
                if (this.includeMandatoryServices) {
                    for (List list : StreamSupport.stream(this.serviceFactories.spliterator(), false).collect(Collectors.groupingBy(ServiceFactory::getServiceType)).values()) {
                        OptionalInt highestRank = list.stream().mapToInt(ServiceFactory::rank).max();
                        if (!highestRank.isPresent()) continue;
                        for (ServiceFactory manadatory : list.stream().filter(ServiceFactory::isMandatory).filter(f -> highestRank.getAsInt() == f.rank()).collect(Collectors.toList())) {
                            if (resolvedServices.contains(manadatory.getServiceType())) continue;
                            Object service = manadatory.create(null);
                            resolvedServices = this.lookupDependenciesOf(resolvedServices, service.getClass()).add((Service)service);
                        }
                    }
                }
                return new ServiceLocator(resolvedServices);
            }
            catch (DependencyException e) {
                throw new IllegalStateException(e);
            }
        }

        ServiceMap lookupDependenciesOf(ServiceMap resolved, Class<? extends Service> requested) throws DependencyException {
            for (Class dependency : ServiceLocator.identifyImmediateDependenciesOf(requested)) {
                try {
                    resolved = this.lookupService(resolved, dependency);
                }
                catch (DependencyException de) {
                    OptionalServiceDependencies optionalAnnotation = requested.getAnnotation(OptionalServiceDependencies.class);
                    if (optionalAnnotation != null && Arrays.asList(optionalAnnotation.value()).contains(dependency.getName())) {
                        LOGGER.debug("Skipping optional dependency of {} that cannot be looked up: {}", requested, (Object)dependency);
                        continue;
                    }
                    throw de;
                }
            }
            return resolved;
        }

        private <T extends Service> ServiceMap lookupService(ServiceMap resolved, Class<T> requested) throws DependencyException {
            if (resolved.contains(requested) && !requested.isAnnotationPresent(PluralService.class)) {
                return resolved;
            }
            if ((resolved = new ServiceMap(resolved).addAll(this.provided.get(requested))).contains(requested) && !requested.isAnnotationPresent(PluralService.class)) {
                return resolved;
            }
            Collection<ServiceFactory<T>> serviceFactories = this.discoverServices(resolved, requested);
            if (serviceFactories.size() > 1 && !requested.isAnnotationPresent(PluralService.class)) {
                throw new DependencyException("Multiple factories for non-plural service");
            }
            for (ServiceFactory factory : serviceFactories) {
                if (resolved.contains(factory.getServiceType())) continue;
                try {
                    resolved = this.lookupDependenciesOf(resolved, factory.getServiceType());
                }
                catch (DependencyException e) {
                    continue;
                }
                T service = factory.create(null);
                resolved = new ServiceMap(resolved).add((Service)service);
            }
            if (resolved.contains(requested)) {
                return resolved;
            }
            throw new DependencyException("Failed to find provider with satisfied dependency set for " + requested + " [candidates " + serviceFactories + "]");
        }

        private <T, V> Collection<ServiceFactory<? extends T>> discoverServices(ServiceMap resolved, Class<T> serviceClass) {
            Collection typedServiceFactories = StreamSupport.stream(this.serviceFactories.spliterator(), false).filter(f -> serviceClass.isAssignableFrom(f.getServiceType())).map(f -> f).filter(f -> !f.getClass().isAnnotationPresent(ServiceFactory.RequiresConfiguration.class)).filter(f -> !this.provided.contains(f.getServiceType())).filter(f -> !resolved.contains(f.getServiceType())).collect(Collectors.toList());
            OptionalInt highestRank = typedServiceFactories.stream().mapToInt(ServiceFactory::rank).max();
            if (highestRank.isPresent()) {
                return typedServiceFactories.stream().filter(f -> highestRank.getAsInt() == f.rank()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }
}

