/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.codemodel;

import org.apache.hadoop.shaded.com.sun.codemodel.JArrayClass;
import org.apache.hadoop.shaded.com.sun.codemodel.JClass;
import org.apache.hadoop.shaded.com.sun.codemodel.JCodeModel;
import org.apache.hadoop.shaded.com.sun.codemodel.JExpr;
import org.apache.hadoop.shaded.com.sun.codemodel.JExpression;
import org.apache.hadoop.shaded.com.sun.codemodel.JFormatter;
import org.apache.hadoop.shaded.com.sun.codemodel.JType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPrimitiveType
extends JType {
    private final String typeName;
    private final JCodeModel owner;
    private final JClass wrapperClass;
    private JClass arrayClass;

    JPrimitiveType(JCodeModel owner, String typeName, Class<?> wrapper) {
        this.owner = owner;
        this.typeName = typeName;
        this.wrapperClass = owner.ref(wrapper);
    }

    @Override
    public JCodeModel owner() {
        return this.owner;
    }

    @Override
    public String fullName() {
        return this.typeName;
    }

    @Override
    public String name() {
        return this.fullName();
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public JClass array() {
        if (this.arrayClass == null) {
            this.arrayClass = new JArrayClass(this.owner, this);
        }
        return this.arrayClass;
    }

    @Override
    public JClass boxify() {
        return this.wrapperClass;
    }

    @Override
    public JType unboxify() {
        return this;
    }

    public JClass getWrapperClass() {
        return this.boxify();
    }

    public JExpression wrap(JExpression exp) {
        return JExpr._new(this.boxify()).arg(exp);
    }

    public JExpression unwrap(JExpression exp) {
        return exp.invoke(this.typeName + "Value");
    }

    @Override
    public void generate(JFormatter f) {
        f.p(this.typeName);
    }
}

