/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.JDBCType;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerConnection;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerException;
import org.apache.hadoop.shaded.microsoft.sql.DateTimeOffset;

class SQLServerBulkCopy42Helper {
    SQLServerBulkCopy42Helper() {
    }

    static Object getTemporalObjectFromCSVWithFormatter(String valueStrUntrimmed, int srcJdbcType, int srcColOrdinal, DateTimeFormatter dateTimeFormatter, SQLServerConnection connection, SQLServerBulkCopy sqlServerBC) throws SQLServerException {
        DriverJDBCVersion.checkSupportsJDBC42();
        try {
            TemporalAccessor ta = dateTimeFormatter.parse(valueStrUntrimmed);
            int taOffsetSec = 0;
            int taNano = 0;
            int taDay = 0;
            int taMonth = 0;
            int taYear = 0;
            int taSec = 0;
            int taMin = 0;
            int taHour = 0;
            if (ta.isSupported(ChronoField.NANO_OF_SECOND)) {
                taNano = ta.get(ChronoField.NANO_OF_SECOND);
            }
            if (ta.isSupported(ChronoField.OFFSET_SECONDS)) {
                taOffsetSec = ta.get(ChronoField.OFFSET_SECONDS);
            }
            if (ta.isSupported(ChronoField.HOUR_OF_DAY)) {
                taHour = ta.get(ChronoField.HOUR_OF_DAY);
            }
            if (ta.isSupported(ChronoField.MINUTE_OF_HOUR)) {
                taMin = ta.get(ChronoField.MINUTE_OF_HOUR);
            }
            if (ta.isSupported(ChronoField.SECOND_OF_MINUTE)) {
                taSec = ta.get(ChronoField.SECOND_OF_MINUTE);
            }
            if (ta.isSupported(ChronoField.DAY_OF_MONTH)) {
                taDay = ta.get(ChronoField.DAY_OF_MONTH);
            }
            if (ta.isSupported(ChronoField.MONTH_OF_YEAR)) {
                taMonth = ta.get(ChronoField.MONTH_OF_YEAR);
            }
            if (ta.isSupported(ChronoField.YEAR)) {
                taYear = ta.get(ChronoField.YEAR);
            }
            GregorianCalendar cal = new GregorianCalendar(new SimpleTimeZone(taOffsetSec * 1000, ""));
            cal.clear();
            cal.set(11, taHour);
            cal.set(12, taMin);
            cal.set(13, taSec);
            cal.set(5, taDay);
            cal.set(2, taMonth - 1);
            cal.set(1, taYear);
            int fractionalSecondsLength = Integer.toString(taNano).length();
            for (int i = 0; i < 9 - fractionalSecondsLength; ++i) {
                taNano *= 10;
            }
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            ts.setNanos(taNano);
            switch (srcJdbcType) {
                case 93: {
                    return ts;
                }
                case 92: {
                    cal.set(connection.baseYear(), 0, 1);
                    ts = new Timestamp(cal.getTimeInMillis());
                    ts.setNanos(taNano);
                    return new Timestamp(ts.getTime());
                }
                case 91: {
                    return new Date(ts.getTime());
                }
                case -155: {
                    return DateTimeOffset.valueOf(ts, taOffsetSec / 60);
                }
            }
        }
        catch (ArithmeticException | DateTimeException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_ParsingError"));
            Object[] msgArgs = new Object[]{JDBCType.of(srcJdbcType)};
            throw new SQLServerException((Object)sqlServerBC, form.format(msgArgs), null, 0, false);
        }
        return valueStrUntrimmed;
    }
}

