/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogAsync;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.hadoop.shaded.org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatcher;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatchers;
import org.apache.hadoop.shaded.org.mockito.Mockito;
import org.apache.hadoop.shaded.org.mockito.stubbing.Answer;
import org.apache.hadoop.test.Whitebox;

public final class NameNodeAdapterMockitoUtil {
    private NameNodeAdapterMockitoUtil() {
    }

    public static BlockManager spyOnBlockManager(NameNode nn) {
        BlockManager bmSpy = Mockito.spy(nn.getNamesystem().getBlockManager());
        nn.getNamesystem().setBlockManagerForTesting(bmSpy);
        return bmSpy;
    }

    public static ReentrantReadWriteLock spyOnFsLock(FSNamesystem fsn) {
        ReentrantReadWriteLock spy = Mockito.spy(fsn.getFsLockForTests());
        fsn.setFsLockForTests(spy);
        return spy;
    }

    public static FSImage spyOnFsImage(NameNode nn1) {
        FSNamesystem fsn = nn1.getNamesystem();
        FSImage spy = Mockito.spy(fsn.getFSImage());
        Whitebox.setInternalState(fsn, "fsImage", spy);
        return spy;
    }

    public static JournalSet spyOnJournalSet(NameNode nn) {
        FSEditLog editLog = nn.getFSImage().getEditLog();
        JournalSet js = Mockito.spy(editLog.getJournalSet());
        editLog.setJournalSetForTesting(js);
        return js;
    }

    public static FSNamesystem spyOnNamesystem(NameNode nn) {
        FSNamesystem fsnSpy = Mockito.spy(nn.getNamesystem());
        FSNamesystem fsnOld = nn.namesystem;
        fsnOld.writeLock();
        fsnSpy.writeLock();
        nn.namesystem = fsnSpy;
        try {
            FieldUtils.writeDeclaredField((Object)nn.getRpcServer(), (String)"namesystem", (Object)fsnSpy, (boolean)true);
            FieldUtils.writeDeclaredField((Object)fsnSpy.getBlockManager(), (String)"namesystem", (Object)fsnSpy, (boolean)true);
            FieldUtils.writeDeclaredField((Object)fsnSpy.getLeaseManager(), (String)"fsnamesystem", (Object)fsnSpy, (boolean)true);
            FieldUtils.writeDeclaredField((Object)fsnSpy.getBlockManager().getDatanodeManager(), (String)"namesystem", (Object)fsnSpy, (boolean)true);
            FieldUtils.writeDeclaredField((Object)BlockManagerTestUtil.getHeartbeatManager(fsnSpy.getBlockManager()), (String)"namesystem", (Object)fsnSpy, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot set spy FSNamesystem", e);
        }
        finally {
            fsnSpy.writeUnlock();
            fsnOld.writeUnlock();
        }
        return fsnSpy;
    }

    public static FSEditLog spyOnEditLog(NameNode nn) {
        FSEditLog spyEditLog = Mockito.spy(nn.getNamesystem().getFSImage().getEditLog());
        DFSTestUtil.setEditLogForTesting(nn.getNamesystem(), spyEditLog);
        EditLogTailer tailer = nn.getNamesystem().getEditLogTailer();
        if (tailer != null) {
            tailer.setEditLog(spyEditLog);
        }
        return spyEditLog;
    }

    public static FSEditLog spyDelayMkDirTransaction(NameNode nn, long delay) {
        FSEditLog realEditLog = nn.getFSImage().getEditLog();
        FSEditLogAsync spyEditLog = (FSEditLogAsync)Mockito.spy(realEditLog);
        DFSTestUtil.setEditLogForTesting(nn.getNamesystem(), spyEditLog);
        Answer<Boolean> ans = invocation -> {
            Thread.sleep(delay);
            return (Boolean)invocation.callRealMethod();
        };
        ArgumentMatcher<FSEditLogOp> am = argument -> argument.opCode == FSEditLogOpCodes.OP_MKDIR;
        Mockito.doAnswer(ans).when(spyEditLog).doEditTransaction(ArgumentMatchers.argThat(am));
        return spyEditLog;
    }
}

