/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestErasureCodingPolicy {
    private static final ECSchema SCHEMA_1 = new ECSchema("one", 1, 2, null);
    private static final ECSchema SCHEMA_2 = new ECSchema("two", 1, 2, null);

    @Test
    public void testInvalid() {
        try {
            new ErasureCodingPolicy(null, SCHEMA_1, 123, -1);
            Assert.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new ErasureCodingPolicy("policy", null, 123, -1);
            Assert.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new ErasureCodingPolicy("policy", SCHEMA_1, -1, -1);
            Assert.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"cellSize", (Throwable)e);
        }
        try {
            new ErasureCodingPolicy(null, 1024, -1);
            Assert.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new ErasureCodingPolicy(SCHEMA_1, -1, -1);
            Assert.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"cellSize", (Throwable)e);
        }
        try {
            new ErasureCodingPolicy(null, 1024);
            Assert.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new ErasureCodingPolicy(SCHEMA_1, -1);
            Assert.fail((String)"Instantiated invalid ErasureCodingPolicy");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"cellSize", (Throwable)e);
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        ErasureCodingPolicy[] policies = new ErasureCodingPolicy[]{new ErasureCodingPolicy("one", SCHEMA_1, 1024, 1), new ErasureCodingPolicy("two", SCHEMA_1, 1024, 1), new ErasureCodingPolicy("one", SCHEMA_2, 1024, 1), new ErasureCodingPolicy("one", SCHEMA_1, 2048, 1), new ErasureCodingPolicy("one", SCHEMA_1, 1024, 3)};
        for (int i = 0; i < policies.length; ++i) {
            ErasureCodingPolicy ei = policies[i];
            ErasureCodingPolicy temp = new ErasureCodingPolicy(ei.getName(), ei.getSchema(), ei.getCellSize(), ei.getId());
            Assert.assertEquals((Object)ei, (Object)temp);
            Assert.assertEquals((long)ei.hashCode(), (long)temp.hashCode());
            for (int j = 0; j < policies.length; ++j) {
                ErasureCodingPolicy ej = policies[j];
                if (i == j) {
                    Assert.assertEquals((Object)ei, (Object)ej);
                    Assert.assertEquals((long)ei.hashCode(), (long)ej.hashCode());
                    continue;
                }
                Assert.assertNotEquals((Object)ei, (Object)ej);
                Assert.assertNotEquals((Object)ei, (Object)ej.hashCode());
            }
        }
    }
}

