/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.DelegateToFileSystem;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIOException;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ContainerLocalizer;
import org.apache.hadoop.yarn.server.nodemanager.executor.LocalizerStartContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsSecureContainerExecutor
extends DefaultContainerExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsSecureContainerExecutor.class);
    public static final String LOCALIZER_PID_FORMAT = "STAR_LOCALIZER_%s";
    private String nodeManagerGroup;
    static final short DIR_PERM = 488;

    public WindowsSecureContainerExecutor() throws IOException, URISyntaxException {
        super(FileContext.getFileContext((AbstractFileSystem)new ElevatedFileSystem(), (Configuration)new Configuration()));
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.nodeManagerGroup = conf.get("yarn.nodemanager.windows-secure-container-executor.group");
    }

    @Override
    protected String[] getRunCommand(String command, String groupId, String userName, Path pidFile, Configuration conf) {
        File f = new File(command);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("getRunCommand: %s exists:%b", command, f.exists()));
        }
        return new String[]{Shell.getWinUtilsPath(), "task", "createAsUser", groupId, userName, pidFile.toString(), "cmd /c " + command};
    }

    @Override
    protected DefaultContainerExecutor.LocalWrapperScriptBuilder getLocalWrapperScriptBuilder(String containerIdStr, Path containerWorkDir) {
        return new WindowsSecureWrapperScriptBuilder(containerWorkDir);
    }

    @Override
    protected void copyFile(Path src, Path dst, String owner) throws IOException {
        LOG.debug("copyFile: {} -> {} owner:{}", new Object[]{src, dst, owner});
        Native.Elevated.copy(src, dst, true);
        Native.Elevated.chown(dst, owner, this.nodeManagerGroup);
    }

    @Override
    protected void createDir(Path dirPath, FsPermission perms, boolean createParent, String owner) throws IOException {
        perms = new FsPermission(488);
        LOG.debug("createDir: {} perm:{} owner:{}", new Object[]{dirPath, perms, owner});
        super.createDir(dirPath, perms, createParent, owner);
        this.lfs.setOwner(dirPath, owner, this.nodeManagerGroup);
    }

    @Override
    protected void setScriptExecutable(Path script, String owner) throws IOException {
        LOG.debug("setScriptExecutable: {} owner:{}", (Object)script, (Object)owner);
        super.setScriptExecutable(script, owner);
        Native.Elevated.chown(script, owner, this.nodeManagerGroup);
    }

    @Override
    public Path localizeClasspathJar(Path jarPath, Path target, String owner) throws IOException {
        LOG.debug("localizeClasspathJar: {} {} o:{}", new Object[]{jarPath, target, owner});
        this.createDir(target, new FsPermission(488), true, owner);
        String fileName = jarPath.getName();
        Path dst = new Path(target, fileName);
        Native.Elevated.move(jarPath, dst, true);
        Native.Elevated.chown(dst, owner, this.nodeManagerGroup);
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLocalizer(LocalizerStartContext ctx) throws IOException, InterruptedException {
        Path nmPrivateContainerTokensPath = ctx.getNmPrivateContainerTokens();
        InetSocketAddress nmAddr = ctx.getNmAddr();
        String user = ctx.getUser();
        String appId = ctx.getAppId();
        String locId = ctx.getLocId();
        LocalDirsHandlerService dirsHandler = ctx.getDirsHandler();
        List<String> localDirs = dirsHandler.getLocalDirs();
        List<String> logDirs = dirsHandler.getLogDirs();
        Path classpathJarPrivateDir = dirsHandler.getLocalPathForWrite("nmPrivate");
        this.createUserLocalDirs(localDirs, user);
        this.createUserCacheDirs(localDirs, user);
        this.createAppDirs(localDirs, user, appId);
        this.createAppLogDirs(appId, logDirs, user);
        Path appStorageDir = this.getWorkingDir(localDirs, user, appId);
        String tokenFn = String.format("%s.tokens", locId);
        Path tokenDst = new Path(appStorageDir, tokenFn);
        this.copyFile(nmPrivateContainerTokensPath, tokenDst, user);
        File cwdApp = new File(appStorageDir.toString());
        LOG.debug("cwdApp: {}", (Object)cwdApp);
        ArrayList<String> command = new ArrayList<String>();
        File jvm = new File(new File(System.getProperty("java.home"), "bin"), "java.exe");
        command.add(jvm.toString());
        Path cwdPath = new Path(cwdApp.getPath());
        String classPath = System.getProperty("java.class.path");
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        String[] jarCp = FileUtil.createJarWithClassPath((String)classPath, (Path)classpathJarPrivateDir, (Path)cwdPath, env);
        String classPathJar = this.localizeClasspathJar(new Path(jarCp[0]), cwdPath, user).toString();
        command.add("-classpath");
        command.add(classPathJar + jarCp[1]);
        String javaLibPath = System.getProperty("java.library.path");
        if (javaLibPath != null) {
            command.add("-Djava.library.path=" + javaLibPath);
        }
        command.addAll(ContainerLocalizer.getJavaOpts(this.getConf()));
        ContainerLocalizer.buildMainArgs(command, user, appId, locId, nmAddr, tokenFn, localDirs, super.getConf());
        String cmdLine = org.apache.commons.lang3.StringUtils.join(command, (String)" ");
        String localizerPid = String.format(LOCALIZER_PID_FORMAT, locId);
        WintuilsProcessStubExecutor stubExecutor = new WintuilsProcessStubExecutor(cwdApp.getAbsolutePath(), localizerPid, user, "nul:", cmdLine);
        try {
            stubExecutor.execute();
            stubExecutor.validateResult();
            stubExecutor.close();
        }
        catch (Throwable throwable) {
            stubExecutor.close();
            try {
                this.killContainer(localizerPid, ContainerExecutor.Signal.KILL);
            }
            catch (Throwable e) {
                LOG.warn(String.format("An exception occurred during the cleanup of localizer job %s:%n%s", localizerPid, StringUtils.stringifyException((Throwable)e)));
            }
            throw throwable;
        }
        try {
            this.killContainer(localizerPid, ContainerExecutor.Signal.KILL);
        }
        catch (Throwable e) {
            LOG.warn(String.format("An exception occurred during the cleanup of localizer job %s:%n%s", localizerPid, StringUtils.stringifyException((Throwable)e)));
        }
    }

    @Override
    protected Shell.CommandExecutor buildCommandExecutor(String wrapperScriptPath, String containerIdStr, String userName, Path pidFile, Resource resource, File wordDir, Map<String, String> environment, String[] numaCommands) {
        return new WintuilsProcessStubExecutor(wordDir.toString(), containerIdStr, userName, pidFile.toString(), "cmd /c " + wrapperScriptPath);
    }

    @Override
    protected void killContainer(String pid, ContainerExecutor.Signal signal) throws IOException {
        Native.Elevated.killTask(pid);
    }

    private static class WintuilsProcessStubExecutor
    implements Shell.CommandExecutor {
        private Native.WinutilsProcessStub processStub;
        private StringBuilder output = new StringBuilder();
        private int exitCode;
        private State state;
        private final String cwd;
        private final String jobName;
        private final String userName;
        private final String pidFile;
        private final String cmdLine;

        public WintuilsProcessStubExecutor(String cwd, String jobName, String userName, String pidFile, String cmdLine) {
            this.cwd = cwd;
            this.jobName = jobName;
            this.userName = userName;
            this.pidFile = pidFile;
            this.cmdLine = cmdLine;
            this.state = State.INIT;
        }

        private void assertComplete() throws IOException {
            if (this.state != State.COMPLETE) {
                throw new IOException("Process is not complete");
            }
        }

        public String getOutput() throws IOException {
            this.assertComplete();
            return this.output.toString();
        }

        public int getExitCode() throws IOException {
            this.assertComplete();
            return this.exitCode;
        }

        public void validateResult() throws IOException {
            this.assertComplete();
            if (0 != this.exitCode) {
                LOG.warn(this.output.toString());
                throw new IOException("Processs exit code is:" + this.exitCode);
            }
        }

        private Thread startStreamReader(final InputStream stream) throws IOException {
            Thread streamReaderThread = new Thread(){

                @Override
                public void run() {
                    try (BufferedReader lines = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                        int nRead;
                        char[] buf = new char[512];
                        while ((nRead = lines.read(buf, 0, buf.length)) > 0) {
                            output.append(buf, 0, nRead);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("Error occurred reading the process stdout", t);
                    }
                }
            };
            streamReaderThread.start();
            return streamReaderThread;
        }

        public void execute() throws IOException {
            if (this.state != State.INIT) {
                throw new IOException("Process is already started");
            }
            this.processStub = Native.createTaskAsUser(this.cwd, this.jobName, this.userName, this.pidFile, this.cmdLine);
            this.state = State.RUNNING;
            Thread stdOutReader = this.startStreamReader(this.processStub.getInputStream());
            Thread stdErrReader = this.startStreamReader(this.processStub.getErrorStream());
            try {
                this.processStub.resume();
                this.processStub.waitFor();
                stdOutReader.join();
                stdErrReader.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
            this.exitCode = this.processStub.exitValue();
            this.state = State.COMPLETE;
        }

        public void close() {
            if (this.processStub != null) {
                this.processStub.dispose();
            }
        }

        private static enum State {
            INIT,
            RUNNING,
            COMPLETE;

        }
    }

    private static class ElevatedFileSystem
    extends DelegateToFileSystem {
        protected ElevatedFileSystem() throws IOException, URISyntaxException {
            super(FsConstants.LOCAL_FS_URI, (FileSystem)new ElevatedRawLocalFilesystem(), new Configuration(), FsConstants.LOCAL_FS_URI.getScheme(), false);
        }

        private static class ElevatedRawLocalFilesystem
        extends RawLocalFileSystem {
            private ElevatedRawLocalFilesystem() {
            }

            protected boolean mkOneDirWithMode(Path path, File p2f, FsPermission permission) throws IOException {
                boolean ret;
                block3: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("EFS:mkOneDirWithMode: %s %s", path, permission));
                    }
                    ret = false;
                    try {
                        Native.Elevated.mkdir(path);
                        this.setPermission(path, permission);
                        ret = true;
                    }
                    catch (Throwable e) {
                        if (!LOG.isDebugEnabled()) break block3;
                        LOG.debug(String.format("EFS:mkOneDirWithMode: %s", StringUtils.stringifyException((Throwable)e)));
                    }
                }
                return ret;
            }

            public void setPermission(Path p, FsPermission permission) throws IOException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("EFS:setPermission: %s %s", p, permission));
                }
                Native.Elevated.chmod(p, permission.toShort());
            }

            public void setOwner(Path p, String username, String groupname) throws IOException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("EFS:setOwner: %s %s %s", p, username, groupname));
                }
                Native.Elevated.chown(p, username, groupname);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected OutputStream createOutputStreamWithMode(Path f, boolean append, FsPermission permission) throws IOException {
                OutputStream outputStream;
                block4: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("EFS:createOutputStreamWithMode: %s %b %s", f, append, permission));
                    }
                    boolean success = false;
                    OutputStream os = Native.Elevated.create(f, append);
                    try {
                        this.setPermission(f, permission);
                        success = true;
                        outputStream = os;
                        if (success) break block4;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{os});
                        }
                        throw throwable;
                    }
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{os});
                }
                return outputStream;
            }

            public boolean delete(Path p, boolean recursive) throws IOException {
                File f;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("EFS:delete: %s %b", p, recursive));
                }
                if (!(f = this.pathToFile(p)).exists()) {
                    return false;
                }
                if (f.isFile()) {
                    return Native.Elevated.deleteFile(p);
                }
                if (f.isDirectory()) {
                    File[] files = FileUtil.listFiles((File)f);
                    int childCount = files.length;
                    if (recursive) {
                        for (File child : files) {
                            if (!this.delete(new Path(child.getPath()), recursive)) continue;
                            --childCount;
                        }
                    }
                    if (childCount == 0) {
                        return Native.Elevated.deleteDirectory(p);
                    }
                    throw new IOException("Directory " + f.toString() + " is not empty");
                }
                throw new IOException("Path " + f.toString() + " exists, but is neither a file nor a directory");
            }
        }
    }

    private class WindowsSecureWrapperScriptBuilder
    extends DefaultContainerExecutor.LocalWrapperScriptBuilder {
        public WindowsSecureWrapperScriptBuilder(Path containerWorkDir) {
            super(WindowsSecureContainerExecutor.this, containerWorkDir);
        }

        @Override
        protected void writeLocalWrapperScript(Path launchDst, Path pidFile, PrintStream pout) {
            pout.format("@call \"%s\"", launchDst);
        }
    }

    private static class Native {
        private static boolean nativeLoaded = false;

        private Native() {
        }

        private static native void initWsceNative();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static synchronized WinutilsProcessStub createTaskAsUser(String cwd, String jobName, String user, String pidFile, String cmdLine) throws IOException {
            if (!nativeLoaded) {
                throw new IOException("Native WSCE  libraries are required for createTaskAsUser");
            }
            Object object = Shell.WindowsProcessLaunchLock;
            synchronized (object) {
                return Native.createTaskAsUser0(cwd, jobName, user, pidFile, cmdLine);
            }
        }

        private static native WinutilsProcessStub createTaskAsUser0(String var0, String var1, String var2, String var3, String var4) throws NativeIOException;

        static {
            if (NativeCodeLoader.isNativeCodeLoaded()) {
                try {
                    Native.initWsceNative();
                    nativeLoaded = true;
                }
                catch (Throwable t) {
                    LOG.info("Unable to initialize WSCE Native libraries", t);
                }
            }
        }

        public static class WinutilsProcessStub
        extends Process {
            private final long hProcess;
            private final long hThread;
            private boolean disposed = false;
            private final InputStream stdErr;
            private final InputStream stdOut;
            private final OutputStream stdIn;

            public WinutilsProcessStub(long hProcess, long hThread, long hStdIn, long hStdOut, long hStdErr) {
                this.hProcess = hProcess;
                this.hThread = hThread;
                this.stdIn = new FileOutputStream(WinutilsProcessStub.getFileDescriptorFromHandle(hStdIn));
                this.stdOut = new FileInputStream(WinutilsProcessStub.getFileDescriptorFromHandle(hStdOut));
                this.stdErr = new FileInputStream(WinutilsProcessStub.getFileDescriptorFromHandle(hStdErr));
            }

            public static native FileDescriptor getFileDescriptorFromHandle(long var0);

            @Override
            public native void destroy();

            @Override
            public native int exitValue();

            @Override
            public InputStream getErrorStream() {
                return this.stdErr;
            }

            @Override
            public InputStream getInputStream() {
                return this.stdOut;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.stdIn;
            }

            @Override
            public native int waitFor() throws InterruptedException;

            public synchronized native void dispose();

            public native void resume() throws NativeIOException;
        }

        public static class Elevated {
            private static final int MOVE_FILE = 1;
            private static final int COPY_FILE = 2;

            public static void mkdir(Path dirName) throws IOException {
                if (!nativeLoaded) {
                    throw new IOException("Native WSCE libraries are required for mkdir");
                }
                Elevated.elevatedMkDirImpl(dirName.toString());
            }

            private static native void elevatedMkDirImpl(String var0) throws IOException;

            public static void chown(Path fileName, String user, String group) throws IOException {
                if (!nativeLoaded) {
                    throw new IOException("Native WSCE libraries are required for chown");
                }
                Elevated.elevatedChownImpl(fileName.toString(), user, group);
            }

            private static native void elevatedChownImpl(String var0, String var1, String var2) throws IOException;

            public static void move(Path src, Path dst, boolean replaceExisting) throws IOException {
                if (!nativeLoaded) {
                    throw new IOException("Native WSCE libraries are required for move");
                }
                Elevated.elevatedCopyImpl(1, src.toString(), dst.toString(), replaceExisting);
            }

            public static void copy(Path src, Path dst, boolean replaceExisting) throws IOException {
                if (!nativeLoaded) {
                    throw new IOException("Native WSCE libraries are required for copy");
                }
                Elevated.elevatedCopyImpl(2, src.toString(), dst.toString(), replaceExisting);
            }

            private static native void elevatedCopyImpl(int var0, String var1, String var2, boolean var3) throws IOException;

            public static void chmod(Path fileName, int mode) throws IOException {
                if (!nativeLoaded) {
                    throw new IOException("Native WSCE libraries are required for chmod");
                }
                Elevated.elevatedChmodImpl(fileName.toString(), mode);
            }

            private static native void elevatedChmodImpl(String var0, int var1) throws IOException;

            public static void killTask(String containerName) throws IOException {
                if (!nativeLoaded) {
                    throw new IOException("Native WSCE libraries are required for killTask");
                }
                Elevated.elevatedKillTaskImpl(containerName);
            }

            private static native void elevatedKillTaskImpl(String var0) throws IOException;

            public static OutputStream create(Path f, boolean append) throws IOException {
                if (!nativeLoaded) {
                    throw new IOException("Native WSCE libraries are required for create");
                }
                long desiredAccess = 0x40000000L;
                long shareMode = 0L;
                long creationDisposition = append ? 4L : 2L;
                long flags = 128L;
                String fileName = f.toString();
                fileName = fileName.replace('/', '\\');
                long hFile = Elevated.elevatedCreateImpl(fileName, desiredAccess, shareMode, creationDisposition, flags);
                return new FileOutputStream(WinutilsProcessStub.getFileDescriptorFromHandle(hFile));
            }

            private static native long elevatedCreateImpl(String var0, long var1, long var3, long var5, long var7) throws IOException;

            public static boolean deleteFile(Path path) throws IOException {
                if (!nativeLoaded) {
                    throw new IOException("Native WSCE libraries are required for deleteFile");
                }
                return Elevated.elevatedDeletePathImpl(path.toString(), false);
            }

            public static boolean deleteDirectory(Path path) throws IOException {
                if (!nativeLoaded) {
                    throw new IOException("Native WSCE libraries are required for deleteDirectory");
                }
                return Elevated.elevatedDeletePathImpl(path.toString(), true);
            }

            public static native boolean elevatedDeletePathImpl(String var0, boolean var1) throws IOException;
        }
    }
}

