/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.junit.Assert;

public class HttpServerFunctionalTest
extends Assert {
    public static final String TEST_BUILD_WEBAPPS = "test.build.webapps";
    private static final String BUILD_WEBAPPS_DIR = "build/test/webapps";
    private static final String TEST = "test";
    protected static URL baseUrl;

    public static HttpServer2 createTestServer() throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return HttpServerFunctionalTest.createServer(TEST);
    }

    public static HttpServer2 createTestServer(Configuration conf) throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return HttpServerFunctionalTest.createServer(TEST, conf);
    }

    public static HttpServer2 createTestServer(Configuration conf, AccessControlList adminsAcl) throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return HttpServerFunctionalTest.createServer(TEST, conf, adminsAcl);
    }

    public static HttpServer2 createTestServer(Configuration conf, String[] pathSpecs) throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return HttpServerFunctionalTest.createServer(TEST, conf, pathSpecs);
    }

    protected static void prepareTestWebapp() {
        String webapps = System.getProperty(TEST_BUILD_WEBAPPS, BUILD_WEBAPPS_DIR);
        File testWebappDir = new File(webapps + File.separatorChar + TEST);
        try {
            if (!testWebappDir.exists() && !testWebappDir.mkdirs()) {
                HttpServerFunctionalTest.fail((String)("Test webapp dir " + testWebappDir.getCanonicalPath() + " can not be created"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static HttpServer2 createServer(String host, int port) throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return new HttpServer2.Builder().setName(TEST).addEndpoint(URI.create("http://" + host + ":" + port)).setFindPort(true).build();
    }

    public static HttpServer2 createServer(String webapp) throws IOException {
        return HttpServerFunctionalTest.localServerBuilder(webapp).setFindPort(true).build();
    }

    public static HttpServer2 createServer(String webapp, Configuration conf) throws IOException {
        return HttpServerFunctionalTest.localServerBuilder(webapp).setFindPort(true).setConf(conf).build();
    }

    public static HttpServer2 createServer(boolean xFrameEnabled, String xFrameOptionValue, Configuration conf) throws IOException {
        return HttpServerFunctionalTest.localServerBuilder(TEST).setFindPort(true).configureXFrame(xFrameEnabled).setXFrameOption(xFrameOptionValue).setConf(conf).build();
    }

    public static HttpServer2 createServer(String webapp, Configuration conf, AccessControlList adminsAcl) throws IOException {
        return HttpServerFunctionalTest.localServerBuilder(webapp).setFindPort(true).setConf(conf).setACL(adminsAcl).build();
    }

    private static HttpServer2.Builder localServerBuilder(String webapp) {
        return new HttpServer2.Builder().setName(webapp).addEndpoint(URI.create("http://localhost:0"));
    }

    public static HttpServer2 createServer(String webapp, Configuration conf, String[] pathSpecs) throws IOException {
        return HttpServerFunctionalTest.localServerBuilder(webapp).setFindPort(true).setConf(conf).setPathSpec(pathSpecs).build();
    }

    public static HttpServer2 createAndStartTestServer() throws IOException {
        HttpServer2 server = HttpServerFunctionalTest.createTestServer();
        server.start();
        return server;
    }

    public static void stop(HttpServer2 server) throws Exception {
        if (server != null) {
            server.stop();
        }
    }

    public static URL getServerURL(HttpServer2 server) throws MalformedURLException {
        HttpServerFunctionalTest.assertNotNull((String)"No server", (Object)server);
        return new URL("http://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
    }

    protected static String readOutput(URL url) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStream in = url.openConnection().getInputStream();
        byte[] buffer = new byte[65536];
        int len = in.read(buffer);
        while (len > 0) {
            out.append(new String(buffer, 0, len));
            len = in.read(buffer);
        }
        return out.toString();
    }

    protected void testLongHeader(HttpURLConnection conn) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 64512; ++i) {
            sb.append("a");
        }
        conn.setRequestProperty("longheader", sb.toString());
        HttpServerFunctionalTest.assertEquals((long)200L, (long)conn.getResponseCode());
    }

    public static class LongHeaderServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Assert.assertEquals((long)64512L, (long)request.getHeader("longheader").length());
            response.setStatus(200);
        }
    }
}

