/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.SourceWrappedStatistics;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDynamicIOStatistics
extends AbstractHadoopTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestDynamicIOStatistics.class);
    private static final String ALONG = "along";
    private static final String AINT = "aint";
    private static final String COUNT = "count";
    private static final String EVAL = "eval";
    private IOStatistics statistics = IOStatisticsBinding.emptyStatistics();
    private IOStatisticsSource statsSource;
    private final AtomicLong aLong = new AtomicLong();
    private final AtomicInteger aInt = new AtomicInteger();
    private final MutableCounterLong counter = new MutableCounterLong((MetricsInfo)new Info("counter"), 0L);
    private long evalLong;
    private static final String[] KEYS = new String[]{"along", "aint", "count", "eval"};

    @Before
    public void setUp() throws Exception {
        this.statistics = IOStatisticsBinding.dynamicIOStatistics().withAtomicLongCounter(ALONG, this.aLong).withAtomicIntegerCounter(AINT, this.aInt).withMutableCounter(COUNT, this.counter).withLongFunctionCounter(EVAL, x -> this.evalLong).build();
        this.statsSource = new SourceWrappedStatistics(this.statistics);
    }

    @Test
    public void testEval() throws Throwable {
        IOStatisticAssertions.verifyStatisticCounterValue(this.statistics, EVAL, 0L);
        this.evalLong = 10L;
        IOStatisticAssertions.verifyStatisticCounterValue(this.statistics, EVAL, 10L);
    }

    @Test
    public void testAlong() throws Throwable {
        IOStatisticAssertions.verifyStatisticCounterValue(this.statistics, ALONG, 0L);
        this.aLong.addAndGet(1L);
        IOStatisticAssertions.verifyStatisticCounterValue(this.statistics, ALONG, 1L);
    }

    @Test
    public void testAint() throws Throwable {
        IOStatisticAssertions.verifyStatisticCounterValue(this.statistics, AINT, 0L);
        this.aInt.addAndGet(1);
        IOStatisticAssertions.verifyStatisticCounterValue(this.statistics, AINT, 1L);
    }

    @Test
    public void testCounter() throws Throwable {
        IOStatisticAssertions.verifyStatisticCounterValue(this.statistics, COUNT, 0L);
        this.counter.incr();
        IOStatisticAssertions.verifyStatisticCounterValue(this.statistics, COUNT, 1L);
    }

    @Test
    public void testKeys() throws Throwable {
        ((IterableAssert)Assertions.assertThat(this.statistics.counters().keySet()).describedAs("statistic keys of %s", new Object[]{this.statistics})).containsExactlyInAnyOrder((Object[])KEYS);
    }

    @Test
    public void testIteratorHasAllKeys() throws Throwable {
        Assertions.assertThat(this.statistics.counters().keySet()).containsExactlyInAnyOrder((Object[])KEYS);
    }

    @Test
    public void testIteratorIsSnapshot() throws Throwable {
        this.incrementAllCounters();
        Iterator it = this.statistics.counters().entrySet().iterator();
        this.incrementAllCounters();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            ((AbstractLongAssert)Assertions.assertThat((Long)((Long)next.getValue())).describedAs("Value of entry %s", new Object[]{next})).isEqualTo(1L);
        }
    }

    @Test
    public void testUnknownStatistic() throws Throwable {
        IOStatisticAssertions.assertStatisticCounterIsUntracked(this.statistics, "anything");
    }

    @Test
    public void testStatisticsTrackedAssertion() throws Throwable {
        Assertions.assertThatThrownBy(() -> IOStatisticAssertions.assertStatisticCounterIsTracked(this.statistics, "anything")).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testStatisticsValueAssertion() throws Throwable {
        Assertions.assertThatThrownBy(() -> IOStatisticAssertions.verifyStatisticCounterValue(this.statistics, "anything", 0L)).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testSerDeser() throws Throwable {
        this.incrementAllCounters();
        IOStatisticsSnapshot stat = IOStatisticsSupport.snapshotIOStatistics((IOStatistics)this.statistics);
        this.incrementAllCounters();
        IOStatistics deser = IOStatisticAssertions.statisticsJavaRoundTrip((IOStatistics)stat);
        Assertions.assertThat(deser.counters().keySet()).containsExactlyInAnyOrder((Object[])KEYS);
        for (Map.Entry e : deser.counters().entrySet()) {
            ((AbstractLongAssert)Assertions.assertThat((Long)((Long)e.getValue())).describedAs("Value of entry %s", new Object[]{e})).isEqualTo(1L);
        }
    }

    @Test
    public void testStringification() throws Throwable {
        ((AbstractStringAssert)Assertions.assertThat((String)IOStatisticsLogging.ioStatisticsToString((IOStatistics)this.statistics)).isNotBlank()).contains((CharSequence[])KEYS);
    }

    @Test
    public void testDemandStringification() throws Throwable {
        String counterPattern = "(%s=%s)";
        Object demand = IOStatisticsLogging.demandStringifyIOStatistics((IOStatistics)this.statistics);
        Object demandSource = IOStatisticsLogging.demandStringifyIOStatisticsSource((IOStatisticsSource)this.statsSource);
        String formatted1 = String.format(counterPattern, ALONG, this.aLong.get());
        Assertions.assertThat((String)demand.toString()).contains(new CharSequence[]{formatted1});
        Assertions.assertThat((String)demandSource.toString()).contains(new CharSequence[]{formatted1});
        this.incrementAllCounters();
        this.incrementAllCounters();
        String formatted2 = String.format(counterPattern, ALONG, this.aLong.get());
        ((AbstractStringAssert)Assertions.assertThat((String)demand.toString()).doesNotContain(new CharSequence[]{formatted1})).contains(new CharSequence[]{formatted2});
        ((AbstractStringAssert)Assertions.assertThat((String)demandSource.toString()).doesNotContain(new CharSequence[]{formatted1})).contains(new CharSequence[]{formatted2});
    }

    @Test
    public void testNullSourceStringification() throws Throwable {
        Assertions.assertThat((String)IOStatisticsLogging.demandStringifyIOStatisticsSource((IOStatisticsSource)null).toString()).isEqualTo((Object)"()");
    }

    @Test
    public void testNullStatStringification() throws Throwable {
        Assertions.assertThat((String)IOStatisticsLogging.demandStringifyIOStatistics((IOStatistics)null).toString()).isEqualTo((Object)"()");
    }

    @Test
    public void testStringLogging() throws Throwable {
        LOG.info("Output {}", IOStatisticsLogging.demandStringifyIOStatistics((IOStatistics)this.statistics));
    }

    private void incrementAllCounters() {
        this.aLong.incrementAndGet();
        this.aInt.incrementAndGet();
        ++this.evalLong;
        this.counter.incr();
    }

    private static final class Info
    implements MetricsInfo {
        private final String name;

        private Info(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.name;
        }
    }
}

