/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.hadoop.fs.impl.prefetch.BoundedResourcePool;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBoundedResourcePool
extends AbstractHadoopTestBase {
    @Test
    public void testArgChecks() throws Exception {
        BufferPool pool = new BufferPool(5);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'size' must be a positive integer", () -> new BufferPool(-1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'size' must be a positive integer", () -> new BufferPool(0));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'item' must not be null", () -> pool.release(null));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "This item is not a part of this pool", () -> pool.release(ByteBuffer.allocate(4)));
    }

    @Test
    public void testAcquireReleaseSingle() {
        int numBuffers = 5;
        BufferPool pool = new BufferPool(5);
        Assert.assertEquals((long)0L, (long)pool.numCreated());
        Assert.assertEquals((long)5L, (long)pool.numAvailable());
        ByteBuffer buffer1 = (ByteBuffer)pool.acquire();
        Assert.assertNotNull((Object)buffer1);
        Assert.assertEquals((long)1L, (long)pool.numCreated());
        Assert.assertEquals((long)4L, (long)pool.numAvailable());
        pool.release(buffer1);
        Assert.assertEquals((long)1L, (long)pool.numCreated());
        ByteBuffer buffer2 = (ByteBuffer)pool.acquire();
        Assert.assertNotNull((Object)buffer2);
        Assert.assertSame((Object)buffer1, (Object)buffer2);
        Assert.assertEquals((long)1L, (long)pool.numCreated());
    }

    @Test
    public void testAcquireReleaseMultiple() {
        int numBuffers = 5;
        BufferPool pool = new BufferPool(5);
        Set<ByteBuffer> buffers = Collections.newSetFromMap(new IdentityHashMap());
        Assert.assertEquals((long)0L, (long)pool.numCreated());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)(5 - i), (long)pool.numAvailable());
            ByteBuffer buffer = (ByteBuffer)pool.acquire();
            Assert.assertNotNull((Object)buffer);
            Assert.assertFalse((boolean)buffers.contains(buffer));
            buffers.add(buffer);
            Assert.assertEquals((long)(i + 1), (long)pool.numCreated());
        }
        Assert.assertEquals((long)5L, (long)pool.numCreated());
        Assert.assertEquals((long)0L, (long)pool.numAvailable());
        int releaseCount = 0;
        for (ByteBuffer buffer : buffers) {
            Assert.assertEquals((long)releaseCount, (long)pool.numAvailable());
            pool.release(buffer);
            Assert.assertEquals((long)(++releaseCount), (long)pool.numAvailable());
            pool.release(buffer);
            Assert.assertEquals((long)releaseCount, (long)pool.numAvailable());
            pool.release(buffer);
            Assert.assertEquals((long)releaseCount, (long)pool.numAvailable());
        }
        for (int i = 0; i < 5; ++i) {
            ByteBuffer buffer;
            buffer = (ByteBuffer)pool.acquire();
            Assert.assertTrue((boolean)buffers.contains(buffer));
        }
        Assert.assertEquals((long)5L, (long)pool.numCreated());
        Assert.assertEquals((long)0L, (long)pool.numAvailable());
    }

    static class BufferPool
    extends BoundedResourcePool<ByteBuffer> {
        BufferPool(int size) {
            super(size);
        }

        protected ByteBuffer createNew() {
            return ByteBuffer.allocate(10);
        }
    }
}

