/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestDefaultUri {
    private Configuration conf = new Configuration();

    @Test
    public void tetGetDefaultUri() {
        this.conf.set("fs.defaultFS", "hdfs://nn_host");
        URI uri = FileSystem.getDefaultUri((Configuration)this.conf);
        Assertions.assertThat((String)uri.getScheme()).isEqualTo((Object)"hdfs");
        Assertions.assertThat((String)uri.getAuthority()).isEqualTo((Object)"nn_host");
    }

    @Test
    public void tetGetDefaultUriWithPort() {
        this.conf.set("fs.defaultFS", "hdfs://nn_host:5432");
        URI uri = FileSystem.getDefaultUri((Configuration)this.conf);
        Assertions.assertThat((String)uri.getScheme()).isEqualTo((Object)"hdfs");
        Assertions.assertThat((String)uri.getAuthority()).isEqualTo((Object)"nn_host:5432");
    }

    @Test
    public void tetGetDefaultUriTrailingSlash() {
        this.conf.set("fs.defaultFS", "hdfs://nn_host/");
        URI uri = FileSystem.getDefaultUri((Configuration)this.conf);
        Assertions.assertThat((String)uri.getScheme()).isEqualTo((Object)"hdfs");
        Assertions.assertThat((String)uri.getAuthority()).isEqualTo((Object)"nn_host");
    }

    @Test
    public void tetGetDefaultUriNoScheme() {
        this.conf.set("fs.defaultFS", "nn_host");
        URI uri = FileSystem.getDefaultUri((Configuration)this.conf);
        Assertions.assertThat((String)uri.getScheme()).isEqualTo((Object)"hdfs");
        Assertions.assertThat((String)uri.getAuthority()).isEqualTo((Object)"nn_host");
    }

    @Test
    public void tetGetDefaultUriNoSchemeTrailingSlash() throws Exception {
        this.conf.set("fs.defaultFS", "nn_host/");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "No scheme in default FS", () -> FileSystem.getDefaultUri((Configuration)this.conf));
    }

    @Test
    public void tetFsGet() throws IOException {
        this.conf.set("fs.defaultFS", "file:///");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Assertions.assertThat((Object)fs).isInstanceOf(LocalFileSystem.class);
    }

    @Test
    public void tetFsGetNoScheme() throws Exception {
        this.conf.set("fs.defaultFS", "nn_host");
        LambdaTestUtils.intercept(UnsupportedFileSystemException.class, "hdfs", () -> FileSystem.get((Configuration)this.conf));
    }

    @Test
    public void tetFsGetNoSchemeTrailingSlash() throws Exception {
        this.conf.set("fs.defaultFS", "nn_host/");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "No scheme in default FS", () -> FileSystem.get((Configuration)this.conf));
    }
}

