/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.io.Serializable;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.type.context.NumberContext;

abstract class AbstractStore<N extends Number>
implements MatrixStore<N>,
Serializable {
    private final int myColDim;
    private transient Class<?> myComponentType = null;
    private final int myRowDim;

    private AbstractStore() {
        this(0, 0);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected AbstractStore(int rowsCount, int columnsCount) {
        this.myRowDim = rowsCount;
        this.myColDim = columnsCount;
    }

    @Override
    public final PhysicalStore<N> copy() {
        PhysicalStore retVal = (PhysicalStore)this.physical().makeZero(this.countRows(), this.countColumns());
        this.addNonzerosTo(retVal);
        return retVal;
    }

    @Override
    public long count() {
        return this.myRowDim * this.myColDim;
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    @Override
    public final boolean equals(MatrixStore<N> other, NumberContext context) {
        return AccessUtils.equals(this, other, context);
    }

    public final boolean equals(Object someObj) {
        if (someObj instanceof MatrixStore) {
            return this.equals((MatrixStore)someObj, NumberContext.getGeneral(6));
        }
        return super.equals(someObj);
    }

    @Override
    public final MatrixStore<N> get() {
        return this;
    }

    public final int hashCode() {
        return MatrixUtils.hashCode(this);
    }

    @Override
    public boolean isAbsolute(long row, long col) {
        return this.toScalar(row, col).isAbsolute();
    }

    @Override
    public boolean isSmall(long row, long col, double comparedTo) {
        return this.toScalar(row, col).isSmall(comparedTo);
    }

    @Override
    public int limitOfColumn(int col) {
        return this.myRowDim;
    }

    @Override
    public int limitOfRow(int row) {
        return this.myColDim;
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)this.physical().makeZero(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)this.physical().makeZero(1L, 1L);
        if (this.isPrimitive()) {
            tmpStep1.fillByMultiplying(leftAndRight, this);
        } else {
            PhysicalStore tmpLeft = (PhysicalStore)this.physical().rows(leftAndRight);
            tmpLeft.modifyAll(this.physical().function().conjugate());
            tmpStep1.fillByMultiplying(tmpLeft.conjugate(), this);
        }
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return tmpStep2.get(0L);
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        receiver.fillAll(this.physical().scalar().zero().getNumber());
        this.addNonzerosTo(receiver);
    }

    public final String toString() {
        return MatrixUtils.toString(this);
    }

    protected abstract void addNonzerosTo(ElementsConsumer<N> var1);

    protected final int getColDim() {
        return this.myColDim;
    }

    protected final int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    protected final int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    protected final int getRowDim() {
        return this.myRowDim;
    }

    protected final boolean isPrimitive() {
        return this.getComponentType().equals(Double.class);
    }

    final Class<?> getComponentType() {
        if (this.myComponentType == null) {
            this.myComponentType = this.get(0L, 0L).getClass();
        }
        return this.myComponentType;
    }
}

