/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.util.Arrays;
import java.util.Optional;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.array.blas.COPY;
import org.ojalgo.array.blas.DOT;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.EigenvalueDecomposition;
import org.ojalgo.matrix.decomposition.EvD2D;
import org.ojalgo.matrix.decomposition.HermitianEvD;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.decomposition.function.ExchangeColumns;
import org.ojalgo.matrix.decomposition.function.RotateRight;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.matrix.task.TaskException;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;

abstract class RawEigenvalue
extends RawDecomposition
implements Eigenvalue<Double> {
    private double[] d = null;
    private double[] e = null;
    private transient MatrixStore<Double> myInverse = null;
    private double[][] myTransposedV = null;

    protected RawEigenvalue() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        this.getRawInPlaceStore().fillMatching(matrix);
        this.doDecompose(tmpData, true);
        return this.getDeterminant();
    }

    @Override
    public boolean computeValuesOnly(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        matrix.supplyTo(this.getRawInPlaceStore());
        return this.doDecompose(tmpData, true);
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        matrix.supplyTo(this.getRawInPlaceStore());
        return this.doDecompose(tmpData, false);
    }

    public RawStore getD() {
        int n = this.getRowDim();
        RawStore X = new RawStore(n, n);
        double[][] D = X.data;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                D[i][j] = PrimitiveMath.ZERO;
            }
            D[i][i] = this.d[i];
            if (this.e[i] > 0.0) {
                D[i][i + 1] = this.e[i];
                continue;
            }
            if (!(this.e[i] < 0.0)) continue;
            D[i][i - 1] = this.e[i];
        }
        return X;
    }

    @Override
    public Double getDeterminant() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().product();
        this.getEigenvalues().visitAll(tmpVisitor);
        return ((ComplexNumber)tmpVisitor.getNumber()).doubleValue();
    }

    @Override
    public Array1D<ComplexNumber> getEigenvalues() {
        double[] tmpRe = this.getRealParts();
        double[] tmpIm = this.getImaginaryParts();
        Structure1D retVal = Array1D.COMPLEX.makeZero(tmpRe.length);
        for (int i = 0; i < ((Array1D)retVal).size(); ++i) {
            ((Array1D)retVal).set(i, (Object)ComplexNumber.of(tmpRe[i], tmpIm[i]));
        }
        return retVal;
    }

    @Override
    public void getEigenvalues(double[] realParts, Optional<double[]> imaginaryParts) {
        int length = realParts.length;
        System.arraycopy(this.getRealParts(), 0, realParts, 0, length);
        if (imaginaryParts.isPresent()) {
            System.arraycopy(this.getImaginaryParts(), 0, imaginaryParts.get(), 0, length);
        }
    }

    public MatrixStore<Double> getInverse() {
        int n = this.getRowDim();
        return this.getInverse(this.allocate(n, n));
    }

    public MatrixStore<Double> getInverse(PhysicalStore<Double> preallocated) {
        if (this.myInverse == null) {
            int dim = this.d.length;
            RawStore tmpMtrx = new RawStore(dim, dim);
            double max = PrimitiveMath.ONE;
            for (int i = 0; i < dim; ++i) {
                double val = this.d[i];
                if (PrimitiveScalar.isSmall(max = PrimitiveFunction.MAX.invoke(max, PrimitiveFunction.ABS.invoke(val)), val)) {
                    for (int j = 0; j < dim; ++j) {
                        tmpMtrx.set((long)i, (long)j, PrimitiveMath.ZERO);
                    }
                    continue;
                }
                double[] colVi = this.myTransposedV[i];
                for (int j = 0; j < dim; ++j) {
                    tmpMtrx.set((long)i, (long)j, colVi[j] / val);
                }
            }
            this.myInverse = this.getV().multiply((Double)((Object)tmpMtrx));
        }
        return this.myInverse;
    }

    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        return null;
    }

    @Override
    public ComplexNumber getTrace() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().sum();
        this.getEigenvalues().visitAll(tmpVisitor);
        return (ComplexNumber)tmpVisitor.getNumber();
    }

    @Override
    public MatrixStore<Double> getV() {
        int n = this.getRowDim();
        return ((MatrixStore.LogicalBuilder)new RawStore(this.myTransposedV, n, n).logical().transpose()).get();
    }

    public MatrixStore<Double> invert(Access2D<?> original, PhysicalStore<Double> preallocated) throws TaskException {
        double[][] tmpData = this.reset(original, false);
        this.getRawInPlaceStore().fillMatching(original);
        this.doDecompose(tmpData, false);
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw TaskException.newNotInvertible();
    }

    public boolean isSolvable() {
        return this.isComputed() && this.isHermitian();
    }

    @Override
    public MatrixStore<Double> reconstruct() {
        return Eigenvalue.reconstruct(this);
    }

    @Override
    public void reset() {
        this.myInverse = null;
    }

    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws TaskException {
        double[][] tmpData = this.reset(body, false);
        this.getRawInPlaceStore().fillMatching(body);
        this.doDecompose(tmpData, false);
        if (this.isSolvable()) {
            preallocated.fillMatching(rhs);
            return this.getInverse().multiply((Double)((Object)preallocated));
        }
        throw TaskException.newNotSolvable();
    }

    public MatrixStore<Double> solve(MatrixStore<Double> rhs, DecompositionStore<Double> preallocated) {
        return null;
    }

    protected abstract boolean doDecompose(double[][] var1, boolean var2);

    final void doGeneral(double[][] data, boolean valuesOnly) {
        int n = data.length;
        if (this.d == null || n != this.d.length) {
            this.myTransposedV = valuesOnly ? (double[][])null : new double[n][n];
            this.d = new double[n];
            this.e = new double[n];
        }
        EvD2D.orthes(data, this.myTransposedV, this.d);
        EvD2D.hqr2(data, this.d, this.e, this.myTransposedV);
    }

    final void doSymmetric(final double[][] data, boolean valuesOnly) {
        double[] row;
        int i;
        double val;
        int j;
        double h;
        int m;
        final int size = data.length;
        int last = size - 1;
        if (this.d == null || size != this.d.length) {
            this.d = new double[size];
            this.e = new double[size];
        }
        this.myTransposedV = valuesOnly ? (double[][])null : data;
        COPY.invoke(data[last], 0, this.d, 0, 0, size);
        for (m = last; m > 0; --m) {
            int k;
            double scale = PrimitiveMath.ZERO;
            for (k = 0; k < m; ++k) {
                scale = PrimitiveFunction.MAX.invoke(scale, PrimitiveFunction.ABS.invoke(this.d[k]));
            }
            h = PrimitiveMath.ZERO;
            if (Double.compare(scale, PrimitiveMath.ZERO) == 0) {
                this.e[m] = this.d[m - 1];
                for (j = 0; j < m; ++j) {
                    this.d[j] = data[j][m - 1];
                }
            } else {
                int j2;
                k = 0;
                while (k < m) {
                    int n = k++;
                    double d = this.d[n] / scale;
                    this.d[n] = d;
                    val = d;
                    h += val * val;
                }
                double f = this.d[m - 1];
                double g = PrimitiveFunction.SQRT.invoke(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e[m] = scale * g;
                h -= f * g;
                this.d[m - 1] = f - g;
                Arrays.fill(this.e, 0, m, PrimitiveMath.ZERO);
                for (i = 0; i < m; ++i) {
                    row = data[i];
                    data[m][i] = f = this.d[i];
                    g = this.e[i] + row[i] * f;
                    j2 = i + 1;
                    while (j2 < m) {
                        val = row[j2];
                        g += val * this.d[j2];
                        int n = j2++;
                        this.e[n] = this.e[n] + val * f;
                    }
                    this.e[i] = g;
                }
                f = PrimitiveMath.ZERO;
                for (j = 0; j < m; ++j) {
                    int n = j;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j] * this.d[j];
                }
                val = f / (h + h);
                AXPY.invoke(this.e, 0, 1, -val, this.d, 0, 1, 0, m);
                for (i = 0; i < m; ++i) {
                    row = data[i];
                    f = this.d[i];
                    g = this.e[i];
                    for (j2 = i; j2 < m; ++j2) {
                        int n = j2;
                        row[n] = row[n] - (f * this.e[j2] + g * this.d[j2]);
                    }
                    this.d[i] = row[m - 1];
                    row[m] = PrimitiveMath.ZERO;
                }
            }
            this.d[m] = h;
        }
        if (valuesOnly) {
            for (m = 0; m < size; ++m) {
                this.d[m] = data[m][m];
            }
        } else {
            for (m = 0; m < last; ++m) {
                row = data[m + 1];
                data[m][last] = data[m][m];
                data[m][m] = PrimitiveMath.ONE;
                h = this.d[m + 1];
                if (Double.compare(h, PrimitiveMath.ZERO) != 0) {
                    for (j = 0; j <= m; ++j) {
                        this.d[j] = row[j] / h;
                    }
                    for (i = 0; i <= m; ++i) {
                        val = DOT.invoke(row, 0, data[i], 0, 0, m + 1);
                        AXPY.invoke(data[i], 0, 1, -val, this.d, 0, 1, 0, m + 1);
                    }
                }
                Arrays.fill(row, 0, m + 1, PrimitiveMath.ZERO);
            }
            for (int i2 = 0; i2 < last; ++i2) {
                this.d[i2] = data[i2][last];
                data[i2][last] = PrimitiveMath.ZERO;
            }
            this.d[last] = data[last][last];
            data[last][last] = PrimitiveMath.ONE;
        }
        for (int k = 1; k < size; ++k) {
            this.e[k - 1] = this.e[k];
        }
        this.e[last] = PrimitiveMath.ZERO;
        RotateRight tmpRotateRight = valuesOnly ? RotateRight.NULL : new RotateRight(){

            @Override
            public void rotateRight(int low, int high, double cos, double sin) {
                double[] tmpVi0 = data[low];
                double[] tmpVi1 = data[high];
                for (int k = 0; k < size; ++k) {
                    double tmpVi0k = tmpVi0[k];
                    double tmpVi1k = tmpVi1[k];
                    tmpVi0[k] = cos * tmpVi0k - sin * tmpVi1k;
                    tmpVi1[k] = sin * tmpVi0k + cos * tmpVi1k;
                }
            }
        };
        HermitianEvD.tql2(this.d, this.e, tmpRotateRight);
        if (this.isOrdered()) {
            ExchangeColumns tmpExchangeColumns = valuesOnly ? ExchangeColumns.NULL : new ExchangeColumns(){

                @Override
                public void exchangeColumns(int colA, int colB) {
                    double[] tmp = data[colA];
                    data[colA] = data[colB];
                    data[colB] = tmp;
                }
            };
            EigenvalueDecomposition.sort(this.d, tmpExchangeColumns);
        }
    }

    double[] getImaginaryParts() {
        return this.e;
    }

    double[] getRealParts() {
        return this.d;
    }

    static final class Symmetric
    extends RawEigenvalue
    implements MatrixDecomposition.Solver<Double> {
        Symmetric() {
        }

        @Override
        public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
            long numberOfEquations = rhs.countRows();
            PrimitiveDenseStore tmpPreallocated = this.allocate(numberOfEquations, numberOfEquations);
            return this.getSolution(rhs, tmpPreallocated);
        }

        @Override
        public boolean isHermitian() {
            return true;
        }

        @Override
        public boolean isOrdered() {
            return true;
        }

        @Override
        public PhysicalStore<Double> preallocate(Structure2D template) {
            long numberOfEquations = template.countRows();
            return this.allocate(numberOfEquations, numberOfEquations);
        }

        @Override
        public PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
            return this.allocate(templateBody.countRows(), templateRHS.countColumns());
        }

        @Override
        protected boolean doDecompose(double[][] data, boolean valuesOnly) {
            this.doSymmetric(data, valuesOnly);
            return this.computed(true);
        }
    }

    static final class General
    extends RawEigenvalue {
        General() {
        }

        @Override
        public boolean isHermitian() {
            return false;
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        protected boolean doDecompose(double[][] data, boolean valuesOnly) {
            this.doGeneral(data, valuesOnly);
            return this.computed(true);
        }
    }

    static final class Dynamic
    extends RawEigenvalue {
        Dynamic() {
        }

        @Override
        public boolean isHermitian() {
            return this.checkSymmetry();
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        protected boolean doDecompose(double[][] data, boolean valuesOnly) {
            if (this.checkSymmetry()) {
                this.doSymmetric(data, valuesOnly);
            } else {
                this.doGeneral(data, valuesOnly);
            }
            return this.computed(true);
        }
    }
}

