/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.QRDecomposition;
import org.ojalgo.matrix.decomposition.RawQR;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public interface QR<N extends Number>
extends MatrixDecomposition<N>,
MatrixDecomposition.Solver<N>,
MatrixDecomposition.EconomySize<N>,
MatrixDecomposition.Determinant<N> {
    public static final Factory<BigDecimal> BIG = typical -> new QRDecomposition.Big();
    public static final Factory<ComplexNumber> COMPLEX = typical -> new QRDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> {
        if (typical.isFat() || 256L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
            return new QRDecomposition.Primitive();
        }
        return new RawQR();
    };

    public static <N extends Number> QR<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return (QR)BIG.make(typical);
        }
        if (tmpNumber instanceof ComplexNumber) {
            return (QR)COMPLEX.make(typical);
        }
        if (tmpNumber instanceof Double) {
            return (QR)PRIMITIVE.make(typical);
        }
        throw new IllegalArgumentException();
    }

    public static <N extends Number> boolean equals(MatrixStore<N> matrix, QR<N> decomposition, NumberContext context) {
        MatrixStore<MatrixStore<N>> tmpQ = decomposition.getQ();
        MatrixStore<N> tmpR = decomposition.getR();
        MatrixStore<MatrixStore<N>> tmpStore = tmpQ.multiply(tmpR);
        return AccessUtils.equals(tmpStore, matrix, context);
    }

    public static <N extends Number> MatrixStore<N> reconstruct(QR<N> decomposition) {
        return decomposition.getQ().multiply(decomposition.getR());
    }

    public MatrixStore<N> getQ();

    public MatrixStore<N> getR();

    public int getRank();

    public boolean isFullColumnRank();

    @Override
    default public MatrixStore<N> reconstruct() {
        return QR.reconstruct(this);
    }

    public static interface Factory<N extends Number>
    extends MatrixDecomposition.Factory<QR<N>> {
    }
}

