/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import org.ojalgo.constant.BigMath;
import org.ojalgo.finance.portfolio.EquilibriumModel;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.finance.portfolio.LowerUpper;
import org.ojalgo.finance.portfolio.MarketEquilibrium;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.type.TypeUtils;

abstract class OptimisedPortfolio
extends EquilibriumModel {
    static final String BALANCE = "Balance";
    static final String VARIANCE = "Variance";
    private final BasicMatrix myExpectedExcessReturns;
    private final Optimisation.Options myOptimisationOptions = new Optimisation.Options();
    private transient Optimisation.State myOptimisationState = Optimisation.State.UNEXPLORED;
    private boolean myShortingAllowed = false;
    private final Variable[] myVariables;

    OptimisedPortfolio(BasicMatrix covarianceMatrix, BasicMatrix expectedExcessReturns) {
        this(new MarketEquilibrium(covarianceMatrix), expectedExcessReturns);
    }

    OptimisedPortfolio(FinancePortfolio.Context portfolioContext) {
        super(portfolioContext);
        this.myExpectedExcessReturns = portfolioContext.getAssetReturns();
        String[] tmpSymbols = this.getMarketEquilibrium().getAssetKeys();
        this.myVariables = new Variable[tmpSymbols.length];
        for (int i = 0; i < tmpSymbols.length; ++i) {
            this.myVariables[i] = new Variable(tmpSymbols[i]);
            this.myVariables[i].weight(TypeUtils.toBigDecimal(this.myExpectedExcessReturns.get(i)).negate());
        }
        this.myOptimisationOptions.solution = this.myOptimisationOptions.solution.newPrecision(8).newScale(10);
    }

    OptimisedPortfolio(MarketEquilibrium marketEquilibrium, BasicMatrix expectedExcessReturns) {
        super(marketEquilibrium);
        if (marketEquilibrium.size() != (int)expectedExcessReturns.count()) {
            throw new IllegalArgumentException("Wrong dimensions!");
        }
        this.myExpectedExcessReturns = expectedExcessReturns;
        String[] tmpSymbols = this.getMarketEquilibrium().getAssetKeys();
        this.myVariables = new Variable[tmpSymbols.length];
        for (int i = 0; i < tmpSymbols.length; ++i) {
            this.myVariables[i] = new Variable(tmpSymbols[i]);
            this.myVariables[i].weight(TypeUtils.toBigDecimal(expectedExcessReturns.get(i)).negate());
        }
        this.myOptimisationOptions.solution = this.myOptimisationOptions.solution.newPrecision(8).newScale(10);
    }

    public final boolean isShortingAllowed() {
        return this.myShortingAllowed;
    }

    public Optimiser optimiser() {
        return new Optimiser();
    }

    public final void setShortingAllowed(boolean allowed) {
        this.myShortingAllowed = allowed;
        this.reset();
    }

    @Override
    protected final BasicMatrix calculateAssetReturns() {
        return this.myExpectedExcessReturns;
    }

    protected final BasicMatrix handle(Optimisation.Result optimisationResult) {
        int tmpLength = this.myVariables.length;
        this.myOptimisationState = optimisationResult.getState();
        boolean tmpFeasible = optimisationResult.getState().isFeasible();
        boolean tmpShortingAllowed = this.isShortingAllowed();
        BasicMatrix.Builder tmpMtrxBuilder = MATRIX_FACTORY.getBuilder(tmpLength);
        for (int i = 0; i < tmpLength; ++i) {
            BigDecimal tmpValue = tmpFeasible ? (tmpShortingAllowed ? optimisationResult.get(i) : optimisationResult.get(i).max(BigMath.ZERO)) : BigMath.ZERO;
            this.myVariables[i].setValue(tmpValue);
            tmpMtrxBuilder.set((long)i, tmpValue);
        }
        return (BasicMatrix)tmpMtrxBuilder.get();
    }

    @Override
    protected void reset() {
        super.reset();
        this.myOptimisationState = Optimisation.State.UNEXPLORED;
    }

    final Optimisation.Options getOptimisationOptions() {
        return this.myOptimisationOptions;
    }

    Variable getVariable(int index) {
        return this.myVariables[index];
    }

    final ExpressionsBasedModel makeModel(Map<int[], LowerUpper> constraints) {
        int i;
        int tmpLength = this.myVariables.length;
        Variable[] tmpVariables = new Variable[tmpLength];
        for (int i2 = 0; i2 < tmpVariables.length; ++i2) {
            tmpVariables[i2] = this.myVariables[i2].copy();
            if (this.isShortingAllowed() || this.myVariables[i2].getLowerLimit() != null && this.myVariables[i2].getLowerLimit().signum() != -1) continue;
            tmpVariables[i2].lower(BigMath.ZERO);
        }
        ExpressionsBasedModel retVal = new ExpressionsBasedModel(this.myOptimisationOptions);
        retVal.addVariables(tmpVariables);
        Expression myOptimisationVariance = retVal.addExpression(VARIANCE);
        BasicMatrix tmpCovariances = this.getCovariances();
        for (int j = 0; j < tmpLength; ++j) {
            for (i = 0; i < tmpLength; ++i) {
                myOptimisationVariance.set(i, j, (Number)tmpCovariances.get(i, j));
            }
        }
        Expression tmpBalanceExpression = retVal.addExpression(BALANCE);
        for (i = 0; i < tmpLength; ++i) {
            tmpBalanceExpression.set(i, (Number)BigMath.ONE);
        }
        tmpBalanceExpression.level(BigMath.ONE);
        for (Map.Entry<int[], LowerUpper> tmpEntry : constraints.entrySet()) {
            int[] tmpKey = tmpEntry.getKey();
            LowerUpper tmpValue = tmpEntry.getValue();
            Expression tmpExpression = retVal.addExpression(Arrays.toString(tmpKey));
            for (int i3 = 0; i3 < tmpKey.length; ++i3) {
                tmpExpression.set(tmpKey[i3], (Number)BigMath.ONE);
            }
            ((Expression)tmpExpression.lower(tmpValue.lower)).upper(tmpValue.upper);
        }
        return retVal;
    }

    public final class Optimiser {
        public Optimiser debug(boolean debug) {
            boolean tmpValidate = ((OptimisedPortfolio)OptimisedPortfolio.this).myOptimisationOptions.validate;
            if (debug) {
                OptimisedPortfolio.this.myOptimisationOptions.debug(Optimisation.Solver.class);
            } else {
                OptimisedPortfolio.this.myOptimisationOptions.debug(null);
            }
            ((OptimisedPortfolio)OptimisedPortfolio.this).myOptimisationOptions.validate = tmpValidate;
            return this;
        }

        public Optimisation.State getState() {
            if (OptimisedPortfolio.this.myOptimisationState == null) {
                OptimisedPortfolio.this.myOptimisationState = Optimisation.State.UNEXPLORED;
            }
            return OptimisedPortfolio.this.myOptimisationState;
        }

        public Optimiser validate(boolean validate) {
            ((OptimisedPortfolio)OptimisedPortfolio.this).myOptimisationOptions.validate = validate;
            return this;
        }
    }
}

