/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.util.Collections;
import java.util.Map;
import org.ojalgo.constant.BigMath;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.finance.portfolio.LowerUpper;
import org.ojalgo.finance.portfolio.MarketEquilibrium;
import org.ojalgo.finance.portfolio.OptimisedPortfolio;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;

public final class EfficientFrontier
extends OptimisedPortfolio {
    private static final Map<int[], LowerUpper> CONSTRAINTS = Collections.emptyMap();
    private final ExpressionsBasedModel myOptimisationModel = this.makeModel(CONSTRAINTS);

    public EfficientFrontier(BasicMatrix covarianceMatrix, BasicMatrix expectedExcessReturns) {
        super(covarianceMatrix, expectedExcessReturns);
    }

    public EfficientFrontier(FinancePortfolio.Context portfolioContext) {
        super(portfolioContext);
    }

    public EfficientFrontier(MarketEquilibrium marketEquilibrium, BasicMatrix expectedExcessReturns) {
        super(marketEquilibrium, expectedExcessReturns);
    }

    @Override
    protected BasicMatrix calculateAssetWeights() {
        this.myOptimisationModel.getExpression("Variance").weight(this.getRiskAversion().doubleValue() / 2.0);
        Optimisation.Result tmpResult = this.myOptimisationModel.minimise();
        return this.handle(tmpResult);
    }

    @Override
    protected void reset() {
        super.reset();
        boolean tmpAllowed = this.isShortingAllowed();
        this.myOptimisationModel.getVariables().forEach(v -> {
            Variable cfr_ignored_0 = (Variable)v.lower(tmpAllowed ? null : BigMath.ZERO);
        });
    }
}

