/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.OjAlgoUtils;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.random.Distribution;
import org.ojalgo.scalar.Scalar;

final class DenseStrategy<N extends Number> {
    static long CHUNK = 512L;
    static long INITIAL = 8L;
    static long SEGMENT = 32768L;
    private long myChunk = CHUNK;
    private final DenseArray.Factory<N> myDenseFactory;
    private long myInitial = INITIAL;
    private long mySegment = SEGMENT;

    static int capacity(long count) {
        double tmpInitialCapacity = count;
        while (tmpInitialCapacity > 2.147483639E9) {
            tmpInitialCapacity = PrimitiveFunction.SQRT.invoke(tmpInitialCapacity);
        }
        tmpInitialCapacity = PrimitiveFunction.SQRT.invoke(tmpInitialCapacity);
        return 2 * (int)tmpInitialCapacity;
    }

    DenseStrategy(DenseArray.Factory<N> denseFactory) {
        this.myDenseFactory = denseFactory;
        long tmpHalfTopLevelCacheElements = OjAlgoUtils.ENVIRONMENT.cache / 2L / denseFactory.getElementSize();
        this.segment(tmpHalfTopLevelCacheElements);
        long tmpMemoryPageElements = 4096L / denseFactory.getElementSize();
        this.chunk(tmpMemoryPageElements);
    }

    public AggregatorSet<N> aggregator() {
        return this.myDenseFactory.aggregator();
    }

    public FunctionSet<N> function() {
        return this.myDenseFactory.function();
    }

    public Scalar.Factory<N> scalar() {
        return this.myDenseFactory.scalar();
    }

    DenseStrategy<N> capacity(Distribution countDistribution) {
        double expected = countDistribution.getExpected();
        double stdDev = countDistribution.getStandardDeviation();
        this.chunk((long)stdDev);
        this.initial((long)(expected - (stdDev + stdDev)));
        return this;
    }

    long chunk() {
        return this.myChunk;
    }

    DenseStrategy<N> chunk(long chunk) {
        int power = PrimitiveMath.powerOf2Smaller(Math.min(chunk, this.mySegment));
        this.myChunk = 1L << power;
        return this;
    }

    int grow(int current) {
        return (int)this.grow((long)current);
    }

    long grow(long current) {
        long retVal;
        long required = current + 1L;
        if (required >= this.myChunk) {
            for (retVal = this.myChunk; retVal < required; retVal += this.myChunk) {
            }
        } else {
            for (long maybe = retVal / 2L; maybe >= required; maybe /= 2L) {
                retVal = maybe;
            }
        }
        return retVal;
    }

    int initial() {
        return (int)this.myInitial;
    }

    DenseStrategy<N> initial(long initial) {
        this.myInitial = Math.max(1L, initial);
        return this;
    }

    boolean isChunked(long count) {
        return count > this.myChunk;
    }

    boolean isSegmented(long count) {
        return count > this.mySegment;
    }

    DenseArray<N> make(long size) {
        return this.myDenseFactory.make(size);
    }

    DenseArray<N> makeChunk() {
        return this.make(this.myChunk);
    }

    DenseArray<N> makeInitial() {
        return this.make(this.myInitial);
    }

    DenseArray<N> makeSegment() {
        return this.make(this.mySegment);
    }

    SegmentedArray<N> makeSegmented(BasicArray<N> segment) {
        if (segment.count() == this.mySegment) {
            return this.myDenseFactory.wrapAsSegments(segment, this.makeChunk());
        }
        throw new IllegalStateException();
    }

    SegmentedArray<N> makeSegmented(long count) {
        return this.myDenseFactory.makeSegmented(count);
    }

    long segment() {
        return this.mySegment;
    }

    DenseStrategy<N> segment(long segment) {
        int power = PrimitiveMath.powerOf2Smaller(Math.max(this.myChunk, segment));
        this.mySegment = 1L << power;
        return this;
    }
}

