/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import org.apache.hadoop.nfs.NfsTime;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.oncrpc.XDR;

public class SETATTR3Request
extends RequestWithHandle {
    private final SetAttr3 attr;
    private final boolean check;
    private final NfsTime ctime;

    public static SETATTR3Request deserialize(XDR xdr) throws IOException {
        FileHandle handle = SETATTR3Request.readHandle(xdr);
        SetAttr3 attr = new SetAttr3();
        attr.deserialize(xdr);
        boolean check = xdr.readBoolean();
        NfsTime ctime = check ? NfsTime.deserialize(xdr) : null;
        return new SETATTR3Request(handle, attr, check, ctime);
    }

    public SETATTR3Request(FileHandle handle, SetAttr3 attr, boolean check, NfsTime ctime) {
        super(handle);
        this.attr = attr;
        this.check = check;
        this.ctime = ctime;
    }

    public SetAttr3 getAttr() {
        return this.attr;
    }

    public boolean isCheck() {
        return this.check;
    }

    public NfsTime getCtime() {
        return this.ctime;
    }

    @Override
    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        this.attr.serialize(xdr);
        xdr.writeBoolean(this.check);
        if (this.check) {
            this.ctime.serialize(xdr);
        }
    }
}

