/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.oncrpc.XDR;

public class READDIR3Request
extends RequestWithHandle {
    private final long cookie;
    private final long cookieVerf;
    private final int count;

    public static READDIR3Request deserialize(XDR xdr) throws IOException {
        FileHandle handle = READDIR3Request.readHandle(xdr);
        long cookie = xdr.readHyper();
        long cookieVerf = xdr.readHyper();
        int count = xdr.readInt();
        return new READDIR3Request(handle, cookie, cookieVerf, count);
    }

    public READDIR3Request(FileHandle handle, long cookie, long cookieVerf, int count) {
        super(handle);
        this.cookie = cookie;
        this.cookieVerf = cookieVerf;
        this.count = count;
    }

    public long getCookie() {
        return this.cookie;
    }

    public long getCookieVerf() {
        return this.cookieVerf;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        xdr.writeLongAsHyper(this.cookie);
        xdr.writeLongAsHyper(this.cookieVerf);
        xdr.writeInt(this.count);
    }
}

