/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.timelineservice;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.timelineservice.ServiceTimelineEntityType;
import org.apache.hadoop.yarn.service.timelineservice.ServiceTimelineEvent;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTimelinePublisher
extends CompositeService {
    public static final int ATS_CONFIG_PUBLISH_SIZE_BYTES = 10240;
    private TimelineV2Client timelineClient;
    private volatile boolean stopped = false;
    private static final Logger log = LoggerFactory.getLogger(ServiceTimelinePublisher.class);

    protected void serviceInit(org.apache.hadoop.conf.Configuration configuration) throws Exception {
        this.addService((org.apache.hadoop.service.Service)this.timelineClient);
        super.serviceInit(configuration);
    }

    protected void serviceStop() throws Exception {
        this.stopped = true;
        super.serviceStop();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public ServiceTimelinePublisher(TimelineV2Client client) {
        super(ServiceTimelinePublisher.class.getName());
        this.timelineClient = client;
    }

    public void serviceAttemptRegistered(Service service, org.apache.hadoop.conf.Configuration systemConf) {
        long currentTimeMillis = service.getLaunchTime() == null ? System.currentTimeMillis() : service.getLaunchTime().getTime();
        TimelineEntity entity = this.createServiceAttemptEntity(service.getId());
        entity.setCreatedTime(Long.valueOf(currentTimeMillis));
        HashMap<String, Object> entityInfos = new HashMap<String, Object>();
        entityInfos.put("NAME", service.getName());
        entityInfos.put("STATE", ServiceState.STARTED.toString());
        entityInfos.put("LAUNCH_TIME", currentTimeMillis);
        entity.addInfo("QUICK_LINKS", service.getQuicklinks());
        entity.addInfo(entityInfos);
        TimelineEvent startEvent = new TimelineEvent();
        startEvent.setId(ServiceTimelineEvent.SERVICE_ATTEMPT_REGISTERED.toString());
        startEvent.setTimestamp(currentTimeMillis);
        entity.addEvent(startEvent);
        this.putEntity(entity);
        this.populateTimelineEntity(systemConf.iterator(), service.getId(), ServiceTimelineEntityType.SERVICE_ATTEMPT.toString());
        this.publishContainerConf(service.getConfiguration(), service.getId(), ServiceTimelineEntityType.SERVICE_ATTEMPT.toString());
        this.publishComponents(service.getComponents());
    }

    public void serviceAttemptUpdated(Service service) {
        TimelineEntity entity = this.createServiceAttemptEntity(service.getId());
        entity.addInfo("QUICK_LINKS", service.getQuicklinks());
        this.putEntity(entity);
    }

    public void serviceAttemptUnregistered(ServiceContext context, FinalApplicationStatus status, String diagnostics) {
        TimelineEntity entity = this.createServiceAttemptEntity(context.attemptId.getApplicationId().toString());
        HashMap<String, Object> entityInfos = new HashMap<String, Object>();
        entityInfos.put("STATE", status);
        entityInfos.put("DIAGNOSTICS_INFO", diagnostics);
        entity.addInfo(entityInfos);
        TimelineEvent finishEvent = new TimelineEvent();
        finishEvent.setId(ServiceTimelineEvent.SERVICE_ATTEMPT_UNREGISTERED.toString());
        finishEvent.setTimestamp(System.currentTimeMillis());
        entity.addEvent(finishEvent);
        this.putEntity(entity);
    }

    public void componentInstanceStarted(Container container, ComponentInstance instance) {
        TimelineEntity entity = this.createComponentInstanceEntity(container.getId());
        entity.setCreatedTime(Long.valueOf(container.getLaunchTime().getTime()));
        HashMap<String, Object> entityInfos = new HashMap<String, Object>();
        entityInfos.put("BARE_HOST", container.getBareHost());
        entityInfos.put("STATE", container.getState().toString());
        entityInfos.put("LAUNCH_TIME", container.getLaunchTime().getTime());
        entityInfos.put("COMPONENT_NAME", instance.getCompName());
        entityInfos.put("COMPONENT_INSTANCE_NAME", instance.getCompInstanceName());
        entity.addInfo(entityInfos);
        TimelineEvent startEvent = new TimelineEvent();
        startEvent.setId(ServiceTimelineEvent.COMPONENT_INSTANCE_REGISTERED.toString());
        startEvent.setTimestamp(container.getLaunchTime().getTime());
        entity.addEvent(startEvent);
        this.putEntity(entity);
    }

    public void componentInstanceFinished(ContainerId containerId, int exitCode, ContainerState state, String diagnostics) {
        TimelineEntity entity = this.createComponentInstanceEntity(containerId.toString());
        HashMap<String, Object> entityInfos = new HashMap<String, Object>();
        entityInfos.put("EXIT_STATUS_CODE", exitCode);
        entityInfos.put("DIAGNOSTICS_INFO", diagnostics);
        entityInfos.put("STATE", (Object)state);
        entity.addInfo(entityInfos);
        TimelineEvent startEvent = new TimelineEvent();
        startEvent.setId(ServiceTimelineEvent.COMPONENT_INSTANCE_UNREGISTERED.toString());
        startEvent.setTimestamp(System.currentTimeMillis());
        entity.addEvent(startEvent);
        this.putEntity(entity);
    }

    public void componentInstanceIPHostUpdated(Container container) {
        TimelineEntity entity = this.createComponentInstanceEntity(container.getId());
        HashMap<String, Object> entityInfos = new HashMap<String, Object>();
        entityInfos.put("IP", container.getIp());
        entityInfos.put("EXPOSED_PORTS", container.getExposedPorts());
        entityInfos.put("HOSTNAME", container.getHostname());
        entityInfos.put("STATE", container.getState().toString());
        entity.addInfo(entityInfos);
        TimelineEvent updateEvent = new TimelineEvent();
        updateEvent.setId(ServiceTimelineEvent.COMPONENT_INSTANCE_IP_HOST_UPDATE.toString());
        updateEvent.setTimestamp(System.currentTimeMillis());
        entity.addEvent(updateEvent);
        this.putEntity(entity);
    }

    public void componentInstanceBecomeReady(Container container) {
        TimelineEntity entity = this.createComponentInstanceEntity(container.getId());
        HashMap<String, ContainerState> entityInfo = new HashMap<String, ContainerState>();
        entityInfo.put("STATE", ContainerState.READY);
        entity.addInfo(entityInfo);
        TimelineEvent updateEvent = new TimelineEvent();
        updateEvent.setId(ServiceTimelineEvent.COMPONENT_INSTANCE_BECOME_READY.toString());
        updateEvent.setTimestamp(System.currentTimeMillis());
        entity.addEvent(updateEvent);
        this.putEntity(entity);
    }

    private void publishComponents(List<Component> components) {
        long currentTimeMillis = System.currentTimeMillis();
        for (Component component : components) {
            TimelineEntity entity = this.createComponentEntity(component.getName());
            entity.setCreatedTime(Long.valueOf(currentTimeMillis));
            HashMap<String, Object> entityInfos = new HashMap<String, Object>();
            if (component.getArtifact() != null) {
                entityInfos.put("ARTIFACT_ID", component.getArtifact().getId());
                entityInfos.put("ARTIFACT_TYPE", component.getArtifact().getType().toString());
            }
            if (component.getResource() != null) {
                entityInfos.put("RESOURCE_CPU", component.getResource().getCpus());
                entityInfos.put("RESOURCE_MEMORY", component.getResource().getMemory());
                if (component.getResource().getProfile() != null) {
                    entityInfos.put("RESOURCE_PROFILE", component.getResource().getProfile());
                }
            }
            if (component.getLaunchCommand() != null) {
                entityInfos.put("LAUNCH_COMMAND", component.getLaunchCommand());
            }
            entityInfos.put("RUN_PRIVILEGED_CONTAINER", component.getRunPrivilegedContainer().toString());
            entity.addInfo(entityInfos);
            this.putEntity(entity);
            this.publishContainerConf(component.getConfiguration(), component.getName(), ServiceTimelineEntityType.COMPONENT.toString());
        }
    }

    private void publishContainerConf(Configuration configuration, String entityId, String entityType) {
        this.populateTimelineEntity(configuration.getEnv().entrySet().iterator(), entityId, entityType);
        for (ConfigFile configFile : configuration.getFiles()) {
            this.populateTimelineEntity(configFile.getProperties().entrySet().iterator(), entityId, entityType);
        }
    }

    private void populateTimelineEntity(Iterator<Map.Entry<String, String>> iterator, String entityId, String entityType) {
        int configSize = 0;
        TimelineEntity entity = this.createTimelineEntity(entityId, entityType);
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            int size = entry.getKey().length() + entry.getValue().length();
            if ((configSize += size) > 10240) {
                if (entity.getConfigs().size() > 0) {
                    this.putEntity(entity);
                    entity = this.createTimelineEntity(entityId, entityType);
                }
                configSize = size;
            }
            entity.addConfig(entry.getKey(), entry.getValue());
        }
        if (configSize > 0) {
            this.putEntity(entity);
        }
    }

    public void publishMetrics(Iterable<AbstractMetric> metrics, String entityId, String entityType, long timestamp) {
        TimelineEntity entity = this.createTimelineEntity(entityId, entityType);
        HashSet<TimelineMetric> entityMetrics = new HashSet<TimelineMetric>();
        for (AbstractMetric metric : metrics) {
            TimelineMetric timelineMetric = new TimelineMetric();
            timelineMetric.setId(metric.name());
            timelineMetric.addValue(timestamp, metric.value());
            entityMetrics.add(timelineMetric);
        }
        entity.setMetrics(entityMetrics);
        this.putEntity(entity);
    }

    private TimelineEntity createServiceAttemptEntity(String serviceId) {
        TimelineEntity entity = this.createTimelineEntity(serviceId, ServiceTimelineEntityType.SERVICE_ATTEMPT.toString());
        return entity;
    }

    private TimelineEntity createComponentInstanceEntity(String instanceId) {
        TimelineEntity entity = this.createTimelineEntity(instanceId, ServiceTimelineEntityType.COMPONENT_INSTANCE.toString());
        return entity;
    }

    private TimelineEntity createComponentEntity(String componentId) {
        TimelineEntity entity = this.createTimelineEntity(componentId, ServiceTimelineEntityType.COMPONENT.toString());
        return entity;
    }

    private TimelineEntity createTimelineEntity(String entityId, String entityType) {
        TimelineEntity entity = new TimelineEntity();
        entity.setId(entityId);
        entity.setType(entityType);
        return entity;
    }

    private void putEntity(TimelineEntity entity) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Publishing the entity " + entity + ", JSON-style content: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)entity));
            }
            if (this.timelineClient != null) {
                this.timelineClient.putEntitiesAsync(new TimelineEntity[]{entity});
            } else {
                log.error("Seems like client has been removed before the entity could be published for " + entity);
            }
        }
        catch (Exception e) {
            log.error("Error when publishing entity " + entity, (Throwable)e);
        }
    }

    public void componentFinished(Component comp, ComponentState state, long finishTime) {
        this.createComponentEntity(comp.getName());
        TimelineEntity entity = this.createComponentEntity(comp.getName());
        HashMap<String, ComponentState> entityInfos = new HashMap<String, ComponentState>();
        entityInfos.put("STATE", state);
        entity.addInfo(entityInfos);
        TimelineEvent startEvent = new TimelineEvent();
        startEvent.setId(ServiceTimelineEvent.COMPONENT_FINISHED.toString());
        startEvent.setTimestamp(finishTime);
        entity.addEvent(startEvent);
        this.putEntity(entity);
    }
}

