/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.service.api.records.PlacementScope;
import org.apache.hadoop.yarn.service.api.records.PlacementType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="Placement constraint details.")
public class PlacementConstraint
implements Serializable {
    private static final long serialVersionUID = 1518017165676511762L;
    private String name = null;
    private PlacementType type = null;
    private PlacementScope scope = null;
    @JsonProperty(value="target_tags")
    @XmlElement(name="target_tags")
    private List<String> targetTags = new ArrayList<String>();
    @JsonProperty(value="node_attributes")
    @XmlElement(name="node_attributes")
    private Map<String, List<String>> nodeAttributes = new HashMap<String, List<String>>();
    @JsonProperty(value="node_partitions")
    @XmlElement(name="node_partitions")
    private List<String> nodePartitions = new ArrayList<String>();
    @JsonProperty(value="min_cardinality")
    @XmlElement(name="min_cardinality")
    private Long minCardinality = null;
    @JsonProperty(value="max_cardinality")
    @XmlElement(name="max_cardinality")
    private Long maxCardinality = null;

    public PlacementConstraint name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="C1", required=true)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PlacementConstraint type(PlacementType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true)
    @JsonProperty(value="type")
    public PlacementType getType() {
        return this.type;
    }

    public void setType(PlacementType type) {
        this.type = type;
    }

    public PlacementConstraint scope(PlacementScope scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(example="null", required=true)
    @JsonProperty(value="scope")
    public PlacementScope getScope() {
        return this.scope;
    }

    public void setScope(PlacementScope scope) {
        this.scope = scope;
    }

    public PlacementConstraint targetTags(List<String> targetTags) {
        this.targetTags = targetTags;
        return this;
    }

    @ApiModelProperty(example="[\"hbase-regionserver\"]")
    public List<String> getTargetTags() {
        return this.targetTags;
    }

    public void setTargetTags(List<String> targetTags) {
        this.targetTags = targetTags;
    }

    public PlacementConstraint nodeAttributes(Map<String, List<String>> nodeAttributes) {
        this.nodeAttributes = nodeAttributes;
        return this;
    }

    @ApiModelProperty(example="\"JavaVersion\":[\"1.7\", \"1.8\"]")
    public Map<String, List<String>> getNodeAttributes() {
        return this.nodeAttributes;
    }

    public void setNodeAttributes(Map<String, List<String>> nodeAttributes) {
        this.nodeAttributes = nodeAttributes;
    }

    public PlacementConstraint nodePartitions(List<String> nodePartitions) {
        this.nodePartitions = nodePartitions;
        return this;
    }

    @ApiModelProperty(example="[\"gpu\", \"fast_disk\"]")
    public List<String> getNodePartitions() {
        return this.nodePartitions;
    }

    public void setNodePartitions(List<String> nodePartitions) {
        this.nodePartitions = nodePartitions;
    }

    public PlacementConstraint minCardinality(Long minCardinality) {
        this.minCardinality = minCardinality;
        return this;
    }

    @ApiModelProperty(example="2")
    public Long getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(Long minCardinality) {
        this.minCardinality = minCardinality;
    }

    public PlacementConstraint maxCardinality(Long maxCardinality) {
        this.maxCardinality = maxCardinality;
        return this;
    }

    @ApiModelProperty(example="3")
    public Long getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(Long maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlacementConstraint placementConstraint = (PlacementConstraint)o;
        return Objects.equals(this.name, placementConstraint.name) && Objects.equals((Object)this.type, (Object)placementConstraint.type) && Objects.equals((Object)this.scope, (Object)placementConstraint.scope) && Objects.equals(this.targetTags, placementConstraint.targetTags) && Objects.equals(this.nodeAttributes, placementConstraint.nodeAttributes) && Objects.equals(this.nodePartitions, placementConstraint.nodePartitions) && Objects.equals(this.minCardinality, placementConstraint.minCardinality) && Objects.equals(this.maxCardinality, placementConstraint.maxCardinality);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.scope, this.targetTags, this.nodeAttributes, this.nodePartitions, this.minCardinality, this.maxCardinality});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlacementConstraint {\n").append("    name: ").append(this.toIndentedString(this.name)).append("\n").append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n").append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n").append("    targetTags: ").append(this.toIndentedString(this.targetTags)).append("\n").append("    nodeAttributes: ").append(this.toIndentedString(this.nodeAttributes)).append("\n").append("    nodePartitions: ").append(this.toIndentedString(this.nodePartitions)).append("\n").append("    minCardinality: ").append(this.toIndentedString(this.minCardinality)).append("\n").append("    maxCardinality: ").append(this.toIndentedString(this.maxCardinality)).append("\n").append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

