/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.clientrm.ClientRequestInterceptor;
import org.apache.hadoop.yarn.server.router.security.RouterDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.router.security.authorize.RouterPolicyProvider;
import org.apache.hadoop.yarn.util.LRUCacheHashMap;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterClientRMService
extends AbstractService
implements ApplicationClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(RouterClientRMService.class);
    private Server server;
    private InetSocketAddress listenerEndpoint;
    private Map<String, RequestInterceptorChainWrapper> userPipelineMap;
    private URL redirectURL;
    private RouterDelegationTokenSecretManager routerDTSecretManager;

    public RouterClientRMService() {
        super(RouterClientRMService.class.getName());
    }

    protected void serviceStart() throws Exception {
        LOG.info("Starting Router ClientRMService.");
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.listenerEndpoint = conf.getSocketAddr("yarn.router.bind-host", "yarn.router.clientrm.address", "0.0.0.0:8050", 8050);
        if (RouterServerUtil.isRouterWebProxyEnable(conf)) {
            this.redirectURL = this.getRedirectURL();
        }
        int maxCacheSize = conf.getInt("yarn.router.pipeline.cache-max-size", 25);
        this.userPipelineMap = Collections.synchronizedMap(new LRUCacheHashMap(maxCacheSize, true));
        Configuration serverConf = new Configuration(conf);
        int numWorkerThreads = serverConf.getInt("yarn.resourcemanager.client.thread-count", 50);
        this.routerDTSecretManager = this.createRouterRMDelegationTokenSecretManager(conf);
        this.routerDTSecretManager.startThreads();
        this.server = rpc.getServer(ApplicationClientProtocol.class, (Object)this, this.listenerEndpoint, serverConf, (SecretManager)this.routerDTSecretManager, numWorkerThreads);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, RouterPolicyProvider.getInstance());
        }
        this.server.start();
        LOG.info("Router ClientRMService listening on address: {}.", (Object)this.server.getListenerAddress());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        LOG.info("Stopping Router ClientRMService.");
        if (this.server != null) {
            this.server.stop();
        }
        this.userPipelineMap.clear();
        super.serviceStop();
    }

    @VisibleForTesting
    public Server getServer() {
        return this.server;
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getNewApplication(request);
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().submitApplication(request);
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().forceKillApplication(request);
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getClusterMetrics(request);
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getClusterNodes(request);
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getQueueInfo(request);
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getQueueUserAcls(request);
    }

    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().moveApplicationAcrossQueues(request);
    }

    public GetNewReservationResponse getNewReservation(GetNewReservationRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getNewReservation(request);
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().submitReservation(request);
    }

    public ReservationListResponse listReservations(ReservationListRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().listReservations(request);
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().updateReservation(request);
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().deleteReservation(request);
    }

    public GetNodesToLabelsResponse getNodeToLabels(GetNodesToLabelsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getNodeToLabels(request);
    }

    public GetLabelsToNodesResponse getLabelsToNodes(GetLabelsToNodesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getLabelsToNodes(request);
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getClusterNodeLabels(request);
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        GetApplicationReportResponse response = pipeline.getRootInterceptor().getApplicationReport(request);
        if (RouterServerUtil.isRouterWebProxyEnable(this.getConfig())) {
            URL url = new URL(response.getApplicationReport().getTrackingUrl());
            String redirectUrl = new URL(this.redirectURL.getProtocol(), this.redirectURL.getHost(), this.redirectURL.getPort(), url.getFile()).toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("The tracking url of application {} is redirect from {} to {}", new Object[]{response.getApplicationReport().getApplicationId(), url, redirectUrl});
            }
            response.getApplicationReport().setTrackingUrl(redirectUrl);
        }
        return response;
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getApplications(request);
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getApplicationAttemptReport(request);
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getApplicationAttempts(request);
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getContainerReport(request);
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getContainers(request);
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getDelegationToken(request);
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().renewDelegationToken(request);
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().cancelDelegationToken(request);
    }

    public FailApplicationAttemptResponse failApplicationAttempt(FailApplicationAttemptRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().failApplicationAttempt(request);
    }

    public UpdateApplicationPriorityResponse updateApplicationPriority(UpdateApplicationPriorityRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().updateApplicationPriority(request);
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().signalToContainer(request);
    }

    public UpdateApplicationTimeoutsResponse updateApplicationTimeouts(UpdateApplicationTimeoutsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().updateApplicationTimeouts(request);
    }

    public GetAllResourceProfilesResponse getResourceProfiles(GetAllResourceProfilesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getResourceProfiles(request);
    }

    public GetResourceProfileResponse getResourceProfile(GetResourceProfileRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getResourceProfile(request);
    }

    public GetAllResourceTypeInfoResponse getResourceTypeInfo(GetAllResourceTypeInfoRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getResourceTypeInfo(request);
    }

    public GetAttributesToNodesResponse getAttributesToNodes(GetAttributesToNodesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getAttributesToNodes(request);
    }

    public GetClusterNodeAttributesResponse getClusterNodeAttributes(GetClusterNodeAttributesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getClusterNodeAttributes(request);
    }

    public GetNodesToAttributesResponse getNodesToAttributes(GetNodesToAttributesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getNodesToAttributes(request);
    }

    @VisibleForTesting
    public RequestInterceptorChainWrapper getInterceptorChain() throws IOException {
        String user = UserGroupInformation.getCurrentUser().getUserName();
        RequestInterceptorChainWrapper chain = this.userPipelineMap.get(user);
        if (chain != null && chain.getRootInterceptor() != null) {
            return chain;
        }
        return this.initializePipeline(user);
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    @VisibleForTesting
    protected Map<String, RequestInterceptorChainWrapper> getPipelines() {
        return this.userPipelineMap;
    }

    @VisibleForTesting
    protected ClientRequestInterceptor createRequestInterceptorChain() {
        Configuration conf = this.getConfig();
        return RouterServerUtil.createRequestInterceptorChain(conf, "yarn.router.clientrm.interceptor-class.pipeline", "org.apache.hadoop.yarn.server.router.clientrm.DefaultClientRequestInterceptor", ClientRequestInterceptor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInterceptorChainWrapper initializePipeline(String user) {
        Map<String, RequestInterceptorChainWrapper> map = this.userPipelineMap;
        synchronized (map) {
            if (this.userPipelineMap.containsKey(user)) {
                LOG.info("Request to start an already existing user: {} was received, so ignoring.", (Object)user);
                return this.userPipelineMap.get(user);
            }
            RequestInterceptorChainWrapper chainWrapper = new RequestInterceptorChainWrapper();
            try {
                LOG.info("Initializing request processing pipeline for application for the user: {}.", (Object)user);
                ClientRequestInterceptor interceptorChain = this.createRequestInterceptorChain();
                interceptorChain.init(user);
                if (this.routerDTSecretManager != null) {
                    interceptorChain.setTokenSecretManager(this.routerDTSecretManager);
                }
                chainWrapper.init(interceptorChain);
            }
            catch (Exception e) {
                LOG.error("Init ClientRequestInterceptor error for user: {}.", (Object)user, (Object)e);
                throw e;
            }
            this.userPipelineMap.put(user, chainWrapper);
            return chainWrapper;
        }
    }

    @VisibleForTesting
    public Map<String, RequestInterceptorChainWrapper> getUserPipelineMap() {
        return this.userPipelineMap;
    }

    protected RouterDelegationTokenSecretManager createRouterRMDelegationTokenSecretManager(Configuration conf) {
        long secretKeyInterval = conf.getLong("yarn.resourcemanager.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = conf.getLong("yarn.resourcemanager.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = conf.getLong("yarn.resourcemanager.delegation.token.renew-interval", 86400000L);
        long removeScanInterval = conf.getTimeDuration("yarn.resourcemanager.delegation.token.remove-scan-interval", 3600000L, TimeUnit.MILLISECONDS);
        return new RouterDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, removeScanInterval, conf);
    }

    @VisibleForTesting
    public RouterDelegationTokenSecretManager getRouterDTSecretManager() {
        return this.routerDTSecretManager;
    }

    @VisibleForTesting
    public void setRouterDTSecretManager(RouterDelegationTokenSecretManager routerDTSecretManager) {
        this.routerDTSecretManager = routerDTSecretManager;
    }

    @VisibleForTesting
    public void initUserPipelineMap(Configuration conf) {
        int maxCacheSize = conf.getInt("yarn.router.pipeline.cache-max-size", 25);
        this.userPipelineMap = Collections.synchronizedMap(new LRUCacheHashMap(maxCacheSize, true));
    }

    private URL getRedirectURL() throws Exception {
        Configuration conf = this.getConfig();
        String webAppAddress = WebAppUtils.getWebAppBindURL((Configuration)conf, (String)"yarn.router.bind-host", (String)WebAppUtils.getRouterWebAppURLWithoutScheme((Configuration)conf));
        String[] hostPort = StringUtils.split((String)webAppAddress, (char)':');
        if (hostPort.length != 2) {
            throw new YarnRuntimeException("Router can't get valid redirect proxy url");
        }
        String host = hostPort[0];
        int port = Integer.parseInt(hostPort[1]);
        if (StringUtils.isBlank((CharSequence)host) || host.equals("0.0.0.0")) {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        return new URL(YarnConfiguration.useHttps((Configuration)this.getConfig()) ? "https" : "http", host, port, "");
    }

    @InterfaceAudience.Private
    public static class RequestInterceptorChainWrapper {
        private ClientRequestInterceptor rootInterceptor;

        public synchronized void init(ClientRequestInterceptor interceptor) {
            this.rootInterceptor = interceptor;
        }

        public synchronized ClientRequestInterceptor getRootInterceptor() {
            return this.rootInterceptor;
        }

        protected void finalize() {
            this.rootInterceptor.shutdown();
        }
    }
}

