/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.RegexCopyFilter;
import org.apache.hadoop.tools.TrueCopyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CopyFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CopyFilter.class);

    public void initialize() {
    }

    public abstract boolean shouldCopy(Path var1);

    public static CopyFilter getCopyFilter(Configuration conf) {
        String filtersClassName = conf.get("distcp.filters.class");
        if (filtersClassName != null) {
            try {
                Class<CopyFilter> filtersClass = conf.getClassByName(filtersClassName).asSubclass(CopyFilter.class);
                filtersClassName = filtersClass.getName();
                Constructor<CopyFilter> constructor = filtersClass.getDeclaredConstructor(Configuration.class);
                return constructor.newInstance(conf);
            }
            catch (Exception e) {
                LOG.error("Unable to instantiate " + filtersClassName, (Throwable)e);
                throw new RuntimeException("Unable to instantiate " + filtersClassName, e);
            }
        }
        return CopyFilter.getDefaultCopyFilter(conf);
    }

    private static CopyFilter getDefaultCopyFilter(Configuration conf) {
        String filtersFilename = conf.get("distcp.filters.file");
        if (filtersFilename == null) {
            return new TrueCopyFilter();
        }
        String filterFilename = conf.get("distcp.filters.file");
        return new RegexCopyFilter(filterFilename);
    }
}

