/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.vault.ksm.secret;

import com.google.inject.Singleton;
import com.keepersecurity.secretsManager.core.HiddenField;
import com.keepersecurity.secretsManager.core.Host;
import com.keepersecurity.secretsManager.core.Hosts;
import com.keepersecurity.secretsManager.core.KeeperFile;
import com.keepersecurity.secretsManager.core.KeeperRecord;
import com.keepersecurity.secretsManager.core.KeeperRecordData;
import com.keepersecurity.secretsManager.core.KeeperRecordField;
import com.keepersecurity.secretsManager.core.KeyPair;
import com.keepersecurity.secretsManager.core.KeyPairs;
import com.keepersecurity.secretsManager.core.Login;
import com.keepersecurity.secretsManager.core.PamHostnames;
import com.keepersecurity.secretsManager.core.Password;
import com.keepersecurity.secretsManager.core.SecretsManager;
import com.keepersecurity.secretsManager.core.Text;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
public class KsmRecordService {
    private static final Pattern DOMAIN_LABEL_PATTERN = Pattern.compile("domain", 2);
    private static final Pattern HOSTNAME_LABEL_PATTERN = Pattern.compile("hostname|(ip\\s*)?address", 2);
    private static final Pattern USERNAME_LABEL_PATTERN = Pattern.compile("username", 2);
    private static final Pattern PASSWORD_LABEL_PATTERN = Pattern.compile("password", 2);
    private static final Pattern PASSPHRASE_LABEL_PATTERN = Pattern.compile("passphrase", 2);
    private static final Pattern PRIVATE_KEY_CUSTOM_LABEL_PATTERN = Pattern.compile("private\\s*key", 2);
    private static final Pattern PRIVATE_KEY_STANDARD_LABEL_PATTERN = Pattern.compile("private\\s*pem\\s*key", 2);
    private static final Pattern PRIVATE_KEY_FILENAME_PATTERN = Pattern.compile(".*\\.pem", 2);

    private <T> T getSingleValue(List<T> values) {
        if (values == null || values.size() != 1) {
            return null;
        }
        return values.get(0);
    }

    private String getSingleStringValue(List<String> values) {
        String value = this.getSingleValue(values);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return null;
    }

    private <T, R> R getSingleValue(List<T> values, Function<T, R> mapper) {
        T value = this.getSingleValue(values);
        if (value == null) {
            return null;
        }
        return mapper.apply(value);
    }

    private <T> String getSingleStringValue(List<T> values, Function<T, String> mapper) {
        String value = this.getSingleValue(values, mapper);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return null;
    }

    private <T extends KeeperRecordField> T getField(List<KeeperRecordField> fields, Class<T> fieldClass, Pattern labelPattern) {
        if (fields == null) {
            return null;
        }
        KeeperRecordField foundField = null;
        for (KeeperRecordField field : fields) {
            Matcher labelMatcher;
            String label;
            if (!fieldClass.isAssignableFrom(field.getClass()) || labelPattern != null && ((label = field.getLabel()) == null || !(labelMatcher = labelPattern.matcher(label)).matches())) continue;
            if (foundField != null) {
                return null;
            }
            foundField = field;
        }
        return (T)foundField;
    }

    private <T extends KeeperRecordField> T getField(KeeperRecord record, Class<T> fieldClass, Pattern labelPattern) {
        KeeperRecordData data = record.getData();
        T field = this.getField(data.getFields(), fieldClass, null);
        if (field != null) {
            return field;
        }
        return this.getField(data.getCustom(), fieldClass, labelPattern);
    }

    private KeeperFile getFile(KeeperRecord record, Pattern filenamePattern) {
        List files = record.getFiles();
        if (files == null) {
            return null;
        }
        KeeperFile foundFile = null;
        for (KeeperFile file : files) {
            Matcher filenameMatcher = filenamePattern.matcher(file.getData().getName());
            if (!filenameMatcher.matches()) continue;
            if (foundFile != null) {
                return null;
            }
            foundFile = file;
        }
        return foundFile;
    }

    public Future<String> download(KeeperFile file) {
        if (file == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> new String(SecretsManager.downloadFile((KeeperFile)file), StandardCharsets.UTF_8));
    }

    public String getHostname(KeeperRecord record) {
        Hosts hostsField = this.getField(record, Hosts.class, null);
        if (hostsField != null) {
            return this.getSingleStringValue(hostsField.getValue(), Host::getHostName);
        }
        PamHostnames pamHostsField = this.getField(record, PamHostnames.class, null);
        if (pamHostsField != null) {
            return this.getSingleStringValue(pamHostsField.getValue(), Host::getHostName);
        }
        KeeperRecordData data = record.getData();
        List custom = data.getCustom();
        Text textField = this.getField(custom, Text.class, HOSTNAME_LABEL_PATTERN);
        if (textField != null) {
            return this.getSingleStringValue(textField.getValue());
        }
        HiddenField hiddenField = this.getField(custom, HiddenField.class, HOSTNAME_LABEL_PATTERN);
        if (hiddenField != null) {
            return this.getSingleStringValue(hiddenField.getValue());
        }
        return null;
    }

    public String getUsername(KeeperRecord record) {
        Login loginField = this.getField(record, Login.class, null);
        if (loginField != null) {
            return this.getSingleStringValue(loginField.getValue());
        }
        KeeperRecordData data = record.getData();
        List custom = data.getCustom();
        Text textField = this.getField(custom, Text.class, USERNAME_LABEL_PATTERN);
        if (textField != null) {
            return this.getSingleStringValue(textField.getValue());
        }
        HiddenField hiddenField = this.getField(custom, HiddenField.class, USERNAME_LABEL_PATTERN);
        if (hiddenField != null) {
            return this.getSingleStringValue(hiddenField.getValue());
        }
        return null;
    }

    public String getDomain(KeeperRecord record) {
        KeeperRecordData data = record.getData();
        List custom = data.getCustom();
        Text textField = this.getField(custom, Text.class, DOMAIN_LABEL_PATTERN);
        if (textField != null) {
            return this.getSingleStringValue(textField.getValue());
        }
        HiddenField hiddenField = this.getField(custom, HiddenField.class, DOMAIN_LABEL_PATTERN);
        if (hiddenField != null) {
            return this.getSingleStringValue(hiddenField.getValue());
        }
        return null;
    }

    public String getPassword(KeeperRecord record) {
        Password passwordField = this.getField(record, Password.class, PASSWORD_LABEL_PATTERN);
        if (passwordField != null) {
            return this.getSingleStringValue(passwordField.getValue());
        }
        HiddenField hiddenField = this.getField(record, HiddenField.class, PASSWORD_LABEL_PATTERN);
        if (hiddenField != null) {
            return this.getSingleStringValue(hiddenField.getValue());
        }
        return null;
    }

    public Future<String> getPrivateKey(KeeperRecord record) {
        String privateKey;
        KeyPairs keyPairsField = this.getField(record, KeyPairs.class, PRIVATE_KEY_CUSTOM_LABEL_PATTERN);
        if (keyPairsField != null && (privateKey = this.getSingleStringValue(keyPairsField.getValue(), KeyPair::getPrivateKey)) != null && !privateKey.isEmpty()) {
            return CompletableFuture.completedFuture(privateKey);
        }
        KeeperFile keyFile = this.getFile(record, PRIVATE_KEY_FILENAME_PATTERN);
        if (keyFile != null) {
            return this.download(keyFile);
        }
        KeeperRecordData data = record.getData();
        List custom = data.getCustom();
        HiddenField hiddenField = this.getField(data.getFields(), HiddenField.class, PRIVATE_KEY_STANDARD_LABEL_PATTERN);
        if (hiddenField != null) {
            return CompletableFuture.completedFuture(this.getSingleStringValue(hiddenField.getValue()));
        }
        Password passwordField = this.getField(custom, Password.class, PRIVATE_KEY_CUSTOM_LABEL_PATTERN);
        if (passwordField != null) {
            return CompletableFuture.completedFuture(this.getSingleStringValue(passwordField.getValue()));
        }
        hiddenField = this.getField(custom, HiddenField.class, PRIVATE_KEY_CUSTOM_LABEL_PATTERN);
        if (hiddenField != null) {
            return CompletableFuture.completedFuture(this.getSingleStringValue(hiddenField.getValue()));
        }
        return CompletableFuture.completedFuture(null);
    }

    public String getPassphrase(KeeperRecord record) {
        Password passwordField;
        KeeperRecordData data = record.getData();
        List fields = data.getFields();
        List custom = data.getCustom();
        if (this.getField(fields, KeyPairs.class, null) != null && (passwordField = this.getField(fields, Password.class, null)) != null) {
            return this.getSingleStringValue(passwordField.getValue());
        }
        passwordField = this.getField(custom, Password.class, PASSPHRASE_LABEL_PATTERN);
        if (passwordField != null) {
            return this.getSingleStringValue(passwordField.getValue());
        }
        HiddenField hiddenField = this.getField(custom, HiddenField.class, PASSPHRASE_LABEL_PATTERN);
        if (hiddenField != null) {
            return this.getSingleStringValue(hiddenField.getValue());
        }
        return null;
    }
}

